/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import com.google.cloud.tools.jib.api.CacheDirectoryCreationException;
import com.google.cloud.tools.jib.api.InvalidImageReferenceException;
import com.google.cloud.tools.jib.filesystem.TempDirectoryProvider;
import com.google.cloud.tools.jib.maven.JibPluginConfiguration;
import com.google.cloud.tools.jib.maven.MavenHelpfulSuggestions;
import com.google.cloud.tools.jib.maven.MavenProjectProperties;
import com.google.cloud.tools.jib.maven.MavenRawConfiguration;
import com.google.cloud.tools.jib.maven.MavenSettingsProxyProvider;
import com.google.cloud.tools.jib.maven.MavenSettingsServerCredentials;
import com.google.cloud.tools.jib.maven.MojoCommon;
import com.google.cloud.tools.jib.plugins.common.BuildStepsExecutionException;
import com.google.cloud.tools.jib.plugins.common.HelpfulSuggestions;
import com.google.cloud.tools.jib.plugins.common.IncompatibleBaseImageJavaVersionException;
import com.google.cloud.tools.jib.plugins.common.InvalidAppRootException;
import com.google.cloud.tools.jib.plugins.common.InvalidContainerVolumeException;
import com.google.cloud.tools.jib.plugins.common.InvalidContainerizingModeException;
import com.google.cloud.tools.jib.plugins.common.InvalidCreationTimeException;
import com.google.cloud.tools.jib.plugins.common.InvalidFilesModificationTimeException;
import com.google.cloud.tools.jib.plugins.common.InvalidWorkingDirectoryException;
import com.google.cloud.tools.jib.plugins.common.MainClassInferenceException;
import com.google.cloud.tools.jib.plugins.common.PluginConfigurationProcessor;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="buildTar", requiresDependencyResolution=ResolutionScope.RUNTIME_PLUS_SYSTEM, threadSafe=true)
public class BuildTarMojo
extends JibPluginConfiguration {
    @VisibleForTesting
    static final String GOAL_NAME = "buildTar";
    private static final String HELPFUL_SUGGESTIONS_PREFIX = "Building image tarball failed";

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.checkJibVersion();
        if (this.isSkipped()) {
            this.getLog().info((CharSequence)"Skipping containerization because jib-maven-plugin: skip = true");
            return;
        }
        if (!this.isContainerizable()) {
            this.getLog().info((CharSequence)"Skipping containerization of this module (not specified in jib.containerize)");
            return;
        }
        if ("pom".equals(this.getProject().getPackaging())) {
            this.getLog().info((CharSequence)"Skipping containerization because packaging is 'pom'...");
            return;
        }
        MojoCommon.checkUseCurrentTimestampDeprecation(this);
        MavenSettingsProxyProvider.activateHttpAndHttpsProxies(this.getSession().getSettings(), this.getSettingsDecrypter());
        TempDirectoryProvider tempDirectoryProvider = new TempDirectoryProvider();
        MavenProjectProperties projectProperties = MavenProjectProperties.getForProject(this.getProject(), this.getSession(), this.getLog(), tempDirectoryProvider);
        try {
            PluginConfigurationProcessor.createJibBuildRunnerForTarImage(new MavenRawConfiguration(this), new MavenSettingsServerCredentials(this.getSession().getSettings(), this.getSettingsDecrypter()), projectProperties, new MavenHelpfulSuggestions(HELPFUL_SUGGESTIONS_PREFIX)).runBuild();
        }
        catch (InvalidAppRootException ex) {
            throw new MojoExecutionException("<container><appRoot> is not an absolute Unix-style path: " + ex.getInvalidPathValue(), (Exception)ex);
        }
        catch (InvalidContainerizingModeException ex) {
            throw new MojoExecutionException("invalid value for <containerizingMode>: " + ex.getInvalidContainerizingMode(), (Exception)ex);
        }
        catch (InvalidWorkingDirectoryException ex) {
            throw new MojoExecutionException("<container><workingDirectory> is not an absolute Unix-style path: " + ex.getInvalidPathValue(), (Exception)ex);
        }
        catch (InvalidContainerVolumeException ex) {
            throw new MojoExecutionException("<container><volumes> is not an absolute Unix-style path: " + ex.getInvalidVolume(), (Exception)ex);
        }
        catch (InvalidFilesModificationTimeException ex) {
            throw new MojoExecutionException("<container><filesModificationTime> should be an ISO 8601 date-time (see DateTimeFormatter.ISO_DATE_TIME) or special keyword \"EPOCH_PLUS_SECOND\": " + ex.getInvalidFilesModificationTime(), (Exception)ex);
        }
        catch (InvalidCreationTimeException ex) {
            throw new MojoExecutionException("<container><creationTime> should be an ISO 8601 date-time (see DateTimeFormatter.ISO_DATE_TIME) or a special keyword (\"EPOCH\", \"USE_CURRENT_TIMESTAMP\"): " + ex.getInvalidCreationTime(), (Exception)ex);
        }
        catch (IncompatibleBaseImageJavaVersionException ex) {
            throw new MojoExecutionException(HelpfulSuggestions.forIncompatibleBaseImageJavaVersionForMaven(ex.getBaseImageMajorJavaVersion(), ex.getProjectMajorJavaVersion()), (Exception)ex);
        }
        catch (InvalidImageReferenceException ex) {
            throw new MojoExecutionException(HelpfulSuggestions.forInvalidImageReference(ex.getInvalidReference()), (Exception)ex);
        }
        catch (CacheDirectoryCreationException | MainClassInferenceException | IOException ex) {
            throw new MojoExecutionException(ex.getMessage(), ex);
        }
        catch (BuildStepsExecutionException ex) {
            throw new MojoExecutionException(ex.getMessage(), ex.getCause());
        }
        finally {
            tempDirectoryProvider.close();
            projectProperties.waitForLoggingThread();
            this.getLog().info((CharSequence)"");
        }
    }
}

