/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry;

import com.google.api.client.http.HttpResponseException;
import com.google.cloud.tools.jib.api.DescriptorDigest;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.http.BlobHttpContent;
import com.google.cloud.tools.jib.http.Response;
import com.google.cloud.tools.jib.registry.ErrorCodes;
import com.google.cloud.tools.jib.registry.ErrorResponseUtil;
import com.google.cloud.tools.jib.registry.RegistryEndpointProvider;
import com.google.cloud.tools.jib.registry.RegistryEndpointRequestProperties;
import com.google.cloud.tools.jib.registry.RegistryErrorException;
import com.google.cloud.tools.jib.registry.RegistryErrorExceptionBuilder;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

class BlobChecker
implements RegistryEndpointProvider<Optional<BlobDescriptor>> {
    private final RegistryEndpointRequestProperties registryEndpointRequestProperties;
    private final DescriptorDigest blobDigest;

    BlobChecker(RegistryEndpointRequestProperties registryEndpointRequestProperties, DescriptorDigest blobDigest) {
        this.registryEndpointRequestProperties = registryEndpointRequestProperties;
        this.blobDigest = blobDigest;
    }

    @Override
    public Optional<BlobDescriptor> handleResponse(Response response) throws RegistryErrorException {
        long contentLength = response.getContentLength();
        if (contentLength < 0L) {
            throw new RegistryErrorExceptionBuilder(this.getActionDescription()).addReason("Did not receive Content-Length header").build();
        }
        return Optional.of(new BlobDescriptor(contentLength, this.blobDigest));
    }

    @Override
    public Optional<BlobDescriptor> handleHttpResponseException(HttpResponseException httpResponseException) throws HttpResponseException {
        if (httpResponseException.getStatusCode() != 404) {
            throw httpResponseException;
        }
        if (httpResponseException.getContent() == null) {
            return Optional.empty();
        }
        ErrorCodes errorCode = ErrorResponseUtil.getErrorCode(httpResponseException);
        if (errorCode == ErrorCodes.BLOB_UNKNOWN) {
            return Optional.empty();
        }
        throw httpResponseException;
    }

    @Override
    public URL getApiRoute(String apiRouteBase) throws MalformedURLException {
        return new URL(apiRouteBase + this.registryEndpointRequestProperties.getImageName() + "/blobs/" + this.blobDigest);
    }

    @Override
    @Nullable
    public BlobHttpContent getContent() {
        return null;
    }

    @Override
    public List<String> getAccept() {
        return Collections.emptyList();
    }

    @Override
    public String getHttpMethod() {
        return "HEAD";
    }

    @Override
    public String getActionDescription() {
        return "check BLOB exists for " + this.registryEndpointRequestProperties.getServerUrl() + "/" + this.registryEndpointRequestProperties.getImageName() + " with digest " + this.blobDigest;
    }
}

