/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryMember;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMember;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.InnerClassesAttribute;
import proguard.classfile.attribute.InnerClassesInfo;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.ElementValue;
import proguard.classfile.attribute.annotation.visitor.AllElementValueVisitor;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.InnerClassesInfoVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.AllInstructionVisitor;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.AccessUtil;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.InitializerMethodFilter;
import proguard.classfile.visitor.MemberAccessFilter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.ReferencedClassVisitor;
import proguard.classfile.visitor.ReferencedMemberVisitor;
import proguard.classfile.visitor.SimilarMemberVisitor;

public class AccessFixer
implements ClassVisitor {
    private final ClassVisitor referencedClassFixer = new ReferencedClassVisitor(new MyReferencedClassAccessFixer());
    private final ClassVisitor referencedMemberFixer = new AllMethodVisitor(new AllAttributeVisitor(new AllInstructionVisitor(new MyReferencedMemberVisitor(new MyReferencedMemberAccessFixer()))));
    private final ClassVisitor referencedAnnotationMethodFixer = new AllAttributeVisitor(true, new AllElementValueVisitor(new MyReferencedMemberVisitor(new MyReferencedMemberAccessFixer())));
    private final ClassVisitor methodHierarchyFixer = new AllMethodVisitor(new MemberAccessFilter(0, 10, new InitializerMethodFilter(null, new SimilarMemberVisitor(false, true, false, true, new MemberAccessFilter(0, 10, new MyReferencedMemberAccessFixer())))));
    private Clazz referencingClass;
    private int referencingMethodAccessFlags;
    private Clazz referencedClass;

    @Override
    public void visitAnyClass(Clazz clazz) {
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        this.referencingClass = programClass;
        this.referencedClassFixer.visitProgramClass(programClass);
        this.referencedMemberFixer.visitProgramClass(programClass);
        this.referencedAnnotationMethodFixer.visitProgramClass(programClass);
        this.referencingMethodAccessFlags = 0;
        this.referencedClass = null;
        this.methodHierarchyFixer.visitProgramClass(programClass);
    }

    private boolean inSamePackage(Clazz class1, Clazz class2) {
        return ClassUtil.internalPackageName(class1.getName()).equals(ClassUtil.internalPackageName(class2.getName()));
    }

    private class MyReferencedClassAccessFixer
    implements ClassVisitor,
    AttributeVisitor,
    InnerClassesInfoVisitor {
        private MyReferencedClassAccessFixer() {
        }

        @Override
        public void visitAnyClass(Clazz clazz) {
        }

        @Override
        public void visitProgramClass(ProgramClass programClass) {
            int currentAccessFlags = programClass.getAccessFlags();
            int currentAccessLevel = AccessUtil.accessLevel(currentAccessFlags);
            if (currentAccessLevel < 3) {
                int requiredAccessLevel;
                int n = requiredAccessLevel = AccessFixer.this.inSamePackage(programClass, AccessFixer.this.referencingClass) ? 1 : 3;
                if (currentAccessLevel < requiredAccessLevel) {
                    programClass.u2accessFlags = AccessUtil.replaceAccessFlags(currentAccessFlags, AccessUtil.accessFlags(requiredAccessLevel));
                }
            }
            programClass.attributesAccept(this);
        }

        @Override
        public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
        }

        @Override
        public void visitInnerClassesAttribute(Clazz clazz, InnerClassesAttribute innerClassesAttribute) {
            innerClassesAttribute.innerClassEntriesAccept(clazz, this);
        }

        @Override
        public void visitInnerClassesInfo(Clazz clazz, InnerClassesInfo innerClassesInfo) {
            int currentAccessFlags;
            int currentAccessLevel;
            String innerClassName;
            int innerClassIndex = innerClassesInfo.u2innerClassIndex;
            if (innerClassIndex != 0 && (innerClassName = clazz.getClassName(innerClassIndex)).equals(clazz.getName()) && (currentAccessLevel = AccessUtil.accessLevel(currentAccessFlags = innerClassesInfo.u2innerClassAccessFlags)) < 3) {
                int requiredAccessLevel;
                int n = requiredAccessLevel = AccessFixer.this.inSamePackage(clazz, AccessFixer.this.referencingClass) ? 1 : 3;
                if (currentAccessLevel < requiredAccessLevel) {
                    innerClassesInfo.u2innerClassAccessFlags = AccessUtil.replaceAccessFlags(currentAccessFlags, AccessUtil.accessFlags(requiredAccessLevel));
                }
            }
        }
    }

    private class MyReferencedMemberVisitor
    extends ReferencedMemberVisitor
    implements InstructionVisitor {
        public MyReferencedMemberVisitor(MemberVisitor memberVisitor) {
            super(memberVisitor);
        }

        @Override
        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
        }

        @Override
        public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
            AccessFixer.this.referencingMethodAccessFlags = method.getAccessFlags();
            clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
        }

        @Override
        public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
            if (ClassUtil.isInternalArrayType(refConstant.getClassName(clazz))) {
                AccessFixer.this.referencedClass = refConstant.referencedClass;
            } else {
                clazz.constantPoolEntryAccept(refConstant.u2classIndex, this);
            }
            super.visitAnyRefConstant(clazz, refConstant);
        }

        @Override
        public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
            AccessFixer.this.referencedClass = classConstant.referencedClass;
        }

        @Override
        public void visitAnyElementValue(Clazz clazz, Annotation annotation, ElementValue elementValue) {
            AccessFixer.this.referencingMethodAccessFlags = 8;
            AccessFixer.this.referencedClass = elementValue.referencedClass;
            super.visitAnyElementValue(clazz, annotation, elementValue);
        }
    }

    private class MyReferencedMemberAccessFixer
    implements MemberVisitor {
        private MyReferencedMemberAccessFixer() {
        }

        @Override
        public void visitLibraryMember(LibraryClass libraryClass, LibraryMember libraryMember) {
        }

        @Override
        public void visitProgramMember(ProgramClass programClass, ProgramMember programMember) {
            int currentAccessFlags = programMember.getAccessFlags();
            int currentAccessLevel = AccessUtil.accessLevel(currentAccessFlags);
            if (currentAccessLevel < 3) {
                int requiredAccessLevel;
                int n = programClass.equals(AccessFixer.this.referencingClass) ? 0 : (AccessFixer.this.inSamePackage(programClass, AccessFixer.this.referencingClass) ? 1 : (requiredAccessLevel = (AccessFixer.this.referencingMethodAccessFlags & 8) == 0 && (AccessFixer.this.referencedClass == null || AccessFixer.this.referencedClass.extends_(AccessFixer.this.referencingClass)) && AccessFixer.this.referencingClass.extends_(programClass) ? 2 : 3));
                if (currentAccessLevel < requiredAccessLevel) {
                    programMember.u2accessFlags = AccessUtil.replaceAccessFlags(currentAccessFlags, AccessUtil.accessFlags(requiredAccessLevel));
                }
            }
        }
    }
}

