/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMember;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.EnclosingMethodAttribute;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttribute;
import proguard.classfile.attribute.annotation.AnnotationElementValue;
import proguard.classfile.attribute.annotation.AnnotationsAttribute;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ClassElementValue;
import proguard.classfile.attribute.annotation.ConstantElementValue;
import proguard.classfile.attribute.annotation.ElementValue;
import proguard.classfile.attribute.annotation.EnumConstantElementValue;
import proguard.classfile.attribute.annotation.ParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.ElementValueVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.InterfaceMethodrefConstant;
import proguard.classfile.constant.MethodrefConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.editor.StackSizeUpdater;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;

public class MemberReferenceFixer
implements ClassVisitor,
ConstantVisitor,
MemberVisitor,
AttributeVisitor,
AnnotationVisitor,
ElementValueVisitor {
    private static final boolean DEBUG = false;
    private final boolean android;
    private final StackSizeUpdater stackSizeUpdater = new StackSizeUpdater();
    private int constantIndex;
    private boolean isInterfaceMethod;
    private boolean stackSizesMayHaveChanged;

    public MemberReferenceFixer(boolean android) {
        this.android = android;
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        this.stackSizesMayHaveChanged = false;
        for (int index = 1; index < programClass.u2constantPoolCount; ++index) {
            Constant constant = programClass.constantPool[index];
            if (constant == null) continue;
            this.constantIndex = index;
            constant.accept(programClass, this);
        }
        programClass.fieldsAccept(this);
        programClass.methodsAccept(this);
        programClass.attributesAccept(this);
    }

    @Override
    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    @Override
    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        Member referencedMember = stringConstant.referencedMember;
        if (referencedMember != null) {
            Clazz referencedClass = stringConstant.referencedClass;
            String newName = referencedMember.getName(referencedClass);
            if (!stringConstant.getString(clazz).equals(newName)) {
                stringConstant.u2stringIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(newName);
            }
        }
    }

    @Override
    public void visitFieldrefConstant(Clazz clazz, FieldrefConstant fieldrefConstant) {
        Field referencedField = fieldrefConstant.referencedField;
        if (referencedField != null) {
            Clazz referencedClass = fieldrefConstant.referencedClass;
            String newName = referencedField.getName(referencedClass);
            String newType = referencedField.getDescriptor(referencedClass);
            if (!fieldrefConstant.getName(clazz).equals(newName) || !fieldrefConstant.getType(clazz).equals(newType)) {
                fieldrefConstant.u2nameAndTypeIndex = new ConstantPoolEditor((ProgramClass)clazz).addNameAndTypeConstant(newName, newType);
            }
        }
    }

    @Override
    public void visitInterfaceMethodrefConstant(Clazz clazz, InterfaceMethodrefConstant interfaceMethodrefConstant) {
        Method referencedMethod = interfaceMethodrefConstant.referencedMethod;
        if (referencedMethod != null) {
            Clazz referencedClass = interfaceMethodrefConstant.referencedClass;
            String newName = referencedMethod.getName(referencedClass);
            String newType = referencedMethod.getDescriptor(referencedClass);
            if (!interfaceMethodrefConstant.getName(clazz).equals(newName) || !interfaceMethodrefConstant.getType(clazz).equals(newType)) {
                interfaceMethodrefConstant.u2nameAndTypeIndex = new ConstantPoolEditor((ProgramClass)clazz).addNameAndTypeConstant(newName, newType);
                this.stackSizesMayHaveChanged = true;
            }
            this.isInterfaceMethod = true;
            clazz.constantPoolEntryAccept(interfaceMethodrefConstant.u2classIndex, this);
            if (!this.isInterfaceMethod) {
                ((ProgramClass)clazz).constantPool[this.constantIndex] = new MethodrefConstant(interfaceMethodrefConstant.u2classIndex, interfaceMethodrefConstant.u2nameAndTypeIndex, referencedClass, referencedMethod);
            }
        }
    }

    @Override
    public void visitMethodrefConstant(Clazz clazz, MethodrefConstant methodrefConstant) {
        Method referencedMethod = methodrefConstant.referencedMethod;
        if (referencedMethod != null) {
            Clazz referencedClass = methodrefConstant.referencedClass;
            String newName = referencedMethod.getName(referencedClass);
            String newType = referencedMethod.getDescriptor(referencedClass);
            if (!methodrefConstant.getName(clazz).equals(newName) || !methodrefConstant.getType(clazz).equals(newType)) {
                methodrefConstant.u2nameAndTypeIndex = new ConstantPoolEditor((ProgramClass)clazz).addNameAndTypeConstant(newName, newType);
                this.stackSizesMayHaveChanged = true;
            }
            this.isInterfaceMethod = false;
            clazz.constantPoolEntryAccept(methodrefConstant.u2classIndex, this);
            if (this.isInterfaceMethod) {
                ((ProgramClass)clazz).constantPool[this.constantIndex] = new InterfaceMethodrefConstant(methodrefConstant.u2classIndex, methodrefConstant.u2nameAndTypeIndex, referencedClass, referencedMethod);
            }
        }
    }

    @Override
    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        if (ClassUtil.isInternalArrayType(classConstant.getName(clazz))) {
            this.isInterfaceMethod = false;
        } else {
            Clazz referencedClass = classConstant.referencedClass;
            if (referencedClass != null) {
                this.isInterfaceMethod = (referencedClass.getAccessFlags() & 0x200) != 0;
            }
        }
    }

    @Override
    public void visitProgramMember(ProgramClass programClass, ProgramMember programMember) {
        programMember.attributesAccept(programClass, this);
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitEnclosingMethodAttribute(Clazz clazz, EnclosingMethodAttribute enclosingMethodAttribute) {
        Method referencedMember = enclosingMethodAttribute.referencedMethod;
        if (referencedMember != null) {
            Clazz referencedClass = enclosingMethodAttribute.referencedClass;
            String newName = referencedMember.getName(referencedClass);
            String newType = referencedMember.getDescriptor(referencedClass);
            if (!enclosingMethodAttribute.getName(clazz).equals(newName) || !enclosingMethodAttribute.getType(clazz).equals(newType)) {
                enclosingMethodAttribute.u2nameAndTypeIndex = new ConstantPoolEditor((ProgramClass)clazz).addNameAndTypeConstant(newName, newType);
            }
        }
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        if (this.stackSizesMayHaveChanged) {
            this.stackSizeUpdater.visitCodeAttribute(clazz, method, codeAttribute);
        }
        codeAttribute.attributesAccept(clazz, method, this);
    }

    @Override
    public void visitAnyAnnotationsAttribute(Clazz clazz, AnnotationsAttribute annotationsAttribute) {
        annotationsAttribute.annotationsAccept(clazz, this);
    }

    @Override
    public void visitAnyParameterAnnotationsAttribute(Clazz clazz, Method method, ParameterAnnotationsAttribute parameterAnnotationsAttribute) {
        parameterAnnotationsAttribute.annotationsAccept(clazz, method, this);
    }

    @Override
    public void visitAnnotationDefaultAttribute(Clazz clazz, Method method, AnnotationDefaultAttribute annotationDefaultAttribute) {
        annotationDefaultAttribute.defaultValueAccept(clazz, this);
    }

    @Override
    public void visitAnnotation(Clazz clazz, Annotation annotation) {
        annotation.elementValuesAccept(clazz, this);
    }

    @Override
    public void visitConstantElementValue(Clazz clazz, Annotation annotation, ConstantElementValue constantElementValue) {
        this.fixElementValue(clazz, annotation, constantElementValue);
    }

    @Override
    public void visitEnumConstantElementValue(Clazz clazz, Annotation annotation, EnumConstantElementValue enumConstantElementValue) {
        Field referencedField;
        this.fixElementValue(clazz, annotation, enumConstantElementValue);
        if (this.android && (referencedField = enumConstantElementValue.referencedField) != null) {
            Clazz referencedClass = enumConstantElementValue.referencedClasses[0];
            String newName = referencedField.getName(referencedClass);
            if (!enumConstantElementValue.getConstantName(clazz).equals(newName)) {
                enumConstantElementValue.u2constantNameIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(newName);
            }
        }
    }

    @Override
    public void visitClassElementValue(Clazz clazz, Annotation annotation, ClassElementValue classElementValue) {
        this.fixElementValue(clazz, annotation, classElementValue);
    }

    @Override
    public void visitAnnotationElementValue(Clazz clazz, Annotation annotation, AnnotationElementValue annotationElementValue) {
        this.fixElementValue(clazz, annotation, annotationElementValue);
        annotationElementValue.annotationAccept(clazz, this);
    }

    @Override
    public void visitArrayElementValue(Clazz clazz, Annotation annotation, ArrayElementValue arrayElementValue) {
        this.fixElementValue(clazz, annotation, arrayElementValue);
        arrayElementValue.elementValuesAccept(clazz, annotation, this);
    }

    private void fixElementValue(Clazz clazz, Annotation annotation, ElementValue elementValue) {
        String newMethodName;
        String methodName;
        Method referencedMember = elementValue.referencedMethod;
        if (referencedMember != null && !(methodName = elementValue.getMethodName(clazz)).equals(newMethodName = referencedMember.getName(elementValue.referencedClass))) {
            elementValue.u2elementNameIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(newMethodName);
        }
    }

    private void debug(Clazz clazz, StringConstant stringConstant, Clazz referencedClass, Member referencedMember) {
        System.out.println("MemberReferenceFixer:");
        System.out.println("  [" + clazz.getName() + "]: String [" + stringConstant.getString(clazz) + "] -> [" + referencedClass.getName() + "." + referencedMember.getName(referencedClass) + " " + referencedMember.getDescriptor(referencedClass) + "]");
    }

    private void debug(Clazz clazz, RefConstant refConstant, Clazz referencedClass, Member referencedMember) {
        System.out.println("MemberReferenceFixer:");
        System.out.println("  [" + clazz.getName() + "]: [" + refConstant.getClassName(clazz) + "." + refConstant.getName(clazz) + " " + refConstant.getType(clazz) + "] -> [" + referencedClass.getName() + "." + referencedMember.getName(referencedClass) + " " + referencedMember.getDescriptor(referencedClass) + "]");
    }
}

