/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.DigestOutputStream;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import proguard.io.DEROutputStream;
import proguard.io.DataEntry;
import proguard.io.DataEntryWriter;
import proguard.io.DummyDataEntry;
import proguard.io.FixedFileWriter;
import proguard.io.JarWriter;
import proguard.io.PKCS7OutputStream;
import proguard.io.RenamedDataEntry;
import proguard.io.ZipWriter;
import proguard.util.Base64Util;
import proguard.util.FixedStringMatcher;

public class SignedJarWriter
extends JarWriter {
    private final KeyStore.PrivateKeyEntry privateKeyEntry;
    private final int[] apkSignatureSchemeIDs;
    private MessageDigest globalManifestDigest;
    private MessageDigest manifestEntryDigest;
    private Signature digitalSignature;
    private OutputStream signatureFileStream;
    private PrintWriter signatureWriter1;
    private PrintWriter signatureWriter2;
    private ByteArrayOutputStream signatureResultStream1;
    private ByteArrayOutputStream signatureResultStream2;
    private OutputStream digitalSignatureFileStream;

    public SignedJarWriter(KeyStore.PrivateKeyEntry privateKeyEntry, DataEntryWriter zipEntryWriter) {
        this(privateKeyEntry, new String[]{"SHA-256"}, null, null, zipEntryWriter);
    }

    public SignedJarWriter(KeyStore.PrivateKeyEntry privateKeyEntry, String[] digestAlgorithms, String creator, int[] apkSignatureSchemeIDs, DataEntryWriter zipEntryWriter) {
        super(digestAlgorithms, creator, zipEntryWriter);
        this.privateKeyEntry = privateKeyEntry;
        this.apkSignatureSchemeIDs = apkSignatureSchemeIDs;
        try {
            PrivateKey privateKey = privateKeyEntry.getPrivateKey();
            String encryptionAlgorithm = privateKey.getAlgorithm();
            String digestAlgorithm = digestAlgorithms[0];
            String signatureAlgorithm = digestAlgorithm.replace("-", "") + "with" + (encryptionAlgorithm.equals("EC") ? "ECDSA" : encryptionAlgorithm);
            this.globalManifestDigest = MessageDigest.getInstance(digestAlgorithm);
            this.manifestEntryDigest = MessageDigest.getInstance(digestAlgorithm);
            this.digitalSignature = Signature.getInstance(signatureAlgorithm);
            this.digitalSignature.initSign(privateKey);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e.getMessage(), e);
        }
    }

    @Override
    public OutputStream createOutputStream(DataEntry dataEntry) throws IOException {
        OutputStream outputStream = super.createOutputStream(dataEntry);
        return outputStream == null || this.signatureWriter2 == null ? null : new JarWriter.MyMultiDigestOutputStream(dataEntry.getName(), new MessageDigest[]{this.manifestEntryDigest}, this.signatureWriter2, outputStream);
    }

    @Override
    public void println(PrintWriter pw, String prefix) {
        pw.println(prefix + "SignedJarWriter");
        this.zipEntryWriter.println(pw, prefix + "  ");
    }

    @Override
    protected void openManifestFiles() throws IOException {
        super.openManifestFiles();
        this.signatureFileStream = this.manifestEntryWriter.createOutputStream(new RenamedDataEntry(this.currentManifestEntry, "META-INF/CERT.SF"));
        if (this.signatureFileStream != null) {
            String encryptionAlgorithm = this.privateKeyEntry.getPrivateKey().getAlgorithm();
            this.digitalSignatureFileStream = this.manifestEntryWriter.createOutputStream(new RenamedDataEntry(this.currentManifestEntry, "META-INF/CERT." + encryptionAlgorithm));
            this.signatureResultStream1 = new ByteArrayOutputStream();
            this.signatureWriter1 = this.printWriter(this.signatureResultStream1);
            this.signatureWriter1.println("Signature-Version: 1.0");
            if (this.apkSignatureSchemeIDs != null) {
                this.signatureWriter1.print("X-Android-APK-Signed: ");
                for (int index = 0; index < this.apkSignatureSchemeIDs.length; ++index) {
                    this.signatureWriter1.print(this.apkSignatureSchemeIDs[index]);
                    if (index >= this.apkSignatureSchemeIDs.length - 1) continue;
                    this.signatureWriter1.print(',');
                }
                this.signatureWriter1.println();
            }
            if (this.creator != null) {
                this.signatureWriter1.println("Created-By: " + this.creator);
            }
            this.signatureWriter1.println(this.manifestEntryDigest.getAlgorithm() + "-Digest-Manifest-Main-Attributes: " + Base64Util.encode(this.manifestEntryDigest.digest()));
            this.signatureResultStream2 = new ByteArrayOutputStream();
            this.signatureWriter2 = this.printWriter(this.signatureResultStream2);
        }
    }

    @Override
    protected OutputStream createManifestOutputStream(DataEntry manifestEntry) throws IOException {
        OutputStream manifestOutputStream = super.createManifestOutputStream(manifestEntry);
        if (manifestOutputStream == null) {
            return null;
        }
        return new DigestOutputStream(new DigestOutputStream(manifestOutputStream, this.globalManifestDigest), this.manifestEntryDigest);
    }

    @Override
    protected void finish() throws IOException {
        super.finish();
        if (this.digitalSignatureFileStream != null) {
            String digestAlgorithm = this.globalManifestDigest.getAlgorithm();
            this.signatureWriter1.println(digestAlgorithm + "-Digest-Manifest: " + Base64Util.encode(this.globalManifestDigest.digest()));
            this.signatureWriter1.println();
            this.signatureWriter1.flush();
            if ((this.signatureResultStream1.size() + this.signatureResultStream2.size()) % 1024 == 0) {
                this.signatureWriter2.println();
                this.signatureWriter2.flush();
            }
            byte[] signatureBytes1 = this.signatureResultStream1.toByteArray();
            byte[] signatureBytes2 = this.signatureResultStream2.toByteArray();
            this.signatureFileStream.write(signatureBytes1);
            this.signatureFileStream.write(signatureBytes2);
            this.signatureFileStream.close();
            try {
                this.digitalSignature.update(signatureBytes1);
                this.digitalSignature.update(signatureBytes2);
                byte[] digitalSignatureBytes = this.digitalSignature.sign();
                X509Certificate certificate = (X509Certificate)this.privateKeyEntry.getCertificate();
                String encryptionAlgorithm = this.privateKeyEntry.getPrivateKey().getAlgorithm();
                PKCS7OutputStream pkcs7OutputStream = new PKCS7OutputStream(new DEROutputStream(this.digitalSignatureFileStream));
                pkcs7OutputStream.writeSignature(certificate, digestAlgorithm, encryptionAlgorithm, digitalSignatureBytes);
                pkcs7OutputStream.close();
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new UnsupportedOperationException(e.getMessage(), e);
            }
            this.signatureFileStream = null;
            this.signatureWriter1 = null;
            this.signatureWriter2 = null;
            this.signatureResultStream1 = null;
            this.signatureResultStream2 = null;
            this.digitalSignatureFileStream = null;
        }
    }

    public static void main(String[] args) {
        try {
            String keyStoreFileName = args[0];
            String keyStorePassword = args[1];
            String keyAlias = args[2];
            String keyPassword = args[3];
            String jarFileName = args[4];
            FileInputStream keyStoreInputStream = new FileInputStream(keyStoreFileName);
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(keyStoreInputStream, keyStorePassword.toCharArray());
            keyStoreInputStream.close();
            KeyStore.PasswordProtection protectionParameter = new KeyStore.PasswordProtection(keyPassword.toCharArray());
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(keyAlias, protectionParameter);
            SignedJarWriter writer = new SignedJarWriter(privateKeyEntry, new String[]{"SHA-256"}, "ProGuard", null, new ZipWriter(new FixedStringMatcher("file1.txt"), 4, 0, new FixedFileWriter(new File(jarFileName))));
            PrintWriter printWriter = new PrintWriter(writer.createOutputStream(new DummyDataEntry(null, "file1.txt", 0L, false)));
            printWriter.println("Hello, world!");
            printWriter.close();
            printWriter = new PrintWriter(writer.createOutputStream(new DummyDataEntry(null, "file2.txt", 0L, false)));
            printWriter.println("Hello again, world!");
            printWriter.close();
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

