/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dependency.nnparser;

import com.hankcs.hanlp.corpus.dependency.CoNll.CoNLLSentence;
import com.hankcs.hanlp.corpus.dependency.CoNll.CoNLLWord;
import com.hankcs.hanlp.dependency.AbstractDependencyParser;
import com.hankcs.hanlp.dependency.IDependencyParser;
import com.hankcs.hanlp.dependency.nnparser.option.ConfigOption;
import com.hankcs.hanlp.dependency.nnparser.parser_dll;
import com.hankcs.hanlp.dependency.nnparser.util.PosTagUtil;
import com.hankcs.hanlp.seg.common.Term;
import java.util.ArrayList;
import java.util.List;

public class NeuralNetworkDependencyParser
extends AbstractDependencyParser {
    public static final IDependencyParser INSTANCE = new NeuralNetworkDependencyParser().setDeprelTranslater(ConfigOption.DEPRL_DESCRIPTION_PATH).enableDeprelTranslator(true);

    @Override
    public CoNLLSentence parse(List<Term> termList) {
        int i;
        List<String> posTagList = PosTagUtil.to863(termList);
        ArrayList<String> wordList = new ArrayList<String>(termList.size());
        for (Term term : termList) {
            wordList.add(term.word);
        }
        ArrayList<Integer> heads = new ArrayList<Integer>(termList.size());
        ArrayList<String> deprels = new ArrayList<String>(termList.size());
        parser_dll.parse(wordList, posTagList, heads, deprels);
        CoNLLWord[] wordArray = new CoNLLWord[termList.size()];
        for (i = 0; i < wordArray.length; ++i) {
            wordArray[i] = new CoNLLWord(i + 1, (String)wordList.get(i), posTagList.get(i), termList.get((int)i).nature.toString());
            wordArray[i].DEPREL = (String)deprels.get(i);
        }
        for (i = 0; i < wordArray.length; ++i) {
            int index = (Integer)heads.get(i) - 1;
            wordArray[i].HEAD = index < 0 ? CoNLLWord.ROOT : wordArray[index];
        }
        return new CoNLLSentence(wordArray);
    }

    public static CoNLLSentence compute(List<Term> termList) {
        return INSTANCE.parse(termList);
    }

    public static CoNLLSentence compute(String sentence) {
        return INSTANCE.parse(sentence);
    }
}

