/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dictionary.nt;

import com.hankcs.hanlp.corpus.dictionary.item.EnumItem;
import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.corpus.tag.NT;
import com.hankcs.hanlp.dictionary.common.CommonDictionary;
import com.hankcs.hanlp.utility.ByteUtil;
import com.hankcs.hanlp.utility.Predefine;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.Map;

public class NTDictionary
extends CommonDictionary<EnumItem<NT>> {
    protected EnumItem<NT>[] onLoadValue(String path) {
        EnumItem<NT>[] valueArray = this.loadDat(path + ".value.dat");
        if (valueArray != null) {
            return valueArray;
        }
        LinkedList valueList = new LinkedList();
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), "UTF-8"));
            while ((line = br.readLine()) != null) {
                Map.Entry<String, Map.Entry<String, Integer>[]> args = EnumItem.create(line);
                EnumItem NSEnumItem = new EnumItem();
                for (Map.Entry<String, Integer> e : args.getValue()) {
                    NSEnumItem.labelMap.put(NT.valueOf(e.getKey()), e.getValue());
                }
                valueList.add(NSEnumItem);
            }
            br.close();
        }
        catch (Exception e) {
            Predefine.logger.warning("\u8bfb\u53d6" + path + "\u5931\u8d25" + e);
        }
        valueArray = valueList.toArray(new EnumItem[0]);
        return valueArray;
    }

    protected boolean onSaveValue(EnumItem<NT>[] valueArray, String path) {
        return this.saveDat(path + ".value.dat", valueArray);
    }

    private EnumItem<NT>[] loadDat(String path) {
        byte[] bytes = IOUtil.readBytes(path);
        if (bytes == null) {
            return null;
        }
        NT[] values = NT.values();
        int index = 0;
        int size = ByteUtil.bytesHighFirstToInt(bytes, index);
        index += 4;
        EnumItem[] valueArray = new EnumItem[size];
        for (int i = 0; i < size; ++i) {
            int currentSize = ByteUtil.bytesHighFirstToInt(bytes, index);
            index += 4;
            EnumItem item = new EnumItem();
            for (int j = 0; j < currentSize; ++j) {
                NT tag = values[ByteUtil.bytesHighFirstToInt(bytes, index)];
                int frequency = ByteUtil.bytesHighFirstToInt(bytes, index += 4);
                index += 4;
                item.labelMap.put(tag, frequency);
            }
            valueArray[i] = item;
        }
        return valueArray;
    }

    private boolean saveDat(String path, EnumItem<NT>[] valueArray) {
        try {
            DataOutputStream out = new DataOutputStream(new FileOutputStream(path));
            out.writeInt(valueArray.length);
            for (EnumItem<NT> item : valueArray) {
                out.writeInt(item.labelMap.size());
                for (Map.Entry entry : item.labelMap.entrySet()) {
                    out.writeInt(((NT)((Object)entry.getKey())).ordinal());
                    out.writeInt(entry.getValue());
                }
            }
            out.close();
        }
        catch (Exception e) {
            Predefine.logger.warning("\u4fdd\u5b58\u5931\u8d25" + e);
            return false;
        }
        return true;
    }
}

