/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.seg.Viterbi.Path;

import com.hankcs.hanlp.seg.Viterbi.Path.Node;
import com.hankcs.hanlp.seg.common.Vertex;
import java.util.LinkedList;
import java.util.List;

public class Graph {
    Node[][] nodes;

    public Graph(List<Vertex>[] vertexes) {
        this.nodes = new Node[vertexes.length][];
        int i = 0;
        for (List<Vertex> vertexList : vertexes) {
            if (vertexList == null) continue;
            this.nodes[i] = new Node[vertexList.size()];
            int j = 0;
            for (Vertex vertex : vertexList) {
                this.nodes[i][j] = new Node(vertex);
                ++j;
            }
            ++i;
        }
    }

    public List<Vertex> viterbi() {
        LinkedList<Vertex> vertexList = new LinkedList<Vertex>();
        for (Node node : this.nodes[1]) {
            node.updateFrom(this.nodes[0][0]);
        }
        for (int i = 1; i < this.nodes.length - 1; ++i) {
            Node[] nodeArray = this.nodes[i];
            if (nodeArray == null) continue;
            for (Node node : nodeArray) {
                if (node.from == null) continue;
                for (Node to : this.nodes[i + node.vertex.realWord.length()]) {
                    to.updateFrom(node);
                }
            }
        }
        Node from = this.nodes[this.nodes.length - 1][0];
        while (from != null) {
            vertexList.addFirst(from.vertex);
            from = from.from;
        }
        return vertexList;
    }
}

