/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.iterate.IIterableIterator;
import com.helger.commons.string.ToStringGenerator;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RecursiveChildNodeIterator
implements IIterableIterator<Node> {
    private final Iterator<Node> m_aIter;

    private static void _recursiveFillListPrefix(@Nonnull Node node, @Nonnull List<Node> list) {
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = nodeList.item(i);
                list.add(node2);
                RecursiveChildNodeIterator._recursiveFillListPrefix(node2, list);
            }
        }
    }

    public RecursiveChildNodeIterator(@Nonnull Node node) {
        ValueEnforcer.notNull((Object)node, (String)"Parent");
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        RecursiveChildNodeIterator._recursiveFillListPrefix(node, (List<Node>)commonsArrayList);
        this.m_aIter = commonsArrayList.iterator();
    }

    public boolean hasNext() {
        return this.m_aIter.hasNext();
    }

    public Node next() {
        return this.m_aIter.next();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("iter", this.m_aIter).getToString();
    }
}

