/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.service;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.internal.RepeatableRequestEntity;
import com.obs.services.internal.ServiceException;
import com.obs.services.internal.service.AbstractRequestConvertor;
import com.obs.services.internal.service.ObsMultipartObjectService;
import com.obs.services.internal.trans.NewTransResult;
import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.model.AccessControlList;
import com.obs.services.model.AppendObjectRequest;
import com.obs.services.model.AppendObjectResult;
import com.obs.services.model.ModifyObjectRequest;
import com.obs.services.model.ModifyObjectResult;
import com.obs.services.model.RenameObjectRequest;
import com.obs.services.model.RenameObjectResult;
import com.obs.services.model.RestoreObjectRequest;
import com.obs.services.model.RestoreObjectResult;
import com.obs.services.model.SpecialParamEnum;
import com.obs.services.model.StorageClassEnum;
import com.obs.services.model.TruncateObjectRequest;
import com.obs.services.model.TruncateObjectResult;
import java.io.Closeable;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Response;

public abstract class ObsObjectService
extends ObsMultipartObjectService {
    private static final ILogger log = LoggerBuilder.getLogger(ObsObjectService.class);

    protected TruncateObjectResult truncateObjectImpl(TruncateObjectRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.TRUNCATE.getOriginalStringCode(), "");
        requestParameters.put("length", String.valueOf(request.getNewLength()));
        Map<String, String> headers = this.transRequestPaymentHeaders(request, null, this.getIHeaders(request.getBucketName()));
        NewTransResult transResult = this.transObjectRequest(request);
        transResult.setHeaders(headers);
        transResult.setParams(requestParameters);
        Response response = this.performRequest(transResult);
        TruncateObjectResult result = new TruncateObjectResult();
        this.setHeadersAndStatus(result, response);
        return result;
    }

    protected RenameObjectResult renameObjectImpl(RenameObjectRequest request) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.RENAME.getOriginalStringCode(), "");
        requestParams.put("name", request.getNewObjectKey());
        Map<String, String> headers = this.transRequestPaymentHeaders(request, null, this.getIHeaders(request.getBucketName()));
        NewTransResult transResult = this.transObjectRequest(request);
        transResult.setParams(requestParams);
        transResult.setHeaders(headers);
        Response response = this.performRequest(transResult);
        RenameObjectResult result = new RenameObjectResult();
        this.setHeadersAndStatus(result, response);
        return result;
    }

    protected RestoreObjectRequest.RestoreObjectStatus restoreObjectImpl(RestoreObjectRequest restoreObjectRequest) throws ServiceException {
        RestoreObjectResult restoreObjectResult = this.restoreObjectV2Impl(restoreObjectRequest);
        return this.transRestoreObjectResultToRestoreObjectStatus(restoreObjectResult);
    }

    protected RestoreObjectResult restoreObjectV2Impl(RestoreObjectRequest request) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.RESTORE.getOriginalStringCode(), "");
        if (request.getVersionId() != null) {
            requestParams.put("versionId", request.getVersionId());
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        String xml = this.getIConvertor(request.getBucketName()).transRestoreObjectRequest(request);
        headers.put("Content-MD5", ServiceUtils.computeMD5(xml));
        headers.put("Content-Type", "application/xml");
        this.transRequestPaymentHeaders(request, headers, this.getIHeaders(request.getBucketName()));
        NewTransResult transResult = this.transObjectRequest(request);
        transResult.setParams(requestParams);
        transResult.setHeaders(headers);
        transResult.setBody(this.createRequestBody("application/xml", xml));
        Response response = this.performRequest(transResult);
        RestoreObjectResult ret = new RestoreObjectResult(request.getBucketName(), request.getObjectKey(), request.getVersionId());
        this.setHeadersAndStatus(ret, response);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AppendObjectResult appendObjectImpl(AppendObjectRequest request) throws ServiceException {
        AppendObjectResult ret;
        block8: {
            Response response;
            boolean isExtraAclPutRequired;
            AbstractRequestConvertor.TransResult result = null;
            AccessControlList acl = request.getAcl();
            try {
                result = this.transAppendObjectRequest(request);
                isExtraAclPutRequired = !this.prepareRESTHeaderAcl(request.getBucketName(), result.getHeaders(), acl);
                NewTransResult newTransResult = this.transObjectRequestWithResult(result, request);
                response = this.performRequest(newTransResult);
            }
            finally {
                if (result != null && result.getBody() != null && request.isAutoClose()) {
                    RepeatableRequestEntity entity = (RepeatableRequestEntity)result.getBody();
                    ServiceUtils.closeStream(entity);
                }
            }
            String nextPosition = response.header(this.getIHeaders(request.getBucketName()).nextPositionHeader());
            ret = new AppendObjectResult(request.getBucketName(), request.getObjectKey(), response.header("ETag"), nextPosition != null ? Long.parseLong(nextPosition) : -1L, StorageClassEnum.getValueFromCode(response.header(this.getIHeaders(request.getBucketName()).storageClassHeader())), this.getObjectUrl(request.getBucketName(), request.getObjectKey()));
            this.setHeadersAndStatus(ret, response);
            if (isExtraAclPutRequired && acl != null) {
                try {
                    this.putAclImpl(request.getBucketName(), request.getObjectKey(), acl, null, request.isRequesterPays());
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block8;
                    log.warn("Try to set object acl error", e);
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModifyObjectResult modifyObjectImpl(ModifyObjectRequest request) throws ServiceException {
        ModifyObjectResult ret;
        block8: {
            Response response;
            boolean isExtraAclPutRequired;
            AbstractRequestConvertor.TransResult result = null;
            AccessControlList acl = request.getAcl();
            try {
                result = this.transModifyObjectRequest(request);
                isExtraAclPutRequired = !this.prepareRESTHeaderAcl(request.getBucketName(), result.getHeaders(), acl);
                NewTransResult newTransResult = this.transObjectRequestWithResult(result, request);
                response = this.performRequest(newTransResult);
            }
            finally {
                if (result != null && result.getBody() != null && request.isAutoClose() && result.getBody() instanceof Closeable) {
                    ServiceUtils.closeStream((Closeable)result.getBody());
                }
            }
            ret = new ModifyObjectResult();
            this.setHeadersAndStatus(ret, response, request.isEncodeHeaders());
            if (isExtraAclPutRequired && acl != null) {
                try {
                    this.putAclImpl(request.getBucketName(), request.getObjectKey(), acl, null, request.isRequesterPays());
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block8;
                    log.warn("Try to set object acl error", e);
                }
            }
        }
        return ret;
    }
}

