/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.utils;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.ObsConfiguration;
import com.obs.services.exception.ObsException;
import com.obs.services.internal.Constants;
import com.obs.services.internal.ObsProperties;
import com.obs.services.internal.ServiceException;
import com.obs.services.internal.ext.ExtObsConfiguration;
import com.obs.services.internal.utils.ReflectUtils;
import com.obs.services.model.AuthTypeEnum;
import com.obs.services.model.HttpProtocolTypeEnum;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ServiceUtils {
    private static final ILogger log = LoggerBuilder.getLogger(ServiceUtils.class);
    protected static final String ISO_8601_TIME_PARSER_STRING = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    protected static final String ISO_8601_TIME_MIDNING_PARSER_STRING = "yyyy-MM-dd'T'00:00:00'Z'";
    protected static final String ISO_8601_TIME_PARSER_WALRUS_STRING = "yyyy-MM-dd'T'HH:mm:ss";
    protected static final String RFC_822_TIME_PARSER_STRING = "EEE, dd MMM yyyy HH:mm:ss z";
    protected static final String ISO_8601_DATE_PARSER_STRING = "yyyy-MM-dd";
    private static Pattern pattern = Pattern.compile("^((2[0-4]\\d|25[0-5]|[01]?\\d\\d?)\\.){3}(2[0-4]\\d|25[0-5]|[01]?\\d\\d?)$");

    public static boolean isValid(String s) {
        return s != null && !s.equals("");
    }

    public static boolean isValid2(String s) {
        return s != null && !s.equals("");
    }

    public static String toValid(String s) {
        return s == null ? "" : s;
    }

    public static void asserParameterNotNull(String value, String errorMessage) {
        if (!ServiceUtils.isValid(value)) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static void asserParameterNotNull2(String value, String errorMessage) {
        if (value == null) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static void asserParameterNotNull(Object value, String errorMessage) {
        if (value == null) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static void assertParameterNotNegative(long value, String errorMessage) {
        if (value < 0L) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static Date parseIso8601Date(String dateString) throws ParseException {
        SimpleDateFormat iso8601TimeParser = new SimpleDateFormat(ISO_8601_TIME_PARSER_STRING);
        TimeZone gmt = Constants.GMT_TIMEZONE;
        iso8601TimeParser.setTimeZone(gmt);
        try {
            return iso8601TimeParser.parse(dateString);
        }
        catch (ParseException e) {
            ParseException exception = e;
            SimpleDateFormat iso8601TimeParserWalrus = new SimpleDateFormat(ISO_8601_TIME_PARSER_WALRUS_STRING);
            iso8601TimeParserWalrus.setTimeZone(gmt);
            try {
                return iso8601TimeParserWalrus.parse(dateString);
            }
            catch (ParseException e2) {
                exception = e2;
                SimpleDateFormat iso8601DateParser = new SimpleDateFormat(ISO_8601_DATE_PARSER_STRING);
                iso8601DateParser.setTimeZone(gmt);
                try {
                    return iso8601DateParser.parse(dateString);
                }
                catch (Exception e3) {
                    log.warn("date parser failed.", e3);
                    throw exception;
                }
            }
        }
    }

    public static String formatIso8601Date(Date date) {
        SimpleDateFormat iso8601TimeParser = new SimpleDateFormat(ISO_8601_TIME_PARSER_STRING);
        iso8601TimeParser.setTimeZone(Constants.GMT_TIMEZONE);
        return iso8601TimeParser.format(date);
    }

    public static String formatIso8601MidnightDate(Date date) {
        SimpleDateFormat iso8601TimeParser = new SimpleDateFormat(ISO_8601_TIME_MIDNING_PARSER_STRING);
        iso8601TimeParser.setTimeZone(Constants.GMT_TIMEZONE);
        return iso8601TimeParser.format(date);
    }

    public static Date parseRfc822Date(String dateString) throws ParseException {
        SimpleDateFormat rfc822TimeParser = new SimpleDateFormat(RFC_822_TIME_PARSER_STRING, Locale.US);
        rfc822TimeParser.setTimeZone(Constants.GMT_TIMEZONE);
        return rfc822TimeParser.parse(dateString);
    }

    public static String formatRfc822Date(Date date) {
        SimpleDateFormat rfc822TimeParser = new SimpleDateFormat(RFC_822_TIME_PARSER_STRING, Locale.US);
        rfc822TimeParser.setTimeZone(Constants.GMT_TIMEZONE);
        return rfc822TimeParser.format(date);
    }

    public static String signWithHmacSha1(String sk, String canonicalString) throws ServiceException {
        Mac mac;
        SecretKeySpec signingKey = new SecretKeySpec(sk.getBytes(StandardCharsets.UTF_8), "HmacSHA1");
        try {
            mac = Mac.getInstance("HmacSHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new ServiceException("Could not find sha1 algorithm", e);
        }
        try {
            mac.init(signingKey);
        }
        catch (InvalidKeyException e) {
            throw new ObsException("Could not initialize the MAC algorithm", e);
        }
        return ServiceUtils.toBase64(mac.doFinal(canonicalString.getBytes(StandardCharsets.UTF_8)));
    }

    private static String transRealKey(String headerPrefix, String metadataPrefix, String key, boolean needDecode) throws UnsupportedEncodingException {
        if (key.toLowerCase().startsWith(metadataPrefix)) {
            key = key.substring(metadataPrefix.length());
            if (needDecode) {
                key = URLDecoder.decode(key, "UTF-8");
            }
            if (log.isDebugEnabled()) {
                log.debug("Removed metadata header prefix " + metadataPrefix + " from key: " + key + "=>" + key);
            }
        } else {
            key = key.substring(headerPrefix.length());
        }
        return key;
    }

    public static Map<String, String> cleanRestMetadataMapV2(Map<String, String> metadata, String headerPrefix, String metadataPrefix, boolean needDecode) {
        if (log.isDebugEnabled()) {
            log.debug("Cleaning up REST metadata items");
        }
        IdentityHashMap<String, String> cleanMap = new IdentityHashMap<String, String>();
        if (metadata != null) {
            for (Map.Entry<String, String> entry : metadata.entrySet()) {
                String value;
                String key;
                block16: {
                    key = entry.getKey();
                    value = entry.getValue();
                    String string = key = key != null ? key : "";
                    if (key.toLowerCase().startsWith(headerPrefix)) {
                        try {
                            key = ServiceUtils.transRealKey(headerPrefix, metadataPrefix, key, needDecode);
                            if (needDecode) {
                                value = URLDecoder.decode(value, "UTF-8");
                            }
                        }
                        catch (UnsupportedEncodingException | IllegalArgumentException e) {
                            if (!log.isDebugEnabled()) break block16;
                            log.debug("Error to decode value of key:" + key);
                        }
                    } else if (key.toLowerCase().startsWith("x-obs-")) {
                        try {
                            key = ServiceUtils.transRealKey("x-obs-", "x-obs-meta-", key, needDecode);
                            if (needDecode) {
                                value = URLDecoder.decode(value, "UTF-8");
                            }
                        }
                        catch (UnsupportedEncodingException | IllegalArgumentException e) {
                            if (!log.isDebugEnabled()) break block16;
                            log.debug("Error to decode value of key:" + key);
                        }
                    } else if (Constants.ALLOWED_RESPONSE_HTTP_HEADER_METADATA_NAMES.contains(key.toLowerCase(Locale.getDefault()))) {
                        if (log.isDebugEnabled()) {
                            log.debug("Leaving HTTP header item unchanged: " + key + "=" + value);
                        }
                    } else {
                        if (!log.isDebugEnabled()) continue;
                        log.debug("Ignoring metadata item: " + key + "=" + value);
                        continue;
                    }
                }
                cleanMap.put(key, value);
            }
        }
        return cleanMap;
    }

    public static Map<String, Object> cleanUserMetadata(Map<String, Object> originalHeaders, boolean decodeHeaders) {
        TreeMap<String, Object> userMetadata = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        for (Map.Entry<String, Object> entry : originalHeaders.entrySet()) {
            String key = entry.getKey();
            if (!key.toLowerCase().startsWith("x-obs-meta-") && !key.toLowerCase().startsWith("x-amz-meta-")) continue;
            Object originalValue = originalHeaders.get(key);
            try {
                if (originalValue instanceof ArrayList) {
                    ServiceUtils.cleanListMetadata(originalHeaders, decodeHeaders, userMetadata, key);
                    continue;
                }
                if (decodeHeaders) {
                    userMetadata.put(key.substring(11), URLDecoder.decode((String)originalValue, "UTF-8"));
                    continue;
                }
                userMetadata.put(key.substring(11), originalHeaders.get(key));
            }
            catch (UnsupportedEncodingException | IllegalArgumentException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Error to decode value of key:" + key);
            }
        }
        return userMetadata;
    }

    public static void cleanListMetadata(Map<String, Object> originalHeaders, boolean decodeHeaders, Map<String, Object> userMetadata, String key) throws UnsupportedEncodingException {
        ArrayList<String> cleanedValue = new ArrayList<String>();
        for (Object v : (List)originalHeaders.get(key)) {
            if (decodeHeaders) {
                cleanedValue.add(URLDecoder.decode((String)v, "UTF-8"));
                continue;
            }
            cleanedValue.add((String)v);
        }
        userMetadata.put(key.substring(11), cleanedValue);
    }

    public static String toHex(byte[] data) {
        if (null == data) {
            return null;
        }
        if (data.length <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (byte datum : data) {
            String hv = Integer.toHexString(datum);
            if (hv.length() < 2) {
                sb.append("0");
            } else if (hv.length() == 8) {
                hv = hv.substring(6);
            }
            sb.append(hv);
        }
        return sb.toString().toLowerCase(Locale.getDefault());
    }

    public static byte[] fromHex(String hexData) {
        if (null == hexData) {
            return new byte[0];
        }
        if ((hexData.length() & 1) != 0 || hexData.replaceAll("[a-fA-F0-9]", "").length() > 0) {
            throw new IllegalArgumentException("'" + hexData + "' is not a hex string");
        }
        byte[] result = new byte[(hexData.length() + 1) / 2];
        int byteIndex = 0;
        for (int offset = 0; offset < hexData.length(); offset += 2) {
            String hexNumber = hexData.substring(offset, offset + 2);
            result[byteIndex++] = (byte)Integer.parseInt(hexNumber, 16);
        }
        return result;
    }

    public static String toBase64(byte[] data) {
        return ReflectUtils.toBase64(data);
    }

    public static String join(List<?> items, String delimiter, boolean needTrim) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < items.size(); ++i) {
            String item = items.get(i).toString();
            sb.append(needTrim ? item.trim() : item);
            if (i >= items.size() - 1) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static String join(List<?> items, String delimiter) {
        return ServiceUtils.join(items, delimiter, false);
    }

    public static byte[] fromBase64(String b64Data) throws UnsupportedEncodingException {
        return ReflectUtils.fromBase64(b64Data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] computeMD5Hash(InputStream is) throws NoSuchAlgorithmException, IOException {
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(is);
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[16384];
            int bytesRead = -1;
            while ((bytesRead = bis.read(buffer, 0, buffer.length)) != -1) {
                messageDigest.update(buffer, 0, bytesRead);
            }
            byte[] byArray = messageDigest.digest();
            return byArray;
        }
        finally {
            block9: {
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (IOException e) {
                        if (!log.isWarnEnabled()) break block9;
                        log.warn("close failed.", e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] computeMD5Hash(InputStream is, long length, long offset) throws NoSuchAlgorithmException, IOException {
        BufferedInputStream bis = null;
        try {
            long bufLen;
            bis = new BufferedInputStream(is);
            if (offset > 0L) {
                long skipByte = bis.skip(offset);
                if (log.isDebugEnabled()) {
                    log.debug("computeMD5Hash: Skip " + skipByte + " bytes");
                }
            }
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[16384];
            int bytesRead = -1;
            long readLen = 0L;
            long l = bufLen = 16384L > length ? length : 16384L;
            while (readLen < length && (bytesRead = bis.read(buffer, 0, (int)bufLen)) != -1) {
                messageDigest.update(buffer, 0, bytesRead);
                bufLen = length - (readLen += (long)bytesRead) > 16384L ? 16384L : length - readLen;
            }
            byte[] byArray = messageDigest.digest();
            return byArray;
        }
        finally {
            block11: {
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (IOException e) {
                        if (!log.isWarnEnabled()) break block11;
                        log.warn("close failed.", e);
                    }
                }
            }
        }
    }

    public static String computeMD5(String data) throws ServiceException {
        try {
            return ServiceUtils.toBase64(ServiceUtils.computeMD5Hash(data.getBytes(StandardCharsets.UTF_8)));
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new ServiceException("Failed to get MD5 for requestXmlElement:" + data);
        }
    }

    public static byte[] computeMD5Hash(byte[] data) throws NoSuchAlgorithmException, IOException {
        return ServiceUtils.computeMD5Hash(new ByteArrayInputStream(data));
    }

    public static boolean isBucketNameValidDNSName(String bucketName) {
        String[] fragments;
        if (bucketName == null || bucketName.length() > 63 || bucketName.length() < 3) {
            return false;
        }
        if (!Pattern.matches("^[a-z0-9][a-z0-9.-]+$", bucketName)) {
            return false;
        }
        if (Pattern.matches("(\\d{1,3}\\.){3}\\d{1,3}", bucketName)) {
            return false;
        }
        for (String fragment : fragments = bucketName.split("\\.")) {
            if (!Pattern.matches("^-.*", fragment) && !Pattern.matches(".*-$", fragment) && !Pattern.matches("^$", fragment)) continue;
            return false;
        }
        return true;
    }

    public static String generateHostnameForBucket(String bucketName, boolean pathStyle, String endpoint) {
        if (!ServiceUtils.isBucketNameValidDNSName(bucketName)) {
            throw new IllegalArgumentException("the bucketName is illegal");
        }
        if (!pathStyle) {
            return bucketName + "." + endpoint;
        }
        return endpoint;
    }

    public static XMLReader loadXMLReader() throws ServiceException {
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            try {
                reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
                reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            }
            catch (Exception e) {
                log.warn("Enable protection for XML External Entity Injection Failed");
            }
            return reader;
        }
        catch (Exception e) {
            String[] altXmlReaderClasspaths;
            Exception ex = e;
            for (String xmlReaderClasspath : altXmlReaderClasspaths = new String[]{"org.apache.crimson.parser.XMLReaderImpl", "org.xmlpull.v1.sax2.Driver"}) {
                try {
                    XMLReader reader = XMLReaderFactory.createXMLReader(xmlReaderClasspath);
                    try {
                        reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                        reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                        reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
                        reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                    }
                    catch (Exception e2) {
                        log.warn("Enable protection for XML External Entity Injection Failed");
                    }
                    return reader;
                }
                catch (Exception exception) {
                }
            }
            throw new ServiceException("Failed to initialize a SAX XMLReader", ex);
        }
    }

    public static SimpleDateFormat getShortDateFormat() {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        format.setTimeZone(Constants.GMT_TIMEZONE);
        return format;
    }

    public static SimpleDateFormat getLongDateFormat() {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        format.setTimeZone(Constants.GMT_TIMEZONE);
        return format;
    }

    public static SimpleDateFormat getExpirationDateFormat() {
        SimpleDateFormat format = new SimpleDateFormat(ISO_8601_TIME_PARSER_STRING);
        format.setTimeZone(Constants.GMT_TIMEZONE);
        return format;
    }

    public static ObsException changeFromServiceException(ServiceException se) {
        ObsException exception;
        if (se.getResponseCode() < 0) {
            exception = new ObsException("OBS servcie Error Message. " + se.getMessage(), se.getCause());
        } else {
            exception = new ObsException((se.getMessage() != null ? "Error message:" + se.getMessage() : "") + "OBS servcie Error Message.", se.getXmlMessage(), se.getCause());
            exception.setErrorCode(se.getErrorCode());
            exception.setErrorMessage(se.getErrorMessage() == null ? se.getMessage() : se.getErrorMessage());
            exception.setErrorRequestId(se.getErrorRequestId());
            exception.setErrorHostId(se.getErrorHostId());
            exception.setResponseCode(se.getResponseCode());
            exception.setResponseStatus(se.getResponseStatus());
            exception.setResponseHeaders(se.getResponseHeaders());
            exception.setErrorIndicator(se.getErrorIndicator());
        }
        return exception;
    }

    public static void closeStream(Closeable closeable) {
        block3: {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException e) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn("close failed.", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(InputStream in) throws IOException {
        String ret = null;
        if (in != null) {
            StringBuilder sb = new StringBuilder();
            BufferedReader br = null;
            try {
                String temp;
                br = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
                while ((temp = br.readLine()) != null) {
                    sb.append(temp);
                }
                ret = sb.toString();
            }
            finally {
                block11: {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException e) {
                            if (!log.isWarnEnabled()) break block11;
                            log.warn("close failed.", e);
                        }
                    }
                }
                ServiceUtils.closeStream(in);
            }
        }
        return ret;
    }

    public static ObsProperties changeFromObsConfiguration(ObsConfiguration config) {
        Matcher m;
        int index;
        ObsProperties obsProperties = new ObsProperties();
        String endPoint = config.getEndPoint();
        while ((index = endPoint.lastIndexOf("/")) == endPoint.length() - 1) {
            endPoint = endPoint.substring(0, index);
        }
        if (endPoint.startsWith("http://")) {
            config.setHttpsOnly(false);
            endPoint = endPoint.substring("http://".length());
        } else if (endPoint.startsWith("https://")) {
            config.setHttpsOnly(true);
            endPoint = endPoint.substring("https://".length());
        }
        index = endPoint.lastIndexOf(":");
        if (index > 0) {
            int port = Integer.parseInt(endPoint.substring(index + 1));
            if (config.isHttpsOnly()) {
                config.setEndpointHttpsPort(port);
            } else {
                config.setEndpointHttpPort(port);
            }
            endPoint = endPoint.substring(0, index);
        }
        if ((m = pattern.matcher(endPoint)).matches()) {
            config.setPathStyle(true);
        }
        if (config.isPathStyle() || config.isCname()) {
            config.setAuthTypeNegotiation(false);
            if (config.getAuthType() == AuthTypeEnum.OBS) {
                config.setAuthType(AuthTypeEnum.V2);
            }
        }
        config.setEndPoint(endPoint);
        ServiceUtils.setObsProperties(config, obsProperties);
        return obsProperties;
    }

    private static void setObsProperties(ObsConfiguration config, ObsProperties obsProperties) {
        obsProperties.setProperty("obs-endpoint", config.getEndPoint());
        obsProperties.setProperty("obs-endpoint-http-port", String.valueOf(config.getEndpointHttpPort()));
        obsProperties.setProperty("obs.https-only", String.valueOf(config.isHttpsOnly()));
        obsProperties.setProperty("obs.disable-dns-buckets", String.valueOf(config.isPathStyle()));
        obsProperties.setProperty("obs-endpoint-https-port", String.valueOf(config.getEndpointHttpsPort()));
        obsProperties.setProperty("httpclient.socket-timeout-ms", String.valueOf(config.getSocketTimeout()));
        obsProperties.setProperty("httpclient.max-connections", String.valueOf(config.getMaxConnections()));
        obsProperties.setProperty("httpclient.retry-max", String.valueOf(config.getMaxErrorRetry()));
        obsProperties.setProperty("httpclient.connection-timeout-ms", String.valueOf(config.getConnectionTimeout()));
        obsProperties.setProperty("httpclient.proxy-enable", String.valueOf(Boolean.FALSE));
        obsProperties.setProperty("httpclient.validate-certificate", String.valueOf(config.isValidateCertificate()));
        obsProperties.setProperty("obs.verify-content-type", String.valueOf(config.isVerifyResponseContentType()));
        obsProperties.setProperty("httpclient.write-buffer-size", String.valueOf(config.getWriteBufferSize()));
        obsProperties.setProperty("httpclient.read-buffer-size", String.valueOf(config.getReadBufferSize()));
        obsProperties.setProperty("socket.write-buffer-size", String.valueOf(config.getSocketWriteBufferSize()));
        obsProperties.setProperty("socket.read-buffer-size", String.valueOf(config.getSocketReadBufferSize()));
        obsProperties.setProperty("httpclient.strict-hostname-verification", String.valueOf(config.isStrictHostnameVerification()));
        obsProperties.setProperty("httpclient.idle-connection-time", String.valueOf(config.getIdleConnectionTime()));
        obsProperties.setProperty("httpclient.max-idle-connections", String.valueOf(config.getMaxIdleConnections()));
        obsProperties.setProperty("httpclient.ssl-provider", config.getSslProvider() == null ? "" : config.getSslProvider());
        obsProperties.setProperty("httpclient.keep-alive", String.valueOf(config.isKeepAlive()));
        obsProperties.setProperty("filesystem.delimiter", config.getDelimiter() == null ? "/" : config.getDelimiter());
        obsProperties.setProperty("httpclient.protocol", config.getHttpProtocolType() == null ? HttpProtocolTypeEnum.HTTP1_1.getCode() : config.getHttpProtocolType().getCode());
        obsProperties.setProperty("httpclient.is-cname", String.valueOf(config.isCname()));
        obsProperties.setProperty("httpclient.auth-type-negotiation", String.valueOf(config.isAuthTypeNegotiation()));
        if (null != config.getHttpProxy()) {
            obsProperties.setProperty("httpclient.proxy-enable", String.valueOf(Boolean.TRUE));
            obsProperties.setProperty("httpclient.proxy-host", config.getHttpProxy().getProxyAddr());
            obsProperties.setProperty("httpclient.proxy-port", String.valueOf(config.getHttpProxy().getProxyPort()));
            obsProperties.setProperty("httpclient.proxy-user", config.getHttpProxy().getProxyUName());
            obsProperties.setProperty("httpclient.proxy-password", config.getHttpProxy().getUserPasswd());
            obsProperties.setProperty("httpclient.proxy-domain", config.getHttpProxy().getDomain());
            obsProperties.setProperty("httpclient.proxy-workstation", config.getHttpProxy().getWorkstation());
        }
        if (config instanceof ExtObsConfiguration) {
            obsProperties.setProperty("httpclient.is-retry-on-connection-failure-in-okhttp", String.valueOf(((ExtObsConfiguration)config).isRetryOnConnectionFailureInOkhttp()));
            obsProperties.setProperty("httpclient.max-retry-on-unexpected-end-exception", String.valueOf(((ExtObsConfiguration)config).getMaxRetryOnUnexpectedEndException()));
        }
        if (null != config.getXmlDocumentBuilderFactoryClass() && !config.getXmlDocumentBuilderFactoryClass().trim().equals("")) {
            obsProperties.setProperty("obs.xml.document.builder.factory", config.getXmlDocumentBuilderFactoryClass());
        }
    }

    public static Date cloneDateIgnoreNull(Date date) {
        if (null == date) {
            return null;
        }
        return (Date)date.clone();
    }

    public static void deleteFileIgnoreException(String path) {
        if (null == path) {
            return;
        }
        if (!ServiceUtils.deleteFileIgnoreException(new File(path))) {
            log.warn("delete file '" + path + "' failed");
        }
    }

    public static boolean deleteFileIgnoreException(File file) {
        if (null == file) {
            return true;
        }
        if (file.exists() && file.isFile()) {
            return file.delete();
        }
        return true;
    }
}

