/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services;

import com.obs.services.AbstractClient;
import com.obs.services.AbstractDeprecatedBucketClient;
import com.obs.services.exception.ObsException;
import com.obs.services.internal.ServiceException;
import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.model.AccessControlList;
import com.obs.services.model.AuthTypeEnum;
import com.obs.services.model.BaseBucketRequest;
import com.obs.services.model.BucketCors;
import com.obs.services.model.BucketCustomDomainInfo;
import com.obs.services.model.BucketLocationResponse;
import com.obs.services.model.BucketLoggingConfiguration;
import com.obs.services.model.BucketMetadataInfoRequest;
import com.obs.services.model.BucketMetadataInfoResult;
import com.obs.services.model.BucketQuota;
import com.obs.services.model.BucketStorageInfo;
import com.obs.services.model.BucketStoragePolicyConfiguration;
import com.obs.services.model.BucketVersioningConfiguration;
import com.obs.services.model.CreateBucketRequest;
import com.obs.services.model.CreateSnapshotRequest;
import com.obs.services.model.CreateSnapshotResponse;
import com.obs.services.model.CreateVirtualBucketRequest;
import com.obs.services.model.CreateVirtualBucketResult;
import com.obs.services.model.CustomDomainCertificateConfig;
import com.obs.services.model.DeleteBucketCustomDomainRequest;
import com.obs.services.model.DeleteBucketLifecycleRequest;
import com.obs.services.model.DeleteSnapshotRequest;
import com.obs.services.model.GenericRequest;
import com.obs.services.model.GetBucketCustomDomainRequest;
import com.obs.services.model.GetSnapshotListRequest;
import com.obs.services.model.GetSnapshotListResponse;
import com.obs.services.model.GetSnapshottableDirListRequest;
import com.obs.services.model.GetSnapshottableDirListResult;
import com.obs.services.model.HeaderResponse;
import com.obs.services.model.ListBucketAliasResult;
import com.obs.services.model.ListBucketsRequest;
import com.obs.services.model.ListBucketsResult;
import com.obs.services.model.ObsBucket;
import com.obs.services.model.Qos.DeleteBucketQosRequest;
import com.obs.services.model.Qos.GetBucketQoSRequest;
import com.obs.services.model.Qos.GetBucketQoSResult;
import com.obs.services.model.Qos.QosRule;
import com.obs.services.model.Qos.SetBucketQosRequest;
import com.obs.services.model.RenameSnapshotRequest;
import com.obs.services.model.RenameSnapshotResponse;
import com.obs.services.model.RequestPaymentConfiguration;
import com.obs.services.model.RequestPaymentEnum;
import com.obs.services.model.SetBucketAclRequest;
import com.obs.services.model.SetBucketCorsRequest;
import com.obs.services.model.SetBucketCustomDomainRequest;
import com.obs.services.model.SetBucketLoggingRequest;
import com.obs.services.model.SetBucketQuotaRequest;
import com.obs.services.model.SetBucketRequestPaymentRequest;
import com.obs.services.model.SetBucketStoragePolicyRequest;
import com.obs.services.model.SetBucketVersioningRequest;
import com.obs.services.model.SetDisallowSnapshotRequest;
import com.obs.services.model.SetSnapshotAllowRequest;
import com.obs.services.model.inventory.DeleteInventoryConfigurationRequest;
import com.obs.services.model.inventory.GetInventoryConfigurationRequest;
import com.obs.services.model.inventory.GetInventoryConfigurationResult;
import com.obs.services.model.inventory.ListInventoryConfigurationRequest;
import com.obs.services.model.inventory.ListInventoryConfigurationResult;
import com.obs.services.model.inventory.SetInventoryConfigurationRequest;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class AbstractBucketClient
extends AbstractDeprecatedBucketClient {
    private <T, R> T executeAction(String actionName, R request, Function<R, String> nameExtractor, Runnable additionalValidation, final Supplier<T> implementation) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "request is null");
        String bucketName = nameExtractor.apply(request);
        ServiceUtils.assertParameterNotNull2(bucketName, "bucketName is null");
        if (additionalValidation != null) {
            additionalValidation.run();
        }
        return this.doActionWithResult(actionName, bucketName, new AbstractClient.ActionCallbackWithResult<T>(this){
            final /* synthetic */ AbstractBucketClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public T action() throws ServiceException {
                return implementation.get();
            }
        });
    }

    @Override
    public ObsBucket createBucket(String bucketName) throws ObsException {
        ObsBucket obsBucket = new ObsBucket();
        obsBucket.setBucketName(bucketName);
        return this.createBucket(obsBucket);
    }

    @Override
    public ObsBucket createBucket(String bucketName, String location) throws ObsException {
        ObsBucket obsBucket = new ObsBucket();
        obsBucket.setBucketName(bucketName);
        obsBucket.setLocation(location);
        return this.createBucket(obsBucket);
    }

    @Override
    public ObsBucket createBucket(ObsBucket bucket) throws ObsException {
        CreateBucketRequest request = new CreateBucketRequest();
        request.setBucketName(bucket.getBucketName());
        request.setAcl(bucket.getAcl());
        request.setBucketStorageClass(bucket.getBucketStorageClass());
        request.setLocation(bucket.getLocation());
        return this.createBucket(request);
    }

    @Override
    public ObsBucket createBucket(final CreateBucketRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "CreateBucketRequest is null");
        return this.doActionWithResult("createBucket", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<ObsBucket>(this){
            final /* synthetic */ AbstractBucketClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public ObsBucket action() throws ServiceException {
                if (this.this$0.isCname()) {
                    throw new ServiceException("createBucket is not allowed in customdomain mode");
                }
                try {
                    return this.this$0.createBucketImpl(request);
                }
                catch (ServiceException e) {
                    if (this.this$0.isAuthTypeNegotiation() && e.getResponseCode() == 400 && "Unsupported Authorization Type".equals(e.getErrorMessage()) && this.this$0.getProviderCredentials().getLocalAuthType(request.getBucketName()) == AuthTypeEnum.OBS) {
                        this.this$0.getProviderCredentials().setLocalAuthType(request.getBucketName(), AuthTypeEnum.V2);
                        return this.this$0.createBucketImpl(request);
                    }
                    throw e;
                }
            }

            @Override
            void authTypeNegotiate(String bucketName) throws ServiceException {
                AuthTypeEnum authTypeEnum = this.this$0.getProviderCredentials().getLocalAuthType().get(bucketName);
                if (authTypeEnum == null) {
                    authTypeEnum = this.this$0.getApiVersion("");
                    this.this$0.getProviderCredentials().setLocalAuthType(bucketName, authTypeEnum);
                }
            }
        });
    }

    @Override
    public CreateVirtualBucketResult createVirtualBucket(final CreateVirtualBucketRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "CreateVirtualBucketRequest is null");
        ServiceUtils.assertParameterNotNull(request.getBucketAlias(), "bucket alias is null");
        ServiceUtils.assertParameterNotNull(request.getBucketName1(), "bucket name1 is null");
        ServiceUtils.assertParameterNotNull(request.getBucketName2(), "bucket name2 is null");
        ServiceUtils.assertParameterNotNull(request.getAgencyId(), "agency id is null");
        ServiceUtils.assertParameterNotNull(request.getRegionId(), "region id is null");
        ServiceUtils.assertParameterNotNull(request.getToken(), "token is null");
        return this.doActionWithResult("createVirtualBucket", "All Buckets", new AbstractClient.ActionCallbackWithResult<CreateVirtualBucketResult>(this){
            final /* synthetic */ AbstractBucketClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public CreateVirtualBucketResult action() throws ServiceException {
                if (this.this$0.isCname()) {
                    throw new ServiceException("createVirtualBucket is not allowed in customdomain mode");
                }
                return this.this$0.createVirtualBucketImpl(request);
            }

            @Override
            void authTypeNegotiate(String bucketName) throws ServiceException {
                AuthTypeEnum authTypeEnum = this.this$0.getProviderCredentials().getLocalAuthType().get(bucketName);
                if (authTypeEnum == null) {
                    authTypeEnum = this.this$0.getApiVersion("");
                    this.this$0.getProviderCredentials().setLocalAuthType(bucketName, authTypeEnum);
                }
            }
        });
    }

    @Override
    public List<ObsBucket> listBuckets(ListBucketsRequest request) throws ObsException {
        return this.listBucketsV2(request).getBuckets();
    }

    @Override
    public ListBucketsResult listBucketsV2(final ListBucketsRequest request) throws ObsException {
        return this.doActionWithResult("listBuckets", "All Buckets", new AbstractClient.ActionCallbackWithResult<ListBucketsResult>(this){
            final /* synthetic */ AbstractBucketClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public ListBucketsResult action() throws ServiceException {
                if (this.this$0.isCname()) {
                    throw new ServiceException("listBuckets is not allowed in customdomain mode");
                }
                return this.this$0.listAllBucketsImpl(request);
            }

            @Override
            void authTypeNegotiate(String bucketName) throws ServiceException {
                AuthTypeEnum authTypeEnum = this.this$0.getProviderCredentials().getLocalAuthType().get(bucketName);
                if (authTypeEnum == null) {
                    authTypeEnum = this.this$0.getApiVersion("");
                    this.this$0.getProviderCredentials().setLocalAuthType(bucketName, authTypeEnum);
                }
            }
        });
    }

    @Override
    public ListBucketAliasResult listAliasBuckets() throws ObsException {
        return this.doActionWithResult("ListBucketAliasResult", "All Buckets", new AbstractClient.ActionCallbackWithResult<ListBucketAliasResult>(){

            @Override
            public ListBucketAliasResult action() throws ServiceException {
                return AbstractBucketClient.this.listAliasBucketsImpl();
            }

            @Override
            void authTypeNegotiate(String bucketName) throws ServiceException {
                AuthTypeEnum authTypeEnum = AbstractBucketClient.this.getProviderCredentials().getLocalAuthType().get(bucketName);
                if (authTypeEnum == null) {
                    authTypeEnum = AbstractBucketClient.this.getApiVersion("");
                    AbstractBucketClient.this.getProviderCredentials().setLocalAuthType(bucketName, authTypeEnum);
                }
            }
        });
    }

    @Override
    public boolean headBucket(String bucketName) throws ObsException {
        return this.headBucket(new BaseBucketRequest(bucketName));
    }

    @Override
    public boolean headBucket(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.assertParameterNotNull(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("headBucket", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<Boolean>(this){
            final /* synthetic */ AbstractBucketClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public Boolean action() throws ServiceException {
                return this.this$0.headBucketImpl(request);
            }

            @Override
            void authTypeNegotiate(String bucketName) throws ServiceException {
                block3: {
                    try {
                        AuthTypeEnum authTypeEnum = this.this$0.getProviderCredentials().getLocalAuthType().get(bucketName);
                        if (authTypeEnum == null) {
                            authTypeEnum = this.this$0.getApiVersion(bucketName);
                            this.this$0.getProviderCredentials().setLocalAuthType(bucketName, authTypeEnum);
                        }
                    }
                    catch (ServiceException e) {
                        if (e.getResponseCode() == 404) break block3;
                        throw e;
                    }
                }
            }
        });
    }

    @Override
    public HeaderResponse deleteBucket(String bucketName) throws ObsException {
        return this.deleteBucket(new BaseBucketRequest(bucketName));
    }

    @Override
    public HeaderResponse deleteBucket(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.assertParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("deleteBucket", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(this){
            final /* synthetic */ AbstractBucketClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public HeaderResponse action() throws ServiceException {
                return this.this$0.deleteBucketImpl(request);
            }
        });
    }

    @Override
    public BucketMetadataInfoResult getBucketMetadata(final BucketMetadataInfoRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "BucketMetadataInfoRequest is null");
        return this.doActionWithResult("getBucketMetadata", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<BucketMetadataInfoResult>(this){
            final /* synthetic */ AbstractBucketClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public BucketMetadataInfoResult action() throws ServiceException {
                return this.this$0.getBucketMetadataImpl(request);
            }
        });
    }

    @Override
    public AccessControlList getBucketAcl(String bucketName) throws ObsException {
        return this.getBucketAcl(new BaseBucketRequest(bucketName));
    }

    @Override
    public AccessControlList getBucketAcl(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.assertParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("getBucketAcl", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<AccessControlList>(this){
            final /* synthetic */ AbstractBucketClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public AccessControlList action() throws ServiceException {
                return this.this$0.getBucketAclImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse setBucketAcl(String bucketName, AccessControlList acl) throws ObsException {
        return this.setBucketAcl(new SetBucketAclRequest(bucketName, acl));
    }

    @Override
    public HeaderResponse setBucketAcl(final SetBucketAclRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "SetBucketAclRequest is null");
        return this.doActionWithResult("setBucketAcl", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(this){
            final /* synthetic */ AbstractBucketClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public HeaderResponse action() throws ServiceException {
                if (request.getAcl() == null && null == request.getCannedACL()) {
                    throw new IllegalArgumentException("Both CannedACL and AccessControlList is null");
                }
                return this.this$0.setBucketAclImpl(request);
            }
        });
    }

    @Override
    public String getBucketLocation(String bucketName) throws ObsException {
        return this.getBucketLocation(new BaseBucketRequest(bucketName)).getLocation();
    }

    @Override
    public BucketLocationResponse getBucketLocation(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "BaseBucketRequest is null");
        return this.doActionWithResult("getBucketLocation", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<BucketLocationResponse>(this){
            final /* synthetic */ AbstractBucketClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public BucketLocationResponse action() throws ServiceException {
                return this.this$0.getBucketLocationImpl(request);
            }
        });
    }

    @Override
    public BucketLocationResponse getBucketLocationV2(String bucketName) throws ObsException {
        return this.getBucketLocation(new BaseBucketRequest(bucketName));
    }

    @Override
    public BucketStorageInfo getBucketStorageInfo(String bucketName) throws ObsException {
        return this.getBucketStorageInfo(new BaseBucketRequest(bucketName));
    }

    @Override
    public BucketStorageInfo getBucketStorageInfo(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.assertParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("getBucketStorageInfo", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<BucketStorageInfo>(this){
            final /* synthetic */ AbstractBucketClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public BucketStorageInfo action() throws ServiceException {
                return this.this$0.getBucketStorageInfoImpl(request);
            }
        });
    }

    @Override
    public BucketQuota getBucketQuota(String bucketName) throws ObsException {
        return this.getBucketQuota(new BaseBucketRequest(bucketName));
    }

    @Override
    public BucketQuota getBucketQuota(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "BaseBucketRequest is null");
        return this.doActionWithResult("getBucketQuota", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<BucketQuota>(this){
            final /* synthetic */ AbstractBucketClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public BucketQuota action() throws ServiceException {
                return this.this$0.getBucketQuotaImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse setBucketQuota(String bucketName, BucketQuota bucketQuota) throws ObsException {
        return this.setBucketQuota(new SetBucketQuotaRequest(bucketName, bucketQuota));
    }

    @Override
    public HeaderResponse setBucketQuota(final SetBucketQuotaRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "SetBucketQuotaRequest is null");
        ServiceUtils.assertParameterNotNull(request.getBucketQuota(), "The bucket '" + request.getBucketName() + "' does not include Quota information");
        return this.doActionWithResult("setBucketQuota", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(this){
            final /* synthetic */ AbstractBucketClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public HeaderResponse action() throws ServiceException {
                return this.this$0.setBucketQuotaImpl(request);
            }
        });
    }

    @Override
    public BucketStoragePolicyConfiguration getBucketStoragePolicy(String bucketName) throws ObsException {
        return this.getBucketStoragePolicy(new BaseBucketRequest(bucketName));
    }

    @Override
    public BucketStoragePolicyConfiguration getBucketStoragePolicy(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "BaseBucketRequest is null");
        return this.doActionWithResult("getBucketStoragePolicy", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<BucketStoragePolicyConfiguration>(this){
            final /* synthetic */ AbstractBucketClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public BucketStoragePolicyConfiguration action() throws ServiceException {
                return this.this$0.getBucketStoragePolicyImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse setBucketStoragePolicy(String bucketName, BucketStoragePolicyConfiguration bucketStorage) throws ObsException {
        return this.setBucketStoragePolicy(new SetBucketStoragePolicyRequest(bucketName, bucketStorage));
    }

    @Override
    public HeaderResponse setBucketStoragePolicy(final SetBucketStoragePolicyRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "SetBucketStoragePolicyRequest is null");
        ServiceUtils.assertParameterNotNull(request.getBucketStorage(), "The bucket '" + request.getBucketName() + "' does not include storagePolicy information");
        return this.doActionWithResult("setBucketStoragePolicy", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(this){
            final /* synthetic */ AbstractBucketClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public HeaderResponse action() throws ServiceException {
                return this.this$0.setBucketStorageImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse setBucketCors(String bucketName, BucketCors bucketCors) throws ObsException {
        return this.setBucketCors(new SetBucketCorsRequest(bucketName, bucketCors));
    }

    @Override
    public HeaderResponse setBucketCors(final SetBucketCorsRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "SetBucketCorsRequest is null");
        return this.doActionWithResult("setBucketCors", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(this){
            final /* synthetic */ AbstractBucketClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public HeaderResponse action() throws ServiceException {
                return this.this$0.setBucketCorsImpl(request);
            }
        });
    }

    @Override
    public BucketCors getBucketCors(String bucketName) throws ObsException {
        return this.getBucketCors(new BaseBucketRequest(bucketName));
    }

    @Override
    public BucketCors getBucketCors(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "BaseBucketRequest is null");
        return this.doActionWithResult("getBucketCors", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<BucketCors>(this){
            final /* synthetic */ AbstractBucketClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public BucketCors action() throws ServiceException {
                return this.this$0.getBucketCorsImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse deleteBucketCors(String bucketName) throws ObsException {
        return this.deleteBucketCors(new BaseBucketRequest(bucketName));
    }

    @Override
    public HeaderResponse deleteBucketCors(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "BaseBucketRequest is null");
        return this.doActionWithResult("deleteBucketCors", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(this){
            final /* synthetic */ AbstractBucketClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public HeaderResponse action() throws ServiceException {
                return this.this$0.deleteBucketCorsImpl(request);
            }
        });
    }

    @Override
    public BucketLoggingConfiguration getBucketLogging(String bucketName) throws ObsException {
        return this.getBucketLogging(new BaseBucketRequest(bucketName));
    }

    @Override
    public BucketLoggingConfiguration getBucketLogging(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "BaseBucketRequest is null");
        return this.doActionWithResult("getBucketLoggingConfiguration", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<BucketLoggingConfiguration>(this){
            final /* synthetic */ AbstractBucketClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public BucketLoggingConfiguration action() throws ServiceException {
                return this.this$0.getBucketLoggingConfigurationImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse setBucketLoggingConfiguration(String bucketName, BucketLoggingConfiguration loggingConfiguration, boolean updateTargetACLifRequired) throws ObsException {
        return this.setBucketLogging(new SetBucketLoggingRequest(bucketName, loggingConfiguration, updateTargetACLifRequired));
    }

    @Override
    public HeaderResponse setBucketLogging(String bucketName, BucketLoggingConfiguration loggingConfiguration) throws ObsException {
        return this.setBucketLogging(new SetBucketLoggingRequest(bucketName, loggingConfiguration));
    }

    @Override
    public HeaderResponse setBucketLogging(final SetBucketLoggingRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "SetBucketLoggingRequest is null");
        return this.doActionWithResult("setBucketLoggingConfiguration", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(this){
            final /* synthetic */ AbstractBucketClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public HeaderResponse action() throws ServiceException {
                return this.this$0.setBucketLoggingConfigurationImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse setBucketVersioning(String bucketName, BucketVersioningConfiguration versioningConfiguration) throws ObsException {
        return this.setBucketVersioning(new SetBucketVersioningRequest(bucketName, versioningConfiguration.getVersioningStatus()));
    }

    @Override
    public HeaderResponse setBucketVersioning(final SetBucketVersioningRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "SetBucketVersioningRequest is null");
        ServiceUtils.assertParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("setBucketVersioning", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(this){
            final /* synthetic */ AbstractBucketClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public HeaderResponse action() throws ServiceException {
                return this.this$0.setBucketVersioningImpl(request);
            }
        });
    }

    @Override
    public BucketVersioningConfiguration getBucketVersioning(String bucketName) throws ObsException {
        return this.getBucketVersioning(new BaseBucketRequest(bucketName));
    }

    @Override
    public BucketVersioningConfiguration getBucketVersioning(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.assertParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("getBucketVersioning", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<BucketVersioningConfiguration>(this){
            final /* synthetic */ AbstractBucketClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public BucketVersioningConfiguration action() throws ServiceException {
                return this.this$0.getBucketVersioningImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse setBucketRequestPayment(String bucketName, RequestPaymentEnum payer) throws ObsException {
        return this.setBucketRequestPayment(new SetBucketRequestPaymentRequest(bucketName, payer));
    }

    @Override
    public HeaderResponse setBucketRequestPayment(final SetBucketRequestPaymentRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "SetBucketRequestPaymentRequest is null");
        return this.doActionWithResult("setBucketRequestPayment", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(this){
            final /* synthetic */ AbstractBucketClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public HeaderResponse action() throws ServiceException {
                ServiceUtils.assertParameterNotNull2(request.getBucketName(), "bucketName is null");
                ServiceUtils.assertParameterNotNull((Object)request.getPayer(), "payer is null");
                return this.this$0.setBucketRequestPaymentImpl(request);
            }
        });
    }

    @Override
    public RequestPaymentConfiguration getBucketRequestPayment(String bucketName) throws ObsException {
        return this.getBucketRequestPayment(new BaseBucketRequest(bucketName));
    }

    @Override
    public RequestPaymentConfiguration getBucketRequestPayment(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.assertParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("getBucketRequestPayment", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<RequestPaymentConfiguration>(this){
            final /* synthetic */ AbstractBucketClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public RequestPaymentConfiguration action() throws ServiceException {
                return this.this$0.getBucketRequestPaymentImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse deleteBucketCustomDomain(String bucketName, String domainName) throws ObsException {
        return this.deleteBucketCustomDomain(new DeleteBucketCustomDomainRequest(bucketName, domainName));
    }

    @Override
    public HeaderResponse deleteBucketCustomDomain(final DeleteBucketCustomDomainRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "request is null");
        ServiceUtils.assertParameterNotNull(request.getBucketName(), "bucketName is null");
        ServiceUtils.assertParameterNotNull2(request.getDomainName(), "domainName is null");
        return this.doActionWithResult("setBucketCustomDomain", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(this){
            final /* synthetic */ AbstractBucketClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public HeaderResponse action() throws ServiceException {
                return this.this$0.deleteBucketCustomDomainImpl(request);
            }
        });
    }

    @Override
    public BucketCustomDomainInfo getBucketCustomDomain(String bucketName) throws ObsException {
        return this.getBucketCustomDomain(new GetBucketCustomDomainRequest(bucketName));
    }

    @Override
    public BucketCustomDomainInfo getBucketCustomDomain(final GetBucketCustomDomainRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.assertParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("getBucketCustomDomain", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<BucketCustomDomainInfo>(this){
            final /* synthetic */ AbstractBucketClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public BucketCustomDomainInfo action() throws ServiceException {
                return this.this$0.getBucketCustomDomainImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse setBucketCustomDomain(String bucketName, String domainName) throws ObsException {
        return this.setBucketCustomDomain(new SetBucketCustomDomainRequest(bucketName, domainName));
    }

    @Override
    public HeaderResponse setBucketCustomDomain(final SetBucketCustomDomainRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "Request is null");
        ServiceUtils.assertParameterNotNull(request.getBucketName(), "Bucket name is null");
        ServiceUtils.assertParameterNotNull2(request.getDomainName(), "Domain name is null");
        CustomDomainCertificateConfig.checkCertificateConfig(request.getCustomDomainCertificateConfig());
        return this.doActionWithResult("setBucketCustomDomain", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(this){
            final /* synthetic */ AbstractBucketClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public HeaderResponse action() throws ServiceException {
                return this.this$0.setBucketCustomDomainImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse setInventoryConfiguration(final SetInventoryConfigurationRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "request is null");
        ServiceUtils.assertParameterNotNull(request.getBucketName(), "bucketName is null");
        ServiceUtils.assertParameterNotNull(request.getInventoryConfiguration(), "inventoryConfiguration is null");
        return this.doActionWithResult("setInventoryConfiguration", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(this){
            final /* synthetic */ AbstractBucketClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public HeaderResponse action() throws ServiceException {
                return this.this$0.setInventoryConfigurationImpl(request);
            }
        });
    }

    @Override
    public GetInventoryConfigurationResult getInventoryConfiguration(final GetInventoryConfigurationRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "request is null");
        ServiceUtils.assertParameterNotNull2(request.getBucketName(), "bucketName is null");
        ServiceUtils.assertParameterNotNull2(request.getConfigurationId(), "configurationId is null");
        return this.doActionWithResult("getInventoryConfiguration", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<GetInventoryConfigurationResult>(this){
            final /* synthetic */ AbstractBucketClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public GetInventoryConfigurationResult action() throws ServiceException {
                return this.this$0.getInventoryConfigurationImpl(request);
            }
        });
    }

    @Override
    public ListInventoryConfigurationResult listInventoryConfiguration(final ListInventoryConfigurationRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "request is null");
        ServiceUtils.assertParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("listInventoryConfiguration", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<ListInventoryConfigurationResult>(this){
            final /* synthetic */ AbstractBucketClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public ListInventoryConfigurationResult action() throws ServiceException {
                return this.this$0.listInventoryConfigurationImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse deleteInventoryConfiguration(final DeleteInventoryConfigurationRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "request is null");
        ServiceUtils.assertParameterNotNull2(request.getBucketName(), "bucketName is null");
        ServiceUtils.assertParameterNotNull2(request.getConfigurationId(), "configurationId is null");
        return this.doActionWithResult("deleteInventoryConfiguration", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(this){
            final /* synthetic */ AbstractBucketClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public HeaderResponse action() throws ServiceException {
                return this.this$0.deleteInventoryConfigurationImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse setBucketQos(final SetBucketQosRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request, "setBucketQosRequest is null");
        ServiceUtils.assertParameterNotNull(request.getBucketName(), "bucketName is null");
        ServiceUtils.assertParameterNotNull(request.getQosConfig(), "QosConfig is null");
        ServiceUtils.assertParameterNotNull(request.getQosConfig().getRules(), "rules is null");
        List<QosRule> rules = request.getQosConfig().getRules();
        if (rules.isEmpty()) {
            throw new IllegalArgumentException("rules is empty");
        }
        for (QosRule rule : rules) {
            ServiceUtils.assertParameterNotNull((Object)rule.getNetworkType(), "networkType is null");
            ServiceUtils.assertParameterNotNull(rule.getQpsLimit(), "qpsLimit is null");
            ServiceUtils.assertParameterNotNull(rule.getBpsLimit(), "bpsLimit is null");
        }
        return this.doActionWithResult("setBucketQoS", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(this){
            final /* synthetic */ AbstractBucketClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public HeaderResponse action() throws ServiceException {
                return this.this$0.setBucketQosImpl(request);
            }
        });
    }

    @Override
    public GetBucketQoSResult getBucketQoS(final GetBucketQoSRequest request) {
        ServiceUtils.assertParameterNotNull(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("getBucketQos", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<GetBucketQoSResult>(this){
            final /* synthetic */ AbstractBucketClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public GetBucketQoSResult action() throws ServiceException {
                return this.this$0.getBucketQosImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse deleteBucketQoS(final DeleteBucketQosRequest request) throws ObsException {
        ServiceUtils.assertParameterNotNull(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("deleteBucketQos", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(this){
            final /* synthetic */ AbstractBucketClient this$0;
            {
                this.this$0 = this$0;
                super(this$0);
            }

            @Override
            public HeaderResponse action() throws ServiceException {
                return this.this$0.deleteBucketQosImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse deleteSnapshot(DeleteSnapshotRequest request) throws ObsException {
        return this.executeAction("deleteSnapshot", request, GenericRequest::getBucketName, () -> {
            ServiceUtils.assertParameterNotNull2(request.getObjectKey(), "objectKey is null");
            ServiceUtils.assertParameterNotNull2(request.getSnapshotName(), "snapshotName is null");
        }, () -> this.deleteSnapshotImpl(request));
    }

    @Override
    public HeaderResponse setSnapshotAllow(SetSnapshotAllowRequest request) throws ObsException {
        return this.executeAction("setSnapshotAllow", request, GenericRequest::getBucketName, () -> ServiceUtils.assertParameterNotNull2(request.getObjectKey(), "objectKey is null"), () -> this.setSnapshotAllowImpl(request));
    }

    @Override
    public HeaderResponse setDisallowSnapshot(SetDisallowSnapshotRequest request) throws ObsException {
        return this.executeAction("setDisallowSnapshot", request, GenericRequest::getBucketName, () -> ServiceUtils.assertParameterNotNull2(request.getObjectKey(), "objectKey is null"), () -> this.setDisallowSnapshotImpl(request));
    }

    @Override
    public GetSnapshottableDirListResult getSnapshottableDirList(GetSnapshottableDirListRequest request) throws ObsException {
        return this.executeAction("getSnapshottableDirList", request, GenericRequest::getBucketName, () -> ServiceUtils.assertParameterNotNegative(request.getMaxKeys(), "maxKeys is negative"), () -> this.getSnapshottableDirListImpl(request));
    }

    @Override
    public GetSnapshotListResponse getSnapshotList(GetSnapshotListRequest request) throws ObsException {
        return this.executeAction("getSnapshotList", request, GenericRequest::getBucketName, () -> ServiceUtils.assertParameterNotNegative(request.getMaxKeys(), "maxKeys is negative"), () -> this.getSnapshotListImpl(request));
    }

    @Override
    public CreateSnapshotResponse createSnapshot(CreateSnapshotRequest request) throws ObsException {
        return this.executeAction("createSnapshot", request, GenericRequest::getBucketName, () -> {
            ServiceUtils.assertParameterNotNull2(request.getObjectKey(), "objectKey is null");
            ServiceUtils.assertParameterNotNull2(request.getSnapshotName(), "snapshotName is null");
            ServiceUtils.checkParameterLength("Snapshot", request.getSnapshotName(), 1, 255);
            ServiceUtils.checkParameterLength("ObjectKey", request.getObjectKey(), 1, 1024);
        }, () -> this.createSnapshotImpl(request));
    }

    @Override
    public RenameSnapshotResponse renameSnapshot(RenameSnapshotRequest request) throws ObsException {
        return this.executeAction("renameSnapshot", request, GenericRequest::getBucketName, () -> {
            ServiceUtils.assertParameterNotNull2(request.getObjectKey(), "objectKey is null");
            ServiceUtils.assertParameterNotNull2(request.getOldSnapshotName(), "oldSnapshotName is null");
            ServiceUtils.assertParameterNotNull2(request.getNewSnapshotName(), "newSnapshotName is null");
        }, () -> this.renameSnapshotImpl(request));
    }

    @Override
    public abstract HeaderResponse deleteBucketLifecycle(DeleteBucketLifecycleRequest var1) throws ObsException;
}

