/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.utils;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.exception.ObsException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import okhttp3.Call;

public class CallCancelHandler {
    private final AtomicInteger maxCancelQueueCapacity = new AtomicInteger(0);
    protected static final ILogger log = LoggerBuilder.getLogger(CallCancelHandler.class);
    protected AtomicBoolean isCancelled = new AtomicBoolean(false);
    protected ConcurrentLinkedQueue<Call> calls = new ConcurrentLinkedQueue();

    public void cancel() {
        this.isCancelled.set(true);
        this.calls.forEach(call -> {
            if (call != null && !call.isCanceled()) {
                call.cancel();
            }
        });
        this.calls.clear();
    }

    public boolean isCancelled() {
        return this.isCancelled.get();
    }

    public void setCall(Call call) {
        if (this.isCancelled.get()) {
            String msg = "transport is cancelled";
            msg = call == null ? msg + ", call is null" : (call.request() == null ? msg + ", call's request is null" : msg + ", url :" + call.request().url());
            log.warn(msg);
            throw new ObsException("transport is cancelled by cancelHandler");
        }
        if (this.calls.size() >= this.maxCancelQueueCapacity.get()) {
            log.debug(this.getClass().getName() + "'s calls Capacity is full. cancel may not working! try adjust it by setMaxCallCapacity");
        } else {
            this.calls.add(call);
        }
    }

    public void removeFinishedCall(Call call) {
        this.calls.remove(call);
    }

    public void resetCancelStatus() {
        this.calls.clear();
        this.isCancelled.set(false);
    }

    public int getMaxCallCapacity() {
        return this.maxCancelQueueCapacity.get();
    }

    public void setMaxCallCapacity(int maxCancelQueueCapacity) {
        this.maxCancelQueueCapacity.set(maxCancelQueueCapacity);
    }
}

