/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.config;

import com.huaweicloud.common.exception.ServiceCombRuntimeException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="spring.cloud.servicecomb.config")
public class ServiceCombConfigProperties {
    private boolean enabled = true;
    private boolean firstPullRequired = true;
    @Value(value="${spring.cloud.servicecomb.discovery.address:}")
    private String discoveryAddress;
    @Value(value="${spring.cloud.servicecomb.discovery.serviceName:${spring.application.name:}}")
    private String serviceName;
    @Value(value="${spring.cloud.servicecomb.discovery.appName:default}")
    private String appName;
    @Value(value="${spring.cloud.servicecomb.discovery.version:}")
    private String version;
    @Value(value="${server.env:}")
    private String env;
    @Value(value="${spring.cloud.servicecomb.config.serverType:}")
    private String serverType;
    private String serverAddr;
    @Value(value="${spring.cloud.servicecomb.config.fileSource:}")
    private String fileSource;
    private Watch watch = new Watch();
    private Kie kie = new Kie();

    public String getFileSource() {
        return this.fileSource;
    }

    public void setFileSource(String fileSource) {
        this.fileSource = fileSource;
    }

    public String getDiscoveryAddress() {
        return this.discoveryAddress;
    }

    public void setDiscoveryAddress(String discoveryAddress) {
        this.discoveryAddress = discoveryAddress;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getServerAddr() {
        return this.serverAddr;
    }

    public void setServerAddr(String serverAddr) {
        this.serverAddr = serverAddr;
    }

    public Watch getWatch() {
        return this.watch;
    }

    public void setWatch(Watch watch) {
        this.watch = watch;
    }

    public void setKie(Kie kie) {
        this.kie = kie;
    }

    public Kie getKie() {
        return this.kie;
    }

    public String getServiceName() {
        if (StringUtils.isEmpty((CharSequence)this.serviceName)) {
            throw new ServiceCombRuntimeException("please use bootstrap.yml for config properties.");
        }
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getEnv() {
        return this.env;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public String getServerType() {
        return this.serverType;
    }

    public void setServerType(String serverType) {
        this.serverType = serverType;
    }

    public boolean isFirstPullRequired() {
        return this.firstPullRequired;
    }

    public void setFirstPullRequired(boolean firstPullRequired) {
        this.firstPullRequired = firstPullRequired;
    }

    public static class Kie {
        private boolean enableAppConfig = true;
        private boolean enableServiceConfig = true;
        private boolean enableCustomConfig = true;
        private String customLabelValue = "";
        private String customLabel = "public";
        private boolean enableLongPolling = true;
        private int pollingWaitTimeInSeconds = 10;

        public int getPollingWaitTimeInSeconds() {
            return this.pollingWaitTimeInSeconds;
        }

        public void setPollingWaitTimeInSeconds(int pollingWaitTimeInSeconds) {
            this.pollingWaitTimeInSeconds = pollingWaitTimeInSeconds;
        }

        public boolean isEnableLongPolling() {
            return this.enableLongPolling;
        }

        public void setEnableLongPolling(boolean enableLongPolling) {
            this.enableLongPolling = enableLongPolling;
        }

        public boolean isEnableAppConfig() {
            return this.enableAppConfig;
        }

        public void setEnableAppConfig(boolean enableAppConfig) {
            this.enableAppConfig = enableAppConfig;
        }

        public boolean isEnableServiceConfig() {
            return this.enableServiceConfig;
        }

        public void setEnableServiceConfig(boolean enableServiceConfig) {
            this.enableServiceConfig = enableServiceConfig;
        }

        public boolean isEnableCustomConfig() {
            return this.enableCustomConfig;
        }

        public void setEnableCustomConfig(boolean enableCustomConfig) {
            this.enableCustomConfig = enableCustomConfig;
        }

        public String getCustomLabelValue() {
            return this.customLabelValue;
        }

        public void setCustomLabelValue(String customLabelValue) {
            this.customLabelValue = customLabelValue;
        }

        public String getCustomLabel() {
            return this.customLabel;
        }

        public void setCustomLabel(String customLabel) {
            this.customLabel = customLabel;
        }
    }

    public static class Watch {
        private boolean enable;
        private int delay = 10000;
        private int waitTime = 10000;

        public boolean isEnable() {
            return this.enable;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }

        public int getDelay() {
            return this.delay;
        }

        public void setDelay(int delay) {
            this.delay = delay;
        }

        public int getWaitTime() {
            return this.waitTime;
        }

        public void setWaitTime(int waitTime) {
            this.waitTime = waitTime;
        }
    }
}

