/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.config;

import com.huaweicloud.common.event.EventManager;
import com.huaweicloud.common.transport.ServiceCombAkSkProperties;
import com.huaweicloud.common.transport.ServiceCombSSLProperties;
import com.huaweicloud.common.transport.TransportUtils;
import com.huaweicloud.common.util.URLUtil;
import com.huaweicloud.config.ServiceCombConfigProperties;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.servicecomb.config.center.client.AddressManager;
import org.apache.servicecomb.config.center.client.ConfigCenterClient;
import org.apache.servicecomb.config.center.client.ConfigCenterManager;
import org.apache.servicecomb.config.center.client.model.QueryConfigurationsRequest;
import org.apache.servicecomb.config.center.client.model.QueryConfigurationsResponse;
import org.apache.servicecomb.config.common.ConfigConverter;
import org.apache.servicecomb.config.kie.client.KieClient;
import org.apache.servicecomb.config.kie.client.KieConfigManager;
import org.apache.servicecomb.config.kie.client.KieConfigOperation;
import org.apache.servicecomb.config.kie.client.model.KieAddressManager;
import org.apache.servicecomb.config.kie.client.model.KieConfiguration;
import org.apache.servicecomb.foundation.auth.AuthHeaderProvider;
import org.apache.servicecomb.http.client.auth.RequestAuthHeaderProvider;
import org.apache.servicecomb.http.client.common.HttpConfiguration;
import org.apache.servicecomb.http.client.common.HttpTransport;
import org.apache.servicecomb.http.client.common.HttpTransportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigService.class);
    private boolean initialized = false;
    private ConfigConverter configConverter;
    private static final ConfigService INSTANCE = new ConfigService();

    private ConfigService() {
    }

    public static ConfigService getInstance() {
        return INSTANCE;
    }

    public ConfigConverter getConfigConverter() {
        return this.configConverter;
    }

    public void init(ServiceCombConfigProperties configProperties, ServiceCombAkSkProperties serviceCombAkSkProperties, ServiceCombSSLProperties serviceCombSSLProperties, List<AuthHeaderProvider> authHeaderProviders) {
        if (URLUtil.getEnvConfigUrl().isEmpty() && StringUtils.isEmpty((CharSequence)configProperties.getServerAddr())) {
            throw new IllegalArgumentException("Config server address is not configured. Please configure config server address or set spring.cloud.servicecomb.config.enabled to false");
        }
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.initConfigConverter(configProperties);
        if ("kie".equalsIgnoreCase(configProperties.getServerType())) {
            this.initKieConfig(configProperties, serviceCombAkSkProperties, serviceCombSSLProperties, authHeaderProviders);
        } else {
            this.initServiceCenterConfig(configProperties, serviceCombAkSkProperties, serviceCombSSLProperties, authHeaderProviders);
        }
    }

    private void initConfigConverter(ServiceCombConfigProperties configProperties) {
        if (StringUtils.isEmpty((CharSequence)configProperties.getFileSource())) {
            this.configConverter = new ConfigConverter(null);
        }
        this.configConverter = new ConfigConverter(Arrays.asList(configProperties.getFileSource().split(",")));
    }

    private AddressManager configCenterAddressManager(ServiceCombConfigProperties configProperties, ServiceCombAkSkProperties serviceCombAkSkProperties) {
        List addresses = URLUtil.getEnvConfigUrl();
        if (addresses.isEmpty()) {
            addresses = URLUtil.dealMultiUrl((String)configProperties.getServerAddr());
        }
        LOGGER.info("initialize config server type={}, address={}.", (Object)configProperties.getServerType(), (Object)addresses.toString());
        return new AddressManager(serviceCombAkSkProperties.getProject(), addresses);
    }

    private HttpTransport createHttpTransport(boolean sslEnabled, ServiceCombSSLProperties serviceCombSSLProperties, List<AuthHeaderProvider> authHeaderProviders, RequestConfig requestConfig) {
        return HttpTransportFactory.createHttpTransport((HttpConfiguration.SSLProperties)TransportUtils.createSSLProperties((boolean)sslEnabled, (ServiceCombSSLProperties)serviceCombSSLProperties), (RequestAuthHeaderProvider)ConfigService.getRequestAuthHeaderProvider(authHeaderProviders), (RequestConfig)requestConfig);
    }

    private static RequestAuthHeaderProvider getRequestAuthHeaderProvider(List<AuthHeaderProvider> authHeaderProviders) {
        return signRequest -> {
            HashMap headers = new HashMap();
            authHeaderProviders.forEach(provider -> headers.putAll(provider.authHeaders()));
            return headers;
        };
    }

    private QueryConfigurationsRequest createQueryConfigurationsRequest(ServiceCombConfigProperties configProperties) {
        QueryConfigurationsRequest request = new QueryConfigurationsRequest();
        request.setApplication(configProperties.getAppName());
        request.setServiceName(configProperties.getServiceName());
        request.setVersion(configProperties.getVersion());
        request.setEnvironment(configProperties.getEnv());
        request.setRevision(null);
        return request;
    }

    private void initServiceCenterConfig(ServiceCombConfigProperties configProperties, ServiceCombAkSkProperties serviceCombAkSkProperties, ServiceCombSSLProperties serviceCombSSLProperties, List<AuthHeaderProvider> authHeaderProviders) {
        QueryConfigurationsRequest queryConfigurationsRequest;
        HttpTransport httpTransport;
        AddressManager addressManager = this.configCenterAddressManager(configProperties, serviceCombAkSkProperties);
        ConfigCenterClient configCenterClient = new ConfigCenterClient(addressManager, httpTransport = this.createHttpTransport(addressManager.sslEnabled(), serviceCombSSLProperties, authHeaderProviders, HttpTransportFactory.defaultRequestConfig().build()));
        QueryConfigurationsResponse response = configCenterClient.queryConfigurations(queryConfigurationsRequest = this.createQueryConfigurationsRequest(configProperties));
        if (response.isChanged()) {
            this.configConverter.updateData(response.getConfigurations());
        }
        queryConfigurationsRequest.setRevision(response.getRevision());
        ConfigCenterManager configCenterManager = new ConfigCenterManager(configCenterClient, EventManager.getEventBus(), this.configConverter);
        configCenterManager.setQueryConfigurationsRequest(queryConfigurationsRequest);
        configCenterManager.startConfigCenterManager();
    }

    private KieAddressManager createKieAddressManager(List<String> addresses) {
        return new KieAddressManager(addresses);
    }

    private KieAddressManager configKieAddressManager(ServiceCombConfigProperties configProperties) {
        List addresses = URLUtil.getEnvConfigUrl();
        if (addresses.isEmpty()) {
            addresses = URLUtil.dealMultiUrl((String)configProperties.getServerAddr());
        }
        LOGGER.info("initialize config server type={}, address={}.", (Object)configProperties.getServerType(), (Object)addresses.toString());
        return this.createKieAddressManager(addresses);
    }

    private KieConfiguration createKieConfiguration(ServiceCombConfigProperties configProperties, ServiceCombAkSkProperties serviceCombAkSkProperties) {
        return new KieConfiguration().setAppName(configProperties.getAppName()).setFirstPullRequired(configProperties.isFirstPullRequired()).setCustomLabel(configProperties.getKie().getCustomLabel()).setCustomLabelValue(configProperties.getKie().getCustomLabelValue()).setEnableAppConfig(configProperties.getKie().isEnableAppConfig()).setEnableCustomConfig(configProperties.getKie().isEnableCustomConfig()).setEnableLongPolling(configProperties.getKie().isEnableLongPolling()).setEnableServiceConfig(configProperties.getKie().isEnableServiceConfig()).setEnvironment(configProperties.getEnv()).setPollingWaitInSeconds(configProperties.getKie().getPollingWaitTimeInSeconds()).setProject(serviceCombAkSkProperties.getProject()).setServiceName(configProperties.getServiceName());
    }

    private void initKieConfig(ServiceCombConfigProperties configProperties, ServiceCombAkSkProperties serviceCombAkSkProperties, ServiceCombSSLProperties serviceCombSSLProperties, List<AuthHeaderProvider> authHeaderProviders) {
        KieAddressManager kieAddressManager = this.configKieAddressManager(configProperties);
        RequestConfig.Builder requestBuilder = HttpTransportFactory.defaultRequestConfig();
        if (configProperties.getKie().isEnableLongPolling() && configProperties.getKie().getPollingWaitTimeInSeconds() >= 0) {
            requestBuilder.setConnectionRequestTimeout(configProperties.getKie().getPollingWaitTimeInSeconds() * 2 * 1000);
            requestBuilder.setSocketTimeout(configProperties.getKie().getPollingWaitTimeInSeconds() * 2 * 1000);
        }
        HttpTransport httpTransport = this.createHttpTransport(kieAddressManager.sslEnabled(), serviceCombSSLProperties, authHeaderProviders, requestBuilder.build());
        KieConfiguration kieConfiguration = this.createKieConfiguration(configProperties, serviceCombAkSkProperties);
        KieClient kieClient = new KieClient(kieAddressManager, httpTransport, kieConfiguration);
        KieConfigManager kieConfigManager = new KieConfigManager((KieConfigOperation)kieClient, EventManager.getEventBus(), kieConfiguration, this.configConverter);
        kieConfigManager.firstPull();
        kieConfigManager.startConfigKieManager();
    }
}

