/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.config;

import com.google.common.eventbus.Subscribe;
import com.huaweicloud.common.event.ConfigRefreshEvent;
import com.huaweicloud.common.event.EventManager;
import java.util.HashSet;
import org.apache.servicecomb.config.common.ConfigurationChangedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.endpoint.event.RefreshEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;

public class ConfigWatch
implements ApplicationEventPublisherAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigWatch.class);
    private ApplicationEventPublisher applicationEventPublisher;

    public ConfigWatch() {
        EventManager.register((Object)this);
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @Subscribe
    public void onConfigurationChangedEvent(ConfigurationChangedEvent event) {
        LOGGER.info("receive new configurations, added=[{}], updated=[{}], deleted=[{}]", new Object[]{event.getAdded().keySet(), event.getUpdated().keySet(), event.getDeleted().keySet()});
        HashSet updatedKey = new HashSet();
        updatedKey.addAll(event.getAdded().keySet());
        updatedKey.addAll(event.getUpdated().keySet());
        updatedKey.addAll(event.getDeleted().keySet());
        ConfigRefreshEvent configRefreshEvent = new ConfigRefreshEvent((Object)this, updatedKey);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)configRefreshEvent);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new RefreshEvent((Object)this, (Object)configRefreshEvent, "Config refreshed"));
    }
}

