/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.servicecomb.discovery.discovery;

import com.google.common.eventbus.Subscribe;
import com.huaweicloud.common.event.EventManager;
import com.huaweicloud.common.transport.DiscoveryBootstrapProperties;
import com.huaweicloud.servicecomb.discovery.client.model.ServiceCombServiceInstance;
import com.huaweicloud.servicecomb.discovery.registry.ServiceCombRegistration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.servicecomb.service.center.client.DiscoveryEvents;
import org.apache.servicecomb.service.center.client.RegistrationEvents;
import org.apache.servicecomb.service.center.client.ServiceCenterClient;
import org.apache.servicecomb.service.center.client.ServiceCenterDiscovery;
import org.apache.servicecomb.service.center.client.model.Microservice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.event.HeartbeatEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;

public class ServiceCombDiscoveryClient
implements DiscoveryClient,
ApplicationEventPublisherAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceCombDiscoveryClient.class);
    private ServiceCenterClient serviceCenterClient;
    private DiscoveryBootstrapProperties discoveryProperties;
    private ServiceCenterDiscovery serviceCenterDiscovery;
    private ServiceCombRegistration serviceCombRegistration;
    private ApplicationEventPublisher applicationEventPublisher;
    private final AtomicLong changeId = new AtomicLong(0L);
    private Set<String> serviceIds = new HashSet<String>();

    public ServiceCombDiscoveryClient(DiscoveryBootstrapProperties discoveryProperties, ServiceCenterClient serviceCenterClient, ServiceCombRegistration serviceCombRegistration) {
        this.discoveryProperties = discoveryProperties;
        this.serviceCenterClient = serviceCenterClient;
        this.serviceCombRegistration = serviceCombRegistration;
        this.serviceCenterDiscovery = new ServiceCenterDiscovery(serviceCenterClient, EventManager.getEventBus());
        this.serviceCenterDiscovery.setPollInterval((long)discoveryProperties.getPollInterval());
        EventManager.getEventBus().register((Object)this);
    }

    @Subscribe
    public void onHeartBeatEvent(RegistrationEvents.HeartBeatEvent event) {
        if (event.isSuccess()) {
            this.serviceCenterDiscovery.updateMyselfServiceId(this.serviceCombRegistration.getMicroservice().getServiceId());
            this.serviceCenterDiscovery.startDiscovery();
        }
    }

    @Subscribe
    public void onInstanceChangedEvent(DiscoveryEvents.InstanceChangedEvent event) {
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new HeartbeatEvent((Object)this, (Object)this.changeId.getAndIncrement()));
    }

    public String description() {
        return "SerivceComb Discovery";
    }

    private ServiceCenterDiscovery.SubscriptionKey parseMicroserviceName(String serviceId) {
        int idxAt = serviceId.indexOf(".");
        if (idxAt == -1) {
            return new ServiceCenterDiscovery.SubscriptionKey(this.discoveryProperties.getAppName(), serviceId);
        }
        return new ServiceCenterDiscovery.SubscriptionKey(serviceId.substring(0, idxAt), serviceId.substring(idxAt + 1));
    }

    public List<ServiceInstance> getInstances(String serviceId) {
        List instances;
        ServiceCenterDiscovery.SubscriptionKey subscriptionKey = this.parseMicroserviceName(serviceId);
        if (!this.serviceCenterDiscovery.isRegistered(subscriptionKey)) {
            this.serviceCenterDiscovery.register(subscriptionKey);
        }
        if ((instances = this.serviceCenterDiscovery.getInstanceCache(subscriptionKey)) == null) {
            return Collections.emptyList();
        }
        this.serviceIds.add(serviceId);
        return instances.stream().map(ServiceCombServiceInstance::new).collect(Collectors.toList());
    }

    public List<String> getServices() {
        return new ArrayList<String>(this.serviceIds);
    }

    private String getAllowedMicroservice(Microservice microservice) {
        if (Boolean.parseBoolean((String)microservice.getProperties().get("allowCrossApp"))) {
            return microservice.getAppId() + "." + microservice.getServiceName();
        }
        if (microservice.getAppId().equals(this.discoveryProperties.getAppName())) {
            return microservice.getServiceName();
        }
        return null;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }
}

