/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.servicecomb.discovery.discovery;

import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

public class ServiceCombReactiveDiscoveryClient
implements ReactiveDiscoveryClient {
    private DiscoveryClient discoveryClient;

    public ServiceCombReactiveDiscoveryClient(DiscoveryClient discoveryClient) {
        this.discoveryClient = discoveryClient;
    }

    public String description() {
        return "SerivceComb Reactive Discovery";
    }

    public Flux<ServiceInstance> getInstances(String serviceId) {
        return Flux.defer(() -> Flux.fromIterable((Iterable)this.discoveryClient.getInstances(serviceId))).subscribeOn(Schedulers.boundedElastic());
    }

    public Flux<String> getServices() {
        return Flux.defer(() -> Flux.fromIterable((Iterable)this.discoveryClient.getServices())).subscribeOn(Schedulers.boundedElastic());
    }
}

