/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.servicecomb.discovery.registry;

import com.google.common.eventbus.Subscribe;
import com.huaweicloud.common.event.EventManager;
import com.huaweicloud.common.schema.ServiceCombSwaggerHandler;
import com.huaweicloud.common.transport.DiscoveryBootstrapProperties;
import com.huaweicloud.servicecomb.discovery.registry.ServiceCombRegistration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.service.center.client.RegistrationEvents;
import org.apache.servicecomb.service.center.client.ServiceCenterClient;
import org.apache.servicecomb.service.center.client.ServiceCenterRegistration;
import org.apache.servicecomb.service.center.client.ServiceCenterWatch;
import org.apache.servicecomb.service.center.client.exception.OperationException;
import org.apache.servicecomb.service.center.client.model.MicroserviceInstance;
import org.apache.servicecomb.service.center.client.model.MicroserviceInstanceStatus;
import org.apache.servicecomb.service.center.client.model.SchemaInfo;
import org.apache.servicecomb.service.center.client.model.ServiceCenterConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ServiceCombServiceRegistry
implements ServiceRegistry<ServiceCombRegistration>,
ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceCombServiceRegistry.class);
    private static final String SWAGGER_BEAN_NAME = "serviceCombSwaggerHandler";
    private final DiscoveryBootstrapProperties discoveryBootstrapProperties;
    private final ServiceCenterClient serviceCenterClient;
    private ServiceCenterRegistration serviceCenterRegistration;
    private final ServiceCenterWatch watch;
    private ServiceCombRegistration serviceCombRegistration;
    private final ServiceCenterConfiguration serviceCenterConfiguration;
    private ApplicationContext applicationContext;

    public ServiceCombServiceRegistry(DiscoveryBootstrapProperties discoveryBootstrapProperties, ServiceCenterClient serviceCenterClient, @Autowired(required=false) ServiceCenterWatch watch) {
        this.serviceCenterClient = serviceCenterClient;
        this.watch = watch;
        this.discoveryBootstrapProperties = discoveryBootstrapProperties;
        this.serviceCenterConfiguration = new ServiceCenterConfiguration().setIgnoreSwaggerDifferent(Boolean.valueOf(discoveryBootstrapProperties.isIgnoreSwaggerDifferent()));
    }

    @Subscribe
    public void onMicroserviceInstanceRegistrationEvent(RegistrationEvents.MicroserviceInstanceRegistrationEvent event) {
        if (event.isSuccess() && this.discoveryBootstrapProperties.isWatch()) {
            this.watch.startWatch("default", this.serviceCombRegistration.getMicroservice().getServiceId());
        }
    }

    public void register(ServiceCombRegistration registration) {
        this.serviceCombRegistration = registration;
        this.serviceCenterRegistration = new ServiceCenterRegistration(this.serviceCenterClient, this.serviceCenterConfiguration, EventManager.getEventBus());
        EventManager.getEventBus().register((Object)this);
        this.serviceCenterRegistration.setMicroservice(registration.getMicroservice());
        this.serviceCenterRegistration.setMicroserviceInstance(registration.getMicroserviceInstance());
        this.serviceCenterRegistration.setHeartBeatInterval((long)this.discoveryBootstrapProperties.getHealthCheckInterval());
        this.serviceCenterRegistration.setHeartBeatRequestTimeout((long)this.discoveryBootstrapProperties.getHealthCheckRequestTimeout());
        this.addSchemaInfo(registration);
        this.serviceCenterRegistration.startRegistration();
    }

    private void addSchemaInfo(ServiceCombRegistration registration) {
        if (this.applicationContext.containsBean(SWAGGER_BEAN_NAME)) {
            ServiceCombSwaggerHandler serviceCombSwaggerHandler = (ServiceCombSwaggerHandler)this.applicationContext.getBean(SWAGGER_BEAN_NAME, ServiceCombSwaggerHandler.class);
            serviceCombSwaggerHandler.init(registration.getMicroservice().getAppId(), registration.getMicroservice().getServiceName());
            registration.getMicroservice().setSchemas(serviceCombSwaggerHandler.getSchemaIds());
            Map contents = serviceCombSwaggerHandler.getSchemasMap();
            Map summary = serviceCombSwaggerHandler.getSchemasSummaryMap();
            List schemaInfos = serviceCombSwaggerHandler.getSchemaIds().stream().map(id -> new SchemaInfo(id, (String)contents.get(id), (String)summary.get(id))).collect(Collectors.toList());
            this.serviceCenterRegistration.setSchemaInfos(schemaInfos);
        }
    }

    public void deregister(ServiceCombRegistration registration) {
        if (this.serviceCenterRegistration != null) {
            this.serviceCenterRegistration.stop();
            if (!StringUtils.isEmpty((CharSequence)registration.getMicroserviceInstance().getInstanceId())) {
                try {
                    this.serviceCenterClient.deleteMicroserviceInstance(registration.getMicroserviceInstance().getServiceId(), registration.getMicroserviceInstance().getInstanceId());
                }
                catch (Exception e) {
                    LOGGER.error("delete microservice failed. ", (Throwable)e);
                }
            }
        }
        if (this.watch != null) {
            this.watch.stop();
        }
    }

    public void close() {
        LOGGER.info("service registry closed.");
    }

    public void setStatus(ServiceCombRegistration registration, String status) {
        try {
            this.serviceCenterClient.updateMicroserviceInstanceStatus(registration.getMicroserviceInstance().getServiceId(), registration.getMicroserviceInstance().getInstanceId(), MicroserviceInstanceStatus.valueOf((String)status));
        }
        catch (OperationException e) {
            LOGGER.error("setStatus failed", (Throwable)e);
        }
    }

    public <T> T getStatus(ServiceCombRegistration registration) {
        try {
            MicroserviceInstance instance = this.serviceCenterClient.getMicroserviceInstance(registration.getMicroserviceInstance().getServiceId(), registration.getMicroserviceInstance().getInstanceId());
            return (T)(instance.getStatus() != null ? instance.getStatus().name() : null);
        }
        catch (OperationException e) {
            LOGGER.error("getStatus failed", (Throwable)e);
            return null;
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

