/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.servicecomb.discovery.client.model;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;
import org.apache.servicecomb.service.center.client.model.MicroserviceInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;

public class ServiceCombServiceInstance
implements ServiceInstance {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceCombServiceInstance.class);
    private final MicroserviceInstance microserviceInstance;

    public ServiceCombServiceInstance(MicroserviceInstance microserviceInstance) {
        this.microserviceInstance = microserviceInstance;
    }

    public MicroserviceInstance getMicroserviceInstance() {
        return this.microserviceInstance;
    }

    public String getInstanceId() {
        return this.microserviceInstance.getInstanceId();
    }

    public String getServiceId() {
        return this.microserviceInstance.getServiceName();
    }

    public String getHost() {
        URI uri = this.parseEndpoint();
        if (uri == null) {
            return this.microserviceInstance.getInstanceId();
        }
        return uri.getHost();
    }

    private URI parseEndpoint() {
        String endpoint = this.microserviceInstance.getEndpoints().stream().filter(e -> e.startsWith("rest://")).findFirst().orElse(null);
        if (endpoint == null) {
            return null;
        }
        URI uri = null;
        try {
            uri = new URIBuilder(endpoint).build();
        }
        catch (URISyntaxException e2) {
            LOGGER.error("invalid instance endpoint [{}]", (Object)endpoint);
        }
        return uri;
    }

    public int getPort() {
        URI uri = this.parseEndpoint();
        if (uri == null) {
            return 0;
        }
        return uri.getPort();
    }

    public boolean isSecure() {
        return false;
    }

    public URI getUri() {
        return this.parseEndpoint();
    }

    public Map<String, String> getMetadata() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.putAll(this.microserviceInstance.getProperties());
        if (this.microserviceInstance.getStatus() != null) {
            map.put("status", this.microserviceInstance.getStatus().name());
        }
        if (this.microserviceInstance.getDataCenterInfo() != null) {
            map.put("zone", this.microserviceInstance.getDataCenterInfo().getAvailableZone());
        }
        return map;
    }

    public String getScheme() {
        return null;
    }
}

