/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.dtm.consumer.rest;

import com.huaweicloud.dtm.consumer.rest.DtmRestTemplateInterceptor;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;

@Configuration
public class DtmRestTemplateAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(DtmRestTemplateAutoConfiguration.class);
    @Autowired(required=false)
    private Collection<RestTemplate> restTemplates;
    @Autowired
    private DtmRestTemplateInterceptor dtmRestTemplateInterceptor;

    @Bean
    public DtmRestTemplateInterceptor restTemplateForDtmInterceptor() {
        return new DtmRestTemplateInterceptor();
    }

    @PostConstruct
    public void init() {
        LOGGER.debug("init restTemplate for dtm..");
        if (this.restTemplates != null) {
            for (RestTemplate restTemplate : this.restTemplates) {
                ArrayList<DtmRestTemplateInterceptor> interceptors = new ArrayList<DtmRestTemplateInterceptor>(restTemplate.getInterceptors());
                interceptors.add(this.dtmRestTemplateInterceptor);
                restTemplate.setInterceptors(interceptors);
            }
        }
    }
}

