/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.dtm.consumer.rest;

import com.huaweicloud.dtm.DtmConstants;
import java.io.IOException;
import java.util.Map;
import org.apache.servicecomb.foundation.common.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class DtmRestTemplateInterceptor
implements ClientHttpRequestInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DtmRestTemplateInterceptor.class);

    public ClientHttpResponse intercept(HttpRequest httpRequest, byte[] bytes, ClientHttpRequestExecution clientHttpRequestExecution) throws IOException {
        this.exportDtmContextToHeader(httpRequest);
        return clientHttpRequestExecution.execute(httpRequest, bytes);
    }

    private void exportDtmContextToHeader(HttpRequest httpRequest) {
        if (DtmConstants.DTM_CONTEXT_EX_METHOD == null) {
            return;
        }
        try {
            Object context = DtmConstants.DTM_CONTEXT_EX_METHOD.invoke(null, new Object[0]);
            if (context instanceof Map) {
                httpRequest.getHeaders().add("DTM_CONTEXT", JsonUtils.OBJ_MAPPER.writeValueAsString(context));
            }
        }
        catch (Throwable e) {
            LOGGER.warn("Failed to export dtm context", e);
        }
    }
}

