/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.dtm.provider;

import com.fasterxml.jackson.core.type.TypeReference;
import com.huaweicloud.dtm.DtmConstants;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.servicecomb.foundation.common.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;

public class DtmHandlerInterceptor
implements HandlerInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DtmHandlerInterceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (DtmConstants.DTM_CONTEXT_IM_METHOD == null) {
            return true;
        }
        try {
            String dtmHeader = request.getHeader("DTM_CONTEXT");
            if (StringUtils.isNotEmpty((String)dtmHeader)) {
                Map context = (Map)JsonUtils.OBJ_MAPPER.readValue(dtmHeader, (TypeReference)new TypeReference<Map<String, String>>(){});
                DtmConstants.DTM_CONTEXT_IM_METHOD.invoke(null, context);
            }
        }
        catch (Throwable e) {
            LOGGER.warn("Failed to import dtm context", e);
        }
        return true;
    }
}

