/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.router.client.loabalancer;

import com.huaweicloud.router.client.loabalancer.RouterLoadBalancerRequest;
import com.huaweicloud.router.client.loabalancer.ServiceInstanceFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.foundation.common.utils.JsonUtils;
import org.apache.servicecomb.router.RouterFilter;
import org.apache.servicecomb.router.distribute.AbstractRouterDistributor;
import org.apache.servicecomb.service.center.client.model.MicroserviceInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.DefaultRequestContext;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.RequestData;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.http.HttpHeaders;

public class CanaryServiceInstanceFilter
implements ServiceInstanceFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CanaryServiceInstanceFilter.class);
    @Autowired
    private AbstractRouterDistributor<ServiceInstance, MicroserviceInstance> routerDistributor;
    @Autowired
    private RouterFilter routerFilter;

    @Override
    public List<ServiceInstance> filter(ServiceInstanceListSupplier supplier, List<ServiceInstance> instances, Request<?> request) {
        String targetServiceName = supplier.getServiceId();
        DefaultRequestContext context = (DefaultRequestContext)request.getContext();
        Object clientRequest = context.getClientRequest();
        HttpHeaders httpHeaders = clientRequest instanceof RouterLoadBalancerRequest ? ((RouterLoadBalancerRequest)clientRequest).getRequest().getHeaders() : ((RequestData)clientRequest).getHeaders();
        HashMap canaryHeaders = new HashMap();
        try {
            if (httpHeaders.getFirst("X-RouterContext") != null) {
                canaryHeaders.putAll((Map)JsonUtils.readValue((byte[])httpHeaders.getFirst("X-RouterContext").getBytes(), Map.class));
            }
            canaryHeaders.putAll(httpHeaders.toSingleValueMap());
        }
        catch (IOException e) {
            LOGGER.warn("decode headers failed for {}", (Object)e.getMessage());
        }
        return this.routerFilter.getFilteredListOfServers(instances, targetServiceName, canaryHeaders, this.routerDistributor);
    }

    public int getOrder() {
        return -1;
    }
}

