/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.router.client.loabalancer;

import com.huaweicloud.router.client.loabalancer.CanaryServiceInstanceFilter;
import com.huaweicloud.router.client.loabalancer.RouterServiceInstanceListSupplier;
import com.huaweicloud.router.client.loabalancer.ZoneAwareServiceInstanceFilter;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.ConditionalOnBlockingDiscoveryEnabled;
import org.springframework.cloud.client.ConditionalOnDiscoveryEnabled;
import org.springframework.cloud.client.ConditionalOnReactiveDiscoveryEnabled;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.loadbalancer.annotation.LoadBalancerClientConfiguration;
import org.springframework.cloud.loadbalancer.core.ReactorLoadBalancer;
import org.springframework.cloud.loadbalancer.core.RetryAwareServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.RoundRobinLoadBalancer;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.Primary;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.util.retry.RetrySpec;

@Configuration(proxyBeanMethods=false)
@ConditionalOnDiscoveryEnabled
public class RouterLoadBalancerClientConfiguration {
    private static final int REACTIVE_SERVICE_INSTANCE_SUPPLIER_ORDER = 193827465;

    @Bean
    @ConditionalOnMissingBean(value={CanaryServiceInstanceFilter.class})
    public CanaryServiceInstanceFilter canaryServiceInstanceFilter() {
        return new CanaryServiceInstanceFilter();
    }

    @Bean
    @ConditionalOnMissingBean(value={ZoneAwareServiceInstanceFilter.class})
    @ConditionalOnProperty(value={"spring.cloud.servicecomb.discovery.enabledZoneAware"}, havingValue="true")
    public ZoneAwareServiceInstanceFilter zoneAwareServiceInstanceFilter() {
        return new ZoneAwareServiceInstanceFilter();
    }

    @Bean
    @ConditionalOnMissingBean
    public ReactorLoadBalancer<ServiceInstance> reactorServiceInstanceLoadBalancer(Environment environment, LoadBalancerClientFactory loadBalancerClientFactory) {
        String name = environment.getProperty("loadbalancer.client.name");
        return new RoundRobinLoadBalancer(loadBalancerClientFactory.getLazyProvider(name, ServiceInstanceListSupplier.class), name);
    }

    static final class ReactiveOnAvoidPreviousInstanceAndRetryEnabledCondition
    extends AllNestedConditions {
        private ReactiveOnAvoidPreviousInstanceAndRetryEnabledCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(value={"spring.cloud.loadbalancer.retry.avoid-previous-instance"}, havingValue="true", matchIfMissing=true)
        static class AvoidPreviousInstanceEnabled {
            AvoidPreviousInstanceEnabled() {
            }
        }

        @ConditionalOnProperty(value={"spring.cloud.loadbalancer.retry.enabled"}, havingValue="true")
        static class LoadBalancerRetryEnabled {
            LoadBalancerRetryEnabled() {
            }
        }
    }

    static final class BlockingOnAvoidPreviousInstanceAndRetryEnabledCondition
    extends AllNestedConditions {
        private BlockingOnAvoidPreviousInstanceAndRetryEnabledCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(value={"spring.cloud.loadbalancer.retry.avoid-previous-instance"}, havingValue="true", matchIfMissing=true)
        static class AvoidPreviousInstanceEnabled {
            AvoidPreviousInstanceEnabled() {
            }
        }

        @ConditionalOnProperty(value={"spring.cloud.loadbalancer.retry.enabled"}, havingValue="true", matchIfMissing=true)
        static class LoadBalancerRetryEnabled {
            LoadBalancerRetryEnabled() {
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBlockingDiscoveryEnabled
    @Conditional(value={ReactiveOnAvoidPreviousInstanceAndRetryEnabledCondition.class})
    @AutoConfigureAfter(value={LoadBalancerClientConfiguration.ReactiveSupportConfiguration.class})
    @ConditionalOnBean(value={ServiceInstanceListSupplier.class})
    @ConditionalOnClass(value={RetrySpec.class})
    public static class ReactiveRetryConfiguration {
        @Bean
        @ConditionalOnBean(value={DiscoveryClient.class})
        @Primary
        public ServiceInstanceListSupplier retryAwareDiscoveryClientServiceInstanceListSupplier(ServiceInstanceListSupplier delegate) {
            return new RetryAwareServiceInstanceListSupplier(delegate);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBlockingDiscoveryEnabled
    @ConditionalOnClass(value={RetryTemplate.class})
    @Conditional(value={BlockingOnAvoidPreviousInstanceAndRetryEnabledCondition.class})
    @AutoConfigureAfter(value={LoadBalancerClientConfiguration.BlockingSupportConfiguration.class})
    @ConditionalOnBean(value={ServiceInstanceListSupplier.class})
    public static class BlockingRetryConfiguration {
        @Bean
        @ConditionalOnBean(value={DiscoveryClient.class})
        @Primary
        public ServiceInstanceListSupplier retryAwareDiscoveryClientServiceInstanceListSupplier(ServiceInstanceListSupplier delegate) {
            return new RetryAwareServiceInstanceListSupplier(delegate);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBlockingDiscoveryEnabled
    @Order(value=193827466)
    public static class BlockingSupportConfiguration {
        @Bean
        @ConditionalOnBean(value={DiscoveryClient.class})
        @ConditionalOnMissingBean
        @ConditionalOnProperty(value={"spring.cloud.loadbalancer.configurations"}, havingValue="default", matchIfMissing=true)
        public ServiceInstanceListSupplier discoveryClientServiceInstanceListSupplier(ConfigurableApplicationContext context) {
            return new RouterServiceInstanceListSupplier(ServiceInstanceListSupplier.builder().withBlockingDiscoveryClient().withCaching().build(context));
        }

        @Bean
        @ConditionalOnBean(value={DiscoveryClient.class})
        @ConditionalOnMissingBean
        @ConditionalOnProperty(value={"spring.cloud.loadbalancer.configurations"}, havingValue="zone-preference")
        public ServiceInstanceListSupplier zonePreferenceDiscoveryClientServiceInstanceListSupplier(ConfigurableApplicationContext context) {
            return new RouterServiceInstanceListSupplier(ServiceInstanceListSupplier.builder().withBlockingDiscoveryClient().withZonePreference().withCaching().build(context));
        }

        @Bean
        @ConditionalOnBean(value={DiscoveryClient.class, RestTemplate.class})
        @ConditionalOnMissingBean
        @ConditionalOnProperty(value={"spring.cloud.loadbalancer.configurations"}, havingValue="health-check")
        public ServiceInstanceListSupplier healthCheckDiscoveryClientServiceInstanceListSupplier(ConfigurableApplicationContext context) {
            return new RouterServiceInstanceListSupplier(ServiceInstanceListSupplier.builder().withBlockingDiscoveryClient().withBlockingHealthChecks().build(context));
        }

        @Bean
        @ConditionalOnBean(value={DiscoveryClient.class})
        @ConditionalOnMissingBean
        @ConditionalOnProperty(value={"spring.cloud.loadbalancer.configurations"}, havingValue="request-based-sticky-session")
        public ServiceInstanceListSupplier requestBasedStickySessionDiscoveryClientServiceInstanceListSupplier(ConfigurableApplicationContext context) {
            return new RouterServiceInstanceListSupplier(ServiceInstanceListSupplier.builder().withBlockingDiscoveryClient().withRequestBasedStickySession().build(context));
        }

        @Bean
        @ConditionalOnBean(value={DiscoveryClient.class})
        @ConditionalOnMissingBean
        @ConditionalOnProperty(value={"spring.cloud.loadbalancer.configurations"}, havingValue="same-instance-preference")
        public ServiceInstanceListSupplier sameInstancePreferenceServiceInstanceListSupplier(ConfigurableApplicationContext context) {
            return new RouterServiceInstanceListSupplier(ServiceInstanceListSupplier.builder().withBlockingDiscoveryClient().withSameInstancePreference().build(context));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnReactiveDiscoveryEnabled
    @Order(value=193827465)
    public static class ReactiveSupportConfiguration {
        @Bean
        @ConditionalOnBean(value={ReactiveDiscoveryClient.class})
        @ConditionalOnMissingBean
        @ConditionalOnProperty(value={"spring.cloud.loadbalancer.configurations"}, havingValue="default", matchIfMissing=true)
        public ServiceInstanceListSupplier discoveryClientServiceInstanceListSupplier(ConfigurableApplicationContext context) {
            return new RouterServiceInstanceListSupplier(ServiceInstanceListSupplier.builder().withDiscoveryClient().withCaching().build(context));
        }

        @Bean
        @ConditionalOnBean(value={ReactiveDiscoveryClient.class})
        @ConditionalOnMissingBean
        @ConditionalOnProperty(value={"spring.cloud.loadbalancer.configurations"}, havingValue="zone-preference")
        public ServiceInstanceListSupplier zonePreferenceDiscoveryClientServiceInstanceListSupplier(ConfigurableApplicationContext context) {
            return new RouterServiceInstanceListSupplier(ServiceInstanceListSupplier.builder().withDiscoveryClient().withZonePreference().withCaching().build(context));
        }

        @Bean
        @ConditionalOnBean(value={ReactiveDiscoveryClient.class, WebClient.Builder.class})
        @ConditionalOnMissingBean
        @ConditionalOnProperty(value={"spring.cloud.loadbalancer.configurations"}, havingValue="health-check")
        public ServiceInstanceListSupplier healthCheckDiscoveryClientServiceInstanceListSupplier(ConfigurableApplicationContext context) {
            return new RouterServiceInstanceListSupplier(ServiceInstanceListSupplier.builder().withDiscoveryClient().withHealthChecks().build(context));
        }

        @Bean
        @ConditionalOnBean(value={ReactiveDiscoveryClient.class})
        @ConditionalOnMissingBean
        @ConditionalOnProperty(value={"spring.cloud.loadbalancer.configurations"}, havingValue="request-based-sticky-session")
        public ServiceInstanceListSupplier requestBasedStickySessionDiscoveryClientServiceInstanceListSupplier(ConfigurableApplicationContext context) {
            return new RouterServiceInstanceListSupplier(ServiceInstanceListSupplier.builder().withDiscoveryClient().withRequestBasedStickySession().build(context));
        }

        @Bean
        @ConditionalOnBean(value={ReactiveDiscoveryClient.class})
        @ConditionalOnMissingBean
        @ConditionalOnProperty(value={"spring.cloud.loadbalancer.configurations"}, havingValue="same-instance-preference")
        public ServiceInstanceListSupplier sameInstancePreferenceServiceInstanceListSupplier(ConfigurableApplicationContext context) {
            return new RouterServiceInstanceListSupplier(ServiceInstanceListSupplier.builder().withDiscoveryClient().withSameInstancePreference().build(context));
        }
    }
}

