/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.router.client.track;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.huaweicloud.common.util.HeaderUtil;
import com.huaweicloud.router.client.track.RouterHeaderFilterExt;
import com.huaweicloud.router.client.track.RouterTrackContext;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.servicecomb.foundation.common.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.HandlerInterceptor;

public class RouterHandlerInterceptor
implements HandlerInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RouterHandlerInterceptor.class);
    @Autowired(required=false)
    private List<RouterHeaderFilterExt> filters;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        if (request.getHeader("X-RouterContext") != null) {
            RouterTrackContext.setRequestHeader(request.getHeader("X-RouterContext"));
            return true;
        }
        Map<String, String> headers = HeaderUtil.getHeaders((HttpServletRequest)request);
        if (!CollectionUtils.isEmpty(this.filters)) {
            for (RouterHeaderFilterExt filterExt : this.filters) {
                if (!filterExt.enabled()) continue;
                headers = filterExt.doFilter(headers);
            }
        }
        try {
            RouterTrackContext.setRequestHeader(JsonUtils.writeValueAsString((Object)headers));
        }
        catch (JsonProcessingException e) {
            LOGGER.warn("encode headers failed for {}", (Object)e.getMessage());
        }
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, @Nullable Exception ex) {
        RouterTrackContext.remove();
    }
}

