/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.swagger;

import com.google.common.collect.Ordering;
import com.huaweicloud.swagger.DefinitionCache;
import com.huaweicloud.swagger.DocumentationSwaggerMapper;
import io.swagger.models.AbstractModel;
import io.swagger.models.Info;
import io.swagger.models.Swagger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import org.springframework.http.HttpMethod;
import springfox.documentation.builders.ApiDescriptionBuilder;
import springfox.documentation.builders.ApiListingBuilder;
import springfox.documentation.schema.ScalarModelSpecification;
import springfox.documentation.service.ApiListing;
import springfox.documentation.service.ContentSpecification;
import springfox.documentation.service.Documentation;
import springfox.documentation.service.Operation;
import springfox.documentation.service.Representation;
import springfox.documentation.service.RequestParameter;
import springfox.documentation.service.StringVendorExtension;
import springfox.documentation.spi.service.contexts.Orderings;
import springfox.documentation.swagger2.mappers.ServiceModelToSwagger2Mapper;

public class ServiceCombDocumentationSwaggerMapper
implements DocumentationSwaggerMapper {
    private static final String TITLE_PREFIX = "swagger definition for ";
    private static final String X_JAVA_INTERFACE_PREFIX = "cse.gen.";
    private static final String X_JAVA_INTERFACE = "x-java-interface";
    private static final String X_JAVA_CLASS = "x-java-class";
    private static final String X_RAW_JSON_TYPE = "x-raw-json";
    private static final String INTF_SUFFIX = "Intf";
    private final ServiceModelToSwagger2Mapper mapper;
    private final String appName;
    private final String serviceName;

    public ServiceCombDocumentationSwaggerMapper(String appName, String serviceName, ServiceModelToSwagger2Mapper mapper) {
        this.appName = appName;
        this.serviceName = serviceName;
        this.mapper = mapper;
    }

    @Override
    public Map<String, Swagger> documentationToSwaggers(Documentation documentation) {
        HashMap<String, Swagger> result = new HashMap<String, Swagger>();
        documentation.getApiListings().entrySet().forEach(entry -> {
            Swagger swagger = this.mapper.mapDocumentation(new Documentation(documentation.getGroupName(), documentation.getBasePath(), Collections.emptySet(), this.filteringApiListings((Map.Entry<String, List<ApiListing>>)entry), documentation.getResourceListing(), this.toSet(documentation.getProduces()), this.toSet(documentation.getConsumes()), documentation.getHost(), this.toSet(documentation.getSchemes()), (Collection)documentation.getServers(), documentation.getExternalDocumentation(), (Collection)documentation.getVendorExtensions()));
            this.changeSwaggerInfo((String)entry.getKey(), swagger);
            this.addXJavaClass(swagger);
            result.put(this.mapSchemaId((String)entry.getKey()), swagger);
        });
        return result;
    }

    private void changeSwaggerInfo(String originalSchemaId, Swagger swagger) {
        String fullClassName = DefinitionCache.getFullClassNameBySchema(originalSchemaId);
        String xInterfaceName = this.genXInterfaceName(this.appName, this.serviceName, this.mapSchemaId(originalSchemaId));
        Info info = swagger.getInfo();
        info.setTitle(TITLE_PREFIX + fullClassName);
        info.setVendorExtension(X_JAVA_INTERFACE, (Object)xInterfaceName);
    }

    private void addXJavaClass(Swagger swagger) {
        swagger.getDefinitions().forEach((k, v) -> {
            if (v instanceof AbstractModel) {
                ((AbstractModel)v).setVendorExtension(X_JAVA_CLASS, (Object)DefinitionCache.getClassByDefName(k));
            }
        });
    }

    private Set<String> toSet(List<String> lists) {
        return new HashSet<String>(lists);
    }

    private Map<String, List<ApiListing>> filteringApiListings(Map.Entry<String, List<ApiListing>> entry) {
        HashMap<String, List<ApiListing>> map = new HashMap<String, List<ApiListing>>();
        List<ApiListing> apiListings = entry.getValue();
        ArrayList<ApiListing> filteredApiListing = new ArrayList<ApiListing>();
        for (ApiListing apiListing : apiListings) {
            ApiListingBuilder apiListingBuilder = new ApiListingBuilder((Comparator)Ordering.from((Comparator)Orderings.apiPathCompatator()));
            apiListingBuilder.apiVersion(apiListing.getApiVersion()).basePath(apiListing.getBasePath()).resourcePath(apiListing.getResourcePath()).produces(this.validateContentType(apiListing.getProduces(), "application/json")).consumes(this.validateContentType(apiListing.getConsumes(), "application/json")).host(apiListing.getHost()).protocols(apiListing.getProtocols()).securityReferences(apiListing.getSecurityReferences()).models(apiListing.getModels()).description(apiListing.getDescription()).position(apiListing.getPosition()).tags(apiListing.getTags()).modelSpecifications(apiListing.getModelSpecifications()).modelNamesRegistry(apiListing.getModelNamesRegistry());
            List apiDescriptions = apiListing.getApis();
            ArrayList newApiDescriptions = new ArrayList(apiDescriptions.size());
            apiDescriptions.forEach(apiDescription -> newApiDescriptions.add(new ApiDescriptionBuilder((Comparator)Ordering.from((Comparator)Orderings.positionComparator())).path(this.validatePath(apiDescription.getPath())).description(apiDescription.getDescription()).operations(Collections.singletonList(this.validateOperation((Operation)apiDescription.getOperations().get(0)))).hidden(apiDescription.isHidden().booleanValue()).build()));
            apiListingBuilder.apis(newApiDescriptions);
            filteredApiListing.add(apiListingBuilder.build());
        }
        map.put(entry.getKey(), filteredApiListing);
        return map;
    }

    private String validatePath(String path) {
        if (path.endsWith("/**")) {
            return path.substring(0, path.length() - "/**".length()) + "/(.*)";
        }
        return path;
    }

    private Operation validateOperation(Operation operation) {
        return new Operation(operation.getMethod(), operation.getSummary(), operation.getNotes(), operation.getExternalDocumentation(), operation.getResponseModel(), this.validateOperationId(operation.getMethod(), operation.getUniqueId()), operation.getPosition(), operation.getTags(), this.validateResponseContentType(operation), this.validateContentType(operation.getConsumes(), "application/json"), operation.getProtocol(), Collections.EMPTY_LIST, operation.getParameters(), operation.getResponseMessages(), operation.getDeprecated(), operation.isHidden(), (Collection)operation.getVendorExtensions(), this.validateRequestParameter(operation.getRequestParameters()), operation.getBody(), (Set)operation.getResponses());
    }

    private String validateOperationId(HttpMethod method, String uniqueId) {
        String suffix = String.format("Using%s", method);
        if (uniqueId.endsWith(suffix)) {
            return uniqueId.substring(0, uniqueId.length() - suffix.length());
        }
        return uniqueId;
    }

    private Set<RequestParameter> validateRequestParameter(Set<RequestParameter> requestParameters) {
        for (RequestParameter req : requestParameters) {
            Optional content;
            if (!"body".equals(req.getIn().getIn()) || !(content = req.getParameterSpecification().getContent()).isPresent()) continue;
            for (Representation rep : ((ContentSpecification)content.get()).getRepresentations()) {
                if (!rep.getModel().getScalar().isPresent() || !((ScalarModelSpecification)rep.getModel().getScalar().get()).getType().getType().equals("string")) continue;
                req.getExtensions().add(new StringVendorExtension(X_RAW_JSON_TYPE, "true"));
            }
        }
        return requestParameters;
    }

    private Set<String> validateResponseContentType(Operation operation) {
        if ("string".equals(operation.getResponseModel().getType())) {
            return this.validateContentType(operation.getProduces(), "text/plain");
        }
        return this.validateContentType(operation.getProduces(), "application/json");
    }

    private Set<String> validateContentType(Set<String> contentTypes, String defaultPrefer) {
        if (contentTypes.isEmpty()) {
            return contentTypes;
        }
        HashSet<String> onlyOne = new HashSet<String>(1);
        if (contentTypes.contains("*/*") || contentTypes.contains(defaultPrefer)) {
            onlyOne.add(defaultPrefer);
            return onlyOne;
        }
        if (contentTypes.contains("text/plain")) {
            onlyOne.add("text/plain");
            return onlyOne;
        }
        onlyOne.add("application/json");
        return onlyOne;
    }

    private String genXInterfaceName(String appName, String serviceName, String schemaId) {
        return new StringJoiner(".", X_JAVA_INTERFACE_PREFIX, INTF_SUFFIX).add(appName).add(serviceName).add(schemaId).toString();
    }
}

