/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.swagger;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import com.huaweicloud.common.schema.ServiceCombSwaggerHandler;
import com.huaweicloud.swagger.DocumentationSwaggerMapper;
import com.huaweicloud.swagger.ServiceCombDocumentationSwaggerMapper;
import com.huaweicloud.swagger.SpringCloudDocumentationSwaggerMapper;
import io.swagger.models.Swagger;
import io.swagger.v3.core.util.Yaml;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import springfox.documentation.service.Documentation;
import springfox.documentation.spring.web.DocumentationCache;
import springfox.documentation.spring.web.plugins.DocumentationPluginsBootstrapper;
import springfox.documentation.swagger2.mappers.ServiceModelToSwagger2Mapper;

public class ServiceCombSwaggerHandlerImpl
implements ServiceCombSwaggerHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceCombSwaggerHandlerImpl.class);
    @Autowired
    protected DocumentationPluginsBootstrapper documentationPluginsBootstrapper;
    @Autowired
    protected DocumentationCache documentationCache;
    @Autowired
    protected ServiceModelToSwagger2Mapper mapper;
    private Map<String, Swagger> swaggerMap = new HashMap<String, Swagger>();
    private Map<String, String> swaggerContent = new HashMap<String, String>();
    private Map<String, String> swaggerSummary = new HashMap<String, String>();
    @Value(value="${spring.cloud.servicecomb.swagger.enableJavaChassisAdapter:true}")
    protected boolean withJavaChassis;

    public void init(String appName, String serviceName) {
        this.documentationPluginsBootstrapper.start();
        Documentation documentation = this.documentationCache.documentationByGroup("default");
        DocumentationSwaggerMapper documentationSwaggerMapper = this.withJavaChassis ? new ServiceCombDocumentationSwaggerMapper(appName, serviceName, this.mapper) : new SpringCloudDocumentationSwaggerMapper(this.mapper);
        this.swaggerMap = documentationSwaggerMapper.documentationToSwaggers(documentation);
        this.swaggerContent = this.calcSchemaContent();
        this.swaggerSummary = this.calcSchemaSummary();
    }

    private Map<String, String> calcSchemaContent() {
        return this.swaggerMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            try {
                return Yaml.mapper().writeValueAsString(entry.getValue());
            }
            catch (JsonProcessingException e) {
                LOGGER.error("error when calcSchemaSummary.", (Throwable)e);
                return null;
            }
        }));
    }

    public List<String> getSchemaIds() {
        return new ArrayList<String>(this.swaggerMap.keySet());
    }

    public Map<String, String> getSchemasMap() {
        return this.swaggerContent;
    }

    public Map<String, String> getSchemasSummaryMap() {
        return this.swaggerSummary;
    }

    private Map<String, String> calcSchemaSummary() {
        return this.swaggerMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            try {
                return ServiceCombSwaggerHandlerImpl.calcSchemaSummary(Yaml.mapper().writeValueAsString(entry.getValue()));
            }
            catch (JsonProcessingException e) {
                LOGGER.error("error when calcSchemaSummary.", (Throwable)e);
                return null;
            }
        }));
    }

    private static String calcSchemaSummary(String schemaContent) {
        return Hashing.sha256().newHasher().putString((CharSequence)schemaContent, Charsets.UTF_8).hash().toString();
    }
}

