/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.om;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.beetl.core.om.BCW;

public class FieldAccessBCW
implements BCW {
    static final int MAGIC = -889275714;
    static final byte CONS_CLASS = 7;
    static final byte CONS_UTF8 = 1;
    static final byte CONS_METHODREF = 10;
    static final byte CONS_INTERFACE_METHODREF = 11;
    static final byte CONS_NAME_AND_TYPE = 12;
    static final byte CONS_DOUBLE = 6;
    static final short ALOAD_0 = 42;
    static final short ALOAD_1 = 43;
    static final short ALOAD_2 = 44;
    static final short INVOKE_SPECIAL = 183;
    static final short INVOKE_VIRTUAL = 182;
    static final short INVOKE_INTERFACE = 185;
    static final short RETURN = 177;
    static final short ARETURN = 176;
    static final short CHECK_CAST = 192;
    static final short INVOKE_STATIC = 184;
    static final String parentCls = "org/beetl/core/om/AttributeAccess";
    static final String initFunction = "<init>";
    static final String initFunctionDesc = "()V";
    static final String valueFunction = "value";
    static final String valueFunctionDesc = "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;";
    static final String code = "Code";
    static final String integerClass = "org/beetl/core/misc/NumberUtil";
    static final String valueOfFunction = "valueOf";
    static final String intValueOfFunctionDesc = "(I)Ljava/lang/Integer;";
    static final String shortClass = "java/lang/Short";
    static final String shortValueOfFunctionDesc = "(S)Ljava/lang/Short;";
    static final String booleanClass = "java/lang/Boolean";
    static final String booleanValueOfFunctionDesc = "(Z)Ljava/lang/Boolean;";
    static final String doubleClass = "java/lang/Double";
    static final String doubleValueOfFunctionDesc = "(D)Ljava/lang/Double;";
    static String longClass = "java/lang/Long";
    static String longValueOfFunctionDesc = "(J)Ljava/lang/Long;";
    static String byteClass = "java/lang/Byte";
    static String byteValueOfFunctionDesc = "(B)Ljava/lang/Byte;";
    byte[] cached = new byte[256];
    List<Object[]> constPool = new ArrayList<Object[]>();
    Map<String, Short> utfMap = new HashMap<String, Short>();
    Map<String, Short> classMap = new HashMap<String, Short>();
    String cls = "org/beetl/sample/s01/Test1";
    String targetCls = "org/beetl/core/lab/TestUser";
    String targetFunction = "getAge";
    String targetFunctionDesc = "()I";
    String retByteCodeType = "I";
    boolean isGeneralGet = false;
    boolean isInterface = false;

    public FieldAccessBCW(Class c, String name, String methodName, Class returnType) {
        String cname;
        if (c.isInterface()) {
            this.isInterface = true;
        }
        this.targetCls = cname = c.getName().replace(".", "/");
        this.cls = cname + "_" + name;
        this.targetFunction = methodName;
        String[] returnArray = this.getRetrunTypeDesc(returnType);
        String returnTypeClass = returnArray[0];
        this.retByteCodeType = returnArray[1];
        this.targetFunctionDesc = "()" + returnTypeClass;
    }

    public FieldAccessBCW(Class c, String name, String methodName, Class returnType, Class paremterType) {
        String cname;
        if (c.isInterface()) {
            this.isInterface = true;
        }
        this.targetCls = cname = c.getName().replace(".", "/");
        this.cls = cname + "_" + name;
        this.targetFunction = methodName;
        String[] returnArray = this.getRetrunTypeDesc(returnType);
        String returnTypeClass = returnArray[0];
        this.retByteCodeType = returnArray[1];
        this.targetFunctionDesc = "(Ljava/lang/String;)" + returnTypeClass;
        this.isGeneralGet = true;
    }

    @Override
    public byte[] getClassByte() throws Exception {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bs);
        this.write(out);
        return bs.toByteArray();
    }

    public void write(DataOutputStream out) throws Exception {
        out.writeInt(-889275714);
        out.writeShort(0);
        out.writeShort(49);
        short clsIndex = this.registerClass(this.cls);
        short parentIndex = this.registerClass(parentCls);
        byte[] initMethod = this.getInitMethod();
        byte[] valueMethod = this.getProxyMethod();
        out.writeShort(this.constPool.size() + 1);
        this.writeConstPool(out);
        out.writeShort(33);
        out.writeShort(clsIndex);
        out.writeShort(parentIndex);
        out.writeShort(0);
        out.writeShort(0);
        out.writeShort(2);
        out.write(initMethod);
        out.write(valueMethod);
        out.writeShort(0);
    }

    public void writeConstPool(DataOutputStream out) throws Exception {
        block7: for (Object[] array : this.constPool) {
            byte tag = (Byte)array[0];
            out.writeByte(tag);
            switch (tag) {
                case 7: {
                    out.writeShort(((Short)array[1]).shortValue());
                    continue block7;
                }
                case 1: {
                    out.writeShort(((Short)array[1]).shortValue());
                    byte[] content = (byte[])array[2];
                    out.write(content);
                    continue block7;
                }
                case 11: {
                    out.writeShort(((Short)array[1]).shortValue());
                    out.writeShort(((Short)array[2]).shortValue());
                    continue block7;
                }
                case 10: {
                    out.writeShort(((Short)array[1]).shortValue());
                    out.writeShort(((Short)array[2]).shortValue());
                    continue block7;
                }
                case 12: {
                    out.writeShort(((Short)array[1]).shortValue());
                    out.writeShort(((Short)array[2]).shortValue());
                    continue block7;
                }
            }
            throw new RuntimeException("tag=" + tag);
        }
    }

    public byte[] getProxyMethod() throws Exception {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bs);
        out.writeShort(1);
        short nameIndex = this.registerUTFString(valueFunction);
        out.writeShort(nameIndex);
        short descIndex = this.registerUTFString(valueFunctionDesc);
        out.writeShort(descIndex);
        out.writeShort(1);
        byte[] initCodeAttr = this.proxyCodeAttr();
        out.write(initCodeAttr);
        return bs.toByteArray();
    }

    public byte[] proxyCodeAttr() throws Exception {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bs);
        short index = this.registerUTFString(code);
        out.writeShort(index);
        byte[] codes = this.proxyCodes();
        int attrlen = 8 + codes.length + 4;
        out.writeInt(attrlen);
        if (this.retByteCodeType.equals("D") || this.retByteCodeType.equals("J")) {
            out.writeShort(2 + (this.isGeneralGet ? 1 : 0));
        } else {
            out.writeShort(1 + (this.isGeneralGet ? 1 : 0));
        }
        out.writeShort(3);
        out.writeInt(codes.length);
        out.write(codes);
        out.writeShort(0);
        out.writeShort(0);
        return bs.toByteArray();
    }

    public byte[] proxyCodes() throws Exception {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bs);
        out.writeByte(43);
        out.writeByte(192);
        short classIndex = this.registerClass(this.targetCls);
        out.writeShort(classIndex);
        if (this.isGeneralGet) {
            out.writeByte(44);
            out.writeByte(192);
            classIndex = this.registerClass("java/lang/String");
            out.writeShort(classIndex);
        }
        short methodIndex = 0;
        if (this.isInterface) {
            out.writeByte(185);
            methodIndex = this.registerInterfaceMethod(this.targetCls, this.targetFunction, this.targetFunctionDesc);
            out.writeShort(methodIndex);
            out.writeByte(1);
            out.writeByte(0);
        } else {
            out.writeByte(182);
            methodIndex = this.registerMethod(this.targetCls, this.targetFunction, this.targetFunctionDesc);
            out.writeShort(methodIndex);
        }
        if (this.retByteCodeType.equals("I")) {
            out.writeByte(184);
            methodIndex = this.registerMethod(integerClass, valueOfFunction, intValueOfFunctionDesc);
            out.writeShort(methodIndex);
        } else if (this.retByteCodeType.equals("S")) {
            out.writeByte(184);
            methodIndex = this.registerMethod(shortClass, valueOfFunction, shortValueOfFunctionDesc);
            out.writeShort(methodIndex);
        } else if (this.retByteCodeType.equals("D")) {
            out.writeByte(184);
            methodIndex = this.registerMethod(doubleClass, valueOfFunction, doubleValueOfFunctionDesc);
            out.writeShort(methodIndex);
        } else if (this.retByteCodeType.equals("J")) {
            out.writeByte(184);
            methodIndex = this.registerMethod(longClass, valueOfFunction, longValueOfFunctionDesc);
            out.writeShort(methodIndex);
        } else if (this.retByteCodeType.equals("Z")) {
            out.writeByte(184);
            methodIndex = this.registerMethod(booleanClass, valueOfFunction, booleanValueOfFunctionDesc);
            out.writeShort(methodIndex);
        } else if (this.retByteCodeType.equals("B")) {
            out.writeByte(184);
            methodIndex = this.registerMethod(byteClass, valueOfFunction, byteValueOfFunctionDesc);
            out.writeShort(methodIndex);
        }
        out.writeByte(-80);
        return bs.toByteArray();
    }

    public byte[] getInitMethod() throws Exception {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bs);
        out.writeShort(1);
        short nameIndex = this.registerUTFString(initFunction);
        out.writeShort(nameIndex);
        short descIndex = this.registerUTFString(initFunctionDesc);
        out.writeShort(descIndex);
        out.writeShort(1);
        byte[] initCodeAttr = this.initCodeAttr();
        out.write(initCodeAttr);
        return bs.toByteArray();
    }

    public byte[] initCodeAttr() throws Exception {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bs);
        short index = this.registerUTFString(code);
        out.writeShort(index);
        byte[] codes = this.initCodes();
        int attrlen = 8 + codes.length + 4;
        out.writeInt(attrlen);
        out.writeShort(1);
        out.writeShort(1);
        out.writeInt(codes.length);
        out.write(codes);
        out.writeShort(0);
        out.writeShort(0);
        return bs.toByteArray();
    }

    public byte[] initCodes() throws Exception {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bs);
        out.writeByte(42);
        out.writeByte(183);
        short index = this.registerMethod(parentCls, initFunction, initFunctionDesc);
        out.writeShort(index);
        out.writeByte(-79);
        return bs.toByteArray();
    }

    public short registerClass(String clsName) {
        Short index = this.classMap.get(clsName);
        if (index != null) {
            return index;
        }
        short clsNameIndex = this.registerUTFString(clsName);
        Object[] objectArray = new Object[2];
        objectArray[0] = (byte)7;
        objectArray[1] = clsNameIndex;
        Object[] array = objectArray;
        this.constPool.add(array);
        index = this.getCurrentIndex();
        this.classMap.put(clsName, index);
        return index;
    }

    public short registerMethod(String clsName, String method, String desc) {
        short clsNameIndex = this.registerClass(clsName);
        short nameAndTypeIndex = this.registerNameAndType(method, desc);
        Object[] objectArray = new Object[3];
        objectArray[0] = (byte)10;
        objectArray[1] = clsNameIndex;
        objectArray[2] = nameAndTypeIndex;
        Object[] array = objectArray;
        this.constPool.add(array);
        return this.getCurrentIndex();
    }

    public short registerInterfaceMethod(String clsName, String method, String desc) {
        short clsNameIndex = this.registerClass(clsName);
        short nameAndTypeIndex = this.registerNameAndType(method, desc);
        Object[] objectArray = new Object[3];
        objectArray[0] = (byte)11;
        objectArray[1] = clsNameIndex;
        objectArray[2] = nameAndTypeIndex;
        Object[] array = objectArray;
        this.constPool.add(array);
        return this.getCurrentIndex();
    }

    public short registerNameAndType(String method, String desc) {
        short nameIndex = this.registerUTFString(method);
        short descIndex = this.registerUTFString(desc);
        Object[] objectArray = new Object[3];
        objectArray[0] = (byte)12;
        objectArray[1] = nameIndex;
        objectArray[2] = descIndex;
        Object[] array = objectArray;
        this.constPool.add(array);
        return this.getCurrentIndex();
    }

    public short registerUTFString(String str) {
        Short index = this.utfMap.get(str);
        if (index != null) {
            return index;
        }
        try {
            byte[] bs = str.getBytes("UTF-8");
            short len = (short)bs.length;
            Object[] array = new Object[]{(byte)1, len, bs};
            this.constPool.add(array);
            index = this.getCurrentIndex();
            this.utfMap.put(str, index);
            return index;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public short getCurrentIndex() {
        return (short)this.constPool.size();
    }

    private String[] getRetrunTypeDesc(Class c) {
        StringBuilder sb = new StringBuilder();
        String returnType = "";
        if (c.isArray()) {
            sb.append(c.getName().replace(".", "/"));
        } else if (c == Integer.TYPE) {
            sb.append("I");
            returnType = "I";
        } else if (c == Boolean.TYPE) {
            sb.append("Z");
            returnType = "Z";
        } else if (c == Character.TYPE) {
            sb.append("C");
            returnType = "C";
        } else if (c == Short.TYPE) {
            sb.append("S");
            returnType = "S";
        } else if (c == Float.TYPE) {
            sb.append("F");
            returnType = "F";
        } else if (c == Long.TYPE) {
            sb.append("J");
            returnType = "J";
        } else if (c == Double.TYPE) {
            sb.append("D");
            returnType = "D";
        } else if (c == Byte.TYPE) {
            sb.append("B");
            returnType = "B";
        } else {
            sb.append("L").append(c.getName().replace(".", "/")).append(";");
            returnType = "L";
        }
        return new String[]{sb.toString(), returnType};
    }
}

