/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.impl.cache;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.beetl.core.Configuration;
import org.beetl.core.runtime.IBeetlCache;

public class LRUBeetlCache
implements IBeetlCache {
    Map lruCache;

    @Override
    public void init(Configuration configuration) {
        int size = configuration.getIntProperty("cache.size", 256);
        this.lruCache = Collections.synchronizedMap(new LRUCache(size));
    }

    @Override
    public Object get(Object key) {
        return this.lruCache.get(key);
    }

    @Override
    public Object get(Object key, Function function) {
        return this.lruCache.computeIfAbsent(key, function);
    }

    @Override
    public void remove(Object key) {
        this.lruCache.remove(key);
    }

    @Override
    public void set(Object key, Object value) {
        this.lruCache.put(key, value);
    }

    @Override
    public void clearAll() {
        this.lruCache.clear();
    }

    @Override
    public long size() {
        return this.lruCache.size();
    }

    static class LRUCache<K, V>
    extends LinkedHashMap<K, V> {
        private int cacheSize;

        public LRUCache(int cacheSize) {
            super(16, 0.75f, true);
            this.cacheSize = cacheSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.cacheSize;
        }
    }
}

