/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.beetl.core.GroupTemplate;
import org.beetl.core.ResourceLoader;
import org.beetl.core.Template;
import org.beetl.core.resource.StringTemplateResourceLoader;
import org.beetl.sql.core.BeetlSQLException;
import org.beetl.sql.core.Interceptor;
import org.beetl.sql.core.InterceptorContext;
import org.beetl.sql.core.RowMapper;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.SQLReady;
import org.beetl.sql.core.SQLResult;
import org.beetl.sql.core.SQLSource;
import org.beetl.sql.core.SQLTableSource;
import org.beetl.sql.core.annotatoin.AssignID;
import org.beetl.sql.core.db.ClassDesc;
import org.beetl.sql.core.db.KeyHolder;
import org.beetl.sql.core.db.MetadataManager;
import org.beetl.sql.core.db.TableDesc;
import org.beetl.sql.core.engine.RefreshRuntimeException;
import org.beetl.sql.core.engine.SQLParameter;
import org.beetl.sql.core.kit.BeanKit;
import org.beetl.sql.core.kit.CaseInsensitiveOrderSet;
import org.beetl.sql.core.kit.StringKit;
import org.beetl.sql.core.mapping.BeanProcessor;
import org.beetl.sql.core.mapping.RowMapperResultSetExt;
import org.beetl.sql.core.orm.LazyMappingEntity;
import org.beetl.sql.core.orm.MappingEntity;
import org.beetl.sql.core.orm.OrmCondition;
import org.beetl.sql.core.orm.OrmQuery;

public class SQLScript {
    final SQLManager sm;
    final String id;
    final String sql;
    final SQLSource sqlSource;
    final String dbName;

    public SQLScript(SQLSource sqlSource, SQLManager sm) {
        this.sqlSource = sqlSource;
        this.sql = sqlSource.getTemplate();
        this.sm = sm;
        this.id = sqlSource.getId();
        this.dbName = sm.getDbStyle().getName();
    }

    private static boolean isBaseDataType(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return true;
        }
        if (clazz.getName().startsWith("java")) {
            return clazz == String.class || clazz == Integer.class || clazz == Byte.class || clazz == Long.class || clazz == Double.class || clazz == Float.class || clazz == Character.class || clazz == Short.class || clazz == BigDecimal.class || clazz == BigInteger.class || clazz == Boolean.class || clazz == java.util.Date.class || clazz == Date.class || clazz == Timestamp.class;
        }
        return false;
    }

    protected SQLResult run(Map<String, Object> paras) {
        return this.run(paras, null);
    }

    protected SQLResult run(Map<String, Object> paras, String parentId) {
        GroupTemplate gt = this.sm.beetl.getGroupTemplate();
        Template t = null;
        try {
            t = parentId != null ? gt.getTemplate(this.sqlSource.getId(), parentId) : gt.getTemplate(this.sqlSource.getId());
        }
        catch (RefreshRuntimeException beetl) {
            t = gt.getTemplate(this.sqlSource.getTemplate(), (ResourceLoader)new StringTemplateResourceLoader());
        }
        LinkedList<SQLParameter> jdbcPara = new LinkedList<SQLParameter>();
        if (paras != null) {
            for (Map.Entry<String, Object> entry : paras.entrySet()) {
                t.binding(entry.getKey(), entry.getValue());
            }
        }
        t.binding("_paras", jdbcPara);
        t.binding("_manager", (Object)this.sm);
        t.binding("_id", (Object)this.id);
        String jdbcSql = t.render();
        SQLResult result = new SQLResult();
        result.jdbcSql = jdbcSql;
        result.jdbcPara = jdbcPara;
        result.mapingEntrys = (List)t.getCtx().getGlobal("_mapping");
        return result;
    }

    private void addOrmQuery(Class target, SQLResult result) {
        if (target == null) {
            return;
        }
        OrmQuery ormQuery = target.getAnnotation(OrmQuery.class);
        if (ormQuery == null) {
            return;
        }
        OrmCondition[] condtions = ormQuery.value();
        HashMap<String, MappingEntity> map = new HashMap<String, MappingEntity>();
        for (OrmCondition cond : condtions) {
            MappingEntity mappingEntity = null;
            mappingEntity = cond.lazy() ? new LazyMappingEntity() : new MappingEntity();
            mappingEntity.setSingle(cond.type() == OrmQuery.Type.ONE);
            mappingEntity.setTarget(cond.target().getName());
            if (cond.alias().length() != 0) {
                mappingEntity.setTailName(cond.alias());
            }
            mappingEntity.setSqlId(cond.sqlId().length() != 0 ? cond.sqlId() : null);
            HashMap<String, String> mapKey = new HashMap<String, String>();
            mapKey.put(cond.attr(), cond.targetAttr());
            mappingEntity.setMapkey(mapKey);
            map.put(mappingEntity.getTarget(), mappingEntity);
        }
        if (result.mapingEntrys != null) {
            for (MappingEntity entity : result.mapingEntrys) {
                String mapTarget = entity.getTarget();
                if (mapTarget.indexOf(46) == -1) {
                    mapTarget = BeanKit.getPackageName(target).concat(".").concat(mapTarget);
                    entity.setTarget(mapTarget);
                }
                if (!map.keySet().contains(mapTarget)) continue;
                map.remove(mapTarget);
            }
            result.mapingEntrys.addAll(map.values());
        } else {
            result.mapingEntrys = new ArrayList(map.values());
        }
    }

    public int insert(Object paras) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("_root", paras);
        this.addParaIfAssignId(paras);
        PreparedStatement ps = null;
        Connection conn = null;
        SQLResult result = this.run(map);
        String sql = result.jdbcSql;
        List<SQLParameter> objs = result.jdbcPara;
        InterceptorContext ctx = this.callInterceptorAsBefore(this.id, sql, true, objs, map);
        sql = ctx.getSql();
        objs = ctx.getParas();
        try {
            conn = this.sm.getDs().getConn(this.id, true, sql, objs);
            ps = conn.prepareStatement(sql);
            this.setPreparedStatementPara(ps, objs);
            int ret = ps.executeUpdate();
            this.callInterceptorAsAfter(ctx, ret);
            int n = ret;
            this.clean(true, conn, ps);
            return n;
        }
        catch (SQLException e) {
            try {
                this.callInterceptorAsException(ctx, e);
                throw new BeetlSQLException(1, e);
            }
            catch (Throwable throwable) {
                this.clean(true, conn, ps);
                throw throwable;
            }
        }
    }

    public int insert(Object paras, KeyHolder holder) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("_root", paras);
        this.addParaIfAssignId(paras);
        PreparedStatement ps = null;
        Connection conn = null;
        InterceptorContext ctx = null;
        try {
            int idType;
            SQLResult result = this.run(map);
            String sql = result.jdbcSql;
            List<SQLParameter> objs = result.jdbcPara;
            ctx = this.callInterceptorAsBefore(this.id, sql, true, objs, map);
            sql = ctx.getSql();
            objs = ctx.getParas();
            if (conn == null) {
                conn = this.sm.getDs().getConn(this.id, true, sql, objs);
            }
            if ((idType = ((SQLTableSource)this.sqlSource).getIdType()) == 1) {
                ps = conn.prepareStatement(sql);
            } else if (idType == 2) {
                ps = conn.prepareStatement(sql, 1);
            } else if (idType == 3) {
                CaseInsensitiveOrderSet idCols = (CaseInsensitiveOrderSet)((SQLTableSource)this.sqlSource).getTableDesc().getIdNames();
                if (idCols.size() != 1) {
                    throw new BeetlSQLException(4);
                }
                ps = conn.prepareStatement(sql, new String[]{idCols.getFirst()});
            } else {
                ps = conn.prepareStatement(sql);
            }
            this.setPreparedStatementPara(ps, objs);
            int ret = ps.executeUpdate();
            if (idType == 2 || idType == 3) {
                ResultSet seqRs = ps.getGeneratedKeys();
                seqRs.next();
                Object key = seqRs.getObject(1);
                holder.setKey(key);
                seqRs.close();
            }
            this.callInterceptorAsAfter(ctx, ret);
            int n = ret;
            this.clean(true, conn, ps);
            return n;
        }
        catch (SQLException e) {
            try {
                this.callInterceptorAsException(ctx, e);
                throw new BeetlSQLException(1, e);
            }
            catch (Throwable throwable) {
                this.clean(true, conn, ps);
                throw throwable;
            }
        }
    }

    public int insertBySqlId(Map map, KeyHolder holder, String keyName) {
        boolean getKey = holder != null;
        PreparedStatement ps = null;
        Connection conn = null;
        InterceptorContext ctx = null;
        try {
            SQLResult result = this.run(map);
            String sql = result.jdbcSql;
            List<SQLParameter> objs = result.jdbcPara;
            ctx = this.callInterceptorAsBefore(this.id, sql, true, objs, map);
            sql = ctx.getSql();
            objs = ctx.getParas();
            if (conn == null) {
                conn = this.sm.getDs().getConn(this.id, true, sql, objs);
            }
            ps = getKey ? conn.prepareStatement(sql, new String[]{keyName}) : conn.prepareStatement(sql);
            this.setPreparedStatementPara(ps, objs);
            int ret = ps.executeUpdate();
            if (getKey) {
                ResultSet seqRs = ps.getGeneratedKeys();
                seqRs.next();
                Object key = seqRs.getObject(1);
                holder.setKey(key);
                seqRs.close();
            }
            this.callInterceptorAsAfter(ctx, ret);
            int n = ret;
            this.clean(true, conn, ps);
            return n;
        }
        catch (SQLException e) {
            try {
                this.callInterceptorAsException(ctx, e);
                throw new BeetlSQLException(1, e);
            }
            catch (Throwable throwable) {
                this.clean(true, conn, ps);
                throw throwable;
            }
        }
    }

    public <T> T singleSelect(Object paras, Class<T> target) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("_root", paras);
        return this.selectSingle(map, target);
    }

    public <T> T selectSingle(Map<String, Object> map, Class<T> target) {
        List<T> result = this.select(target, map);
        if (result.size() > 0) {
            return result.get(0);
        }
        return null;
    }

    public <T> T selectUnique(Map<String, Object> map, Class<T> target) {
        List<T> result = this.select(target, map);
        int size = result.size();
        if (size == 1) {
            return result.get(0);
        }
        if (size == 0) {
            throw new BeetlSQLException(12, "unique\u67e5\u8be2\uff0c\u4f46\u6570\u636e\u5e93\u672a\u627e\u5230\u7ed3\u679c\u96c6:\u53c2\u6570\u662f" + map);
        }
        throw new BeetlSQLException(12, "unique\u67e5\u8be2\uff0c\u627e\u5230\u591a\u6761\u8bb0\u5f55:\u53c2\u6570\u662f" + map);
    }

    public <T> List<T> select(Class<T> clazz, Object paras) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("_root", paras);
        return this.select(clazz, map);
    }

    public <T> List<T> select(Class<T> clazz, Map<String, Object> paras, RowMapper<T> mapper) {
        SQLResult result = this.run(paras);
        this.addOrmQuery(clazz, result);
        String sql = result.jdbcSql;
        List<SQLParameter> objs = result.jdbcPara;
        ResultSet rs = null;
        PreparedStatement ps = null;
        Object resultList = null;
        InterceptorContext ctx = this.callInterceptorAsBefore(this.id, sql, false, objs, paras);
        if (ctx.getResult() != null) {
            this.callInterceptorAsAfter(ctx, ctx.getResult());
            return (List)ctx.getResult();
        }
        sql = ctx.getSql();
        objs = ctx.getParas();
        Connection conn = null;
        try {
            Iterator<MappingEntity> beanProcessor;
            conn = this.sm.getDs().getConn(this.id, false, sql, objs);
            ps = conn.prepareStatement(sql);
            this.setPreparedStatementPara(ps, objs);
            rs = ps.executeQuery();
            if (mapper != null) {
                beanProcessor = this.getBeanProcessor();
                resultList = new RowMapperResultSetExt<T>(mapper, (BeanProcessor)((Object)beanProcessor)).handleResultSet(this.id, rs, (Class)clazz);
            } else {
                resultList = this.mappingSelect(rs, clazz);
            }
            this.callInterceptorAsAfter(ctx, resultList);
            if (mapper == null && result.mapingEntrys != null) {
                for (MappingEntity mapConf : result.mapingEntrys) {
                    mapConf.map((List)resultList, this.sm, paras);
                }
            }
            beanProcessor = resultList;
            this.clean(false, conn, ps, rs);
            return beanProcessor;
        }
        catch (SQLException e) {
            try {
                this.callInterceptorAsException(ctx, e);
                throw new BeetlSQLException(1, e);
            }
            catch (Throwable throwable) {
                this.clean(false, conn, ps, rs);
                throw throwable;
            }
        }
    }

    public <T> List<T> select(Class<T> clazz, Map<String, Object> paras) {
        return this.select(clazz, paras, null);
    }

    public <T> List<T> mappingSelect(ResultSet rs, Class<T> clazz) throws SQLException {
        List<Object> resultList = null;
        BeanProcessor beanProcessor = this.getBeanProcessor();
        if (Map.class.isAssignableFrom(clazz)) {
            resultList = new ArrayList();
            while (rs.next()) {
                Map<String, Object> map = beanProcessor.toMap(this.sqlSource.getId(), clazz, rs);
                resultList.add(map);
            }
            return resultList;
        }
        if (SQLScript.isBaseDataType(clazz)) {
            resultList = new ArrayList(1);
            while (rs.next()) {
                Object result = beanProcessor.toBaseType(this.sqlSource.getId(), clazz, rs);
                resultList.add(result);
            }
        } else {
            resultList = beanProcessor.toBeanList(this.sqlSource.getId(), rs, clazz);
            return resultList;
        }
        return resultList;
    }

    private BeanProcessor getBeanProcessor() {
        String sqlId = this.sqlSource.getId();
        BeanProcessor bp = this.sm.getProcessors().get(sqlId);
        if (bp != null) {
            return bp;
        }
        String ns = sqlId.substring(0, sqlId.indexOf("."));
        bp = this.sm.getProcessors().get(ns);
        if (bp != null) {
            return bp;
        }
        return this.sm.getDefaultBeanProcessors();
    }

    public <T> List<T> select(Map<String, Object> paras, Class<T> mapping, RowMapper<T> mapper, long start, long size) {
        SQLScript pageScript = this.sm.getPageSqlScript(this.id);
        if (paras == null) {
            paras = new HashMap<String, Object>();
        }
        this.sm.getDbStyle().initPagePara(paras, start, size);
        return pageScript.select(mapping, paras, mapper);
    }

    public <T> List<T> select(Object paras, Class<T> mapping, RowMapper<T> mapper, long start, long end) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("_root", paras);
        return this.select(map, mapping, mapper, start, end);
    }

    public long selectCount(Object paras) {
        return this.singleSelect(paras, Long.class);
    }

    public long selectCount(Map<String, Object> paras) {
        return this.selectSingle(paras, Long.class);
    }

    public int update(Map<String, Object> paras) {
        SQLResult result = this.run(paras);
        String sql = result.jdbcSql;
        List<SQLParameter> objs = result.jdbcPara;
        InterceptorContext ctx = this.callInterceptorAsBefore(this.id, sql, true, objs, paras);
        sql = ctx.getSql();
        objs = ctx.getParas();
        int rs = 0;
        PreparedStatement ps = null;
        Connection conn = null;
        try {
            conn = this.sm.getDs().getConn(this.id, true, sql, objs);
            ps = conn.prepareStatement(sql);
            this.setPreparedStatementPara(ps, objs);
            rs = ps.executeUpdate();
            this.callInterceptorAsAfter(ctx, rs);
            this.clean(true, conn, ps);
        }
        catch (SQLException e) {
            try {
                this.callInterceptorAsException(ctx, e);
                throw new BeetlSQLException(1, e);
            }
            catch (Throwable throwable) {
                this.clean(true, conn, ps);
                throw throwable;
            }
        }
        return rs;
    }

    public int update(Object obj) {
        HashMap<String, Object> paras = new HashMap<String, Object>();
        paras.put("_root", obj);
        return this.update(paras);
    }

    public int[] updateBatch(Map<String, Object>[] maps) {
        int[] rs = null;
        Statement ps = null;
        Connection conn = null;
        InterceptorContext ctx = null;
        try {
            conn = this.sm.getDs().getMaster();
            for (int k = 0; k < maps.length; ++k) {
                Map<String, Object> paras = maps[k];
                SQLResult result = this.run(paras);
                List<SQLParameter> objs = result.jdbcPara;
                if (ps == null) {
                    ps = conn.prepareStatement(result.jdbcSql);
                    ctx = this.callInterceptorAsBefore(this.id, this.sql, true, Collections.EMPTY_LIST, paras);
                }
                this.setPreparedStatementPara((PreparedStatement)ps, objs);
                ps.addBatch();
            }
            rs = ps.executeBatch();
            this.callInterceptorAsAfter(ctx, rs);
            this.clean(true, conn, (PreparedStatement)ps);
        }
        catch (SQLException e) {
            try {
                this.callInterceptorAsException(ctx, e);
                throw new BeetlSQLException(1, e);
            }
            catch (Throwable throwable) {
                this.clean(true, conn, (PreparedStatement)ps);
                throw throwable;
            }
        }
        return rs;
    }

    public int[] insertBatch(List<?> list) {
        if (list.size() == 0) {
            return new int[0];
        }
        int[] rs = null;
        Statement ps = null;
        Connection conn = null;
        InterceptorContext ctx = null;
        try {
            for (int k = 0; k < list.size(); ++k) {
                HashMap<String, Object> paras = new HashMap<String, Object>();
                Object entity = list.get(k);
                this.addParaIfAssignId(entity);
                paras.put("_root", entity);
                SQLResult result = this.run(paras);
                List<SQLParameter> objs = result.jdbcPara;
                if (ps == null) {
                    conn = this.sm.getDs().getConn(this.id, true, result.jdbcSql, objs);
                    ps = conn.prepareStatement(result.jdbcSql);
                    ctx = this.callInterceptorAsBefore(this.id, result.jdbcSql, true, new ArrayList<SQLParameter>(0), paras);
                }
                this.setPreparedStatementPara((PreparedStatement)ps, objs);
                ps.addBatch();
            }
            rs = ps.executeBatch();
            this.callInterceptorAsAfter(ctx, rs);
            this.clean(true, conn, (PreparedStatement)ps);
        }
        catch (SQLException e) {
            try {
                this.callInterceptorAsException(ctx, e);
                throw new BeetlSQLException(1, e);
            }
            catch (Throwable throwable) {
                this.clean(true, conn, (PreparedStatement)ps);
                throw throwable;
            }
        }
        return rs;
    }

    public int[] updateBatch(List<?> list) {
        if (list.size() == 0) {
            return new int[0];
        }
        Connection conn = null;
        InterceptorContext lastCtx = null;
        int[] jdbcRets = new int[list.size()];
        try {
            HashMap<String, Object> batchPs = new HashMap<String, Object>();
            HashMap<String, InterceptorContext> batchCtx = new HashMap<String, InterceptorContext>();
            HashMap<String, ArrayList<Integer>> batchRet = new HashMap<String, ArrayList<Integer>>();
            conn = this.sm.getDs().getMaster();
            for (int k = 0; k < list.size(); ++k) {
                HashMap<String, Object> paras = new HashMap<String, Object>();
                paras.put("_root", list.get(k));
                SQLResult result = this.run(paras);
                List<SQLParameter> objs = result.jdbcPara;
                Object ps = (Interceptor[])batchPs.get(result.jdbcSql);
                ArrayList<Integer> rets = (ArrayList<Integer>)batchRet.get(result.jdbcSql);
                InterceptorContext ctx = (InterceptorContext)batchCtx.get(result.jdbcSql);
                if (ps == null) {
                    ps = conn.prepareStatement(result.jdbcSql);
                    ctx = new InterceptorContext(this.id, result.jdbcSql, new ArrayList<SQLParameter>(0), paras, true);
                    rets = new ArrayList<Integer>();
                    batchCtx.put(result.jdbcSql, ctx);
                    batchPs.put(result.jdbcSql, ps);
                    batchRet.put(result.jdbcSql, rets);
                }
                this.setPreparedStatementPara((PreparedStatement)ps, objs);
                ps.addBatch();
                rets.add(k);
                ctx.getParas().add(new SQLParameter(objs));
            }
            for (Map.Entry entry : batchPs.entrySet()) {
                PreparedStatement ps = (PreparedStatement)entry.getValue();
                lastCtx = (InterceptorContext)batchCtx.get(entry.getKey());
                List rets = (List)batchRet.get(entry.getKey());
                for (Interceptor in : this.sm.inters) {
                    in.before(lastCtx);
                }
                int[] rs = ps.executeBatch();
                for (int i = 0; i < rs.length; ++i) {
                    int realIndex = (Integer)rets.get(i);
                    jdbcRets[realIndex] = rs[i];
                }
                this.callInterceptorAsAfter(lastCtx, rs);
            }
            this.clean(conn);
        }
        catch (SQLException e) {
            try {
                this.callInterceptorAsException(lastCtx, e);
                throw new BeetlSQLException(1, e);
            }
            catch (Throwable throwable) {
                this.clean(conn);
                throw throwable;
            }
        }
        return jdbcRets;
    }

    public <T> T unique(Class<T> clazz, RowMapper<T> mapper, Object objId) {
        return this.single(clazz, mapper, objId, true);
    }

    public <T> T single(Class<T> clazz, RowMapper<T> mapper, Object objId) {
        return this.single(clazz, mapper, objId, false);
    }

    /*
     * Loose catch block
     */
    public <T> T single(Class<T> clazz, RowMapper<T> mapper, Object objId, boolean throwException) {
        Connection conn;
        InterceptorContext ctx;
        T model;
        PreparedStatement ps;
        ResultSet rs;
        SQLResult result;
        TableDesc table;
        block15: {
            MetadataManager mm = this.sm.getDbStyle().getMetadataManager();
            table = mm.getTable(this.sm.getNc().getTableName(clazz));
            ClassDesc classDesc = table.getClassDesc(clazz, this.sm.getNc());
            HashMap<String, Object> paras = new HashMap<String, Object>();
            this.setIdsParas(classDesc, objId, paras);
            result = this.run(paras);
            this.addOrmQuery(clazz, result);
            String sql = result.jdbcSql;
            List<SQLParameter> objs = result.jdbcPara;
            rs = null;
            ps = null;
            model = null;
            ctx = this.callInterceptorAsBefore(this.id, sql, false, objs, paras);
            if (ctx.getResult() != null) {
                this.callInterceptorAsAfter(ctx, ctx.getResult());
                return (T)ctx.getResult();
            }
            sql = ctx.getSql();
            objs = ctx.getParas();
            conn = null;
            conn = this.sm.getDs().getConn(this.id, false, sql, objs);
            ps = conn.prepareStatement(sql);
            this.setPreparedStatementPara(ps, objs);
            rs = ps.executeQuery();
            BeanProcessor beanProcessor = this.getBeanProcessor();
            if (rs.next()) {
                model = beanProcessor.toBean(rs, clazz);
                break block15;
            }
            if (throwException) {
                throw new BeetlSQLException(12, "unique\u67e5\u8be2\uff0c\u4f46\u6570\u636e\u5e93\u672a\u627e\u5230\u7ed3\u679c\u96c6");
            }
            this.callInterceptorAsAfter(ctx, ctx.getResult());
            T t = null;
            this.clean(false, conn, ps, rs);
            return t;
        }
        try {
            if (mapper != null) {
                model = mapper.mapRow(model, rs, 1);
            }
            if (model != null && result.mapingEntrys != null) {
                for (MappingEntity mapConf : result.mapingEntrys) {
                    mapConf.singleMap(model, this.sm);
                }
            }
            {
                catch (BeetlSQLException ex) {
                    if (ex.code == 12) {
                        throw new BeetlSQLException(12, "unique\u67e5\u8be2" + table.getName() + ",\u4f46\u6570\u636e\u5e93\u672a\u627e\u5230\u7ed3\u679c\u96c6:\u4e3b\u952e\u662f" + objId);
                    }
                    throw ex;
                }
            }
            this.callInterceptorAsAfter(ctx, model);
            this.clean(false, conn, ps, rs);
        }
        catch (SQLException e) {
            try {
                this.callInterceptorAsException(ctx, e);
                throw new BeetlSQLException(1, e);
            }
            catch (Throwable throwable) {
                this.clean(false, conn, ps, rs);
                throw throwable;
            }
        }
        return model;
    }

    public int deleteById(Class<?> clazz, Object objId) {
        MetadataManager mm = this.sm.getDbStyle().getMetadataManager();
        TableDesc table = mm.getTable(this.sm.getNc().getTableName(clazz));
        ClassDesc classDesc = table.getClassDesc(clazz, this.sm.getNc());
        HashMap<String, Object> paras = new HashMap<String, Object>();
        this.setIdsParas(classDesc, objId, paras);
        SQLResult result = this.run(paras);
        String sql = result.jdbcSql;
        List<SQLParameter> objs = result.jdbcPara;
        InterceptorContext ctx = this.callInterceptorAsBefore(this.id, sql, true, objs, paras);
        sql = ctx.getSql();
        objs = ctx.getParas();
        int rs = 0;
        PreparedStatement ps = null;
        Connection conn = null;
        try {
            conn = this.sm.getDs().getConn(this.id, true, sql, objs);
            ps = conn.prepareStatement(sql);
            this.setPreparedStatementPara(ps, objs);
            rs = ps.executeUpdate();
            this.callInterceptorAsAfter(ctx, rs);
            this.clean(true, conn, ps);
        }
        catch (SQLException e) {
            try {
                this.callInterceptorAsException(ctx, e);
                throw new BeetlSQLException(1, e);
            }
            catch (Throwable throwable) {
                this.clean(true, conn, ps);
                throw throwable;
            }
        }
        return rs;
    }

    public <T> List<T> sqlReadySelect(Class<T> clazz, SQLReady p) {
        String sql = this.sql;
        List<SQLParameter> objs = this.toSQLParameters(p.getArgs());
        ResultSet rs = null;
        PreparedStatement ps = null;
        List<T> resultList = null;
        InterceptorContext ctx = this.callInterceptorAsBefore(this.id, sql, false, objs, this.getSQLReadyParas(Arrays.asList(p.getArgs())));
        sql = ctx.getSql();
        objs = ctx.getParas();
        Connection conn = null;
        try {
            conn = this.sm.getDs().getConn(this.id, false, sql, objs);
            ps = conn.prepareStatement(sql);
            this.setPreparedStatementPara(ps, objs);
            rs = ps.executeQuery();
            resultList = this.mappingSelect(rs, clazz);
            this.callInterceptorAsAfter(ctx, resultList);
            List<T> list = resultList;
            this.clean(false, conn, ps, rs);
            return list;
        }
        catch (SQLException e) {
            try {
                this.callInterceptorAsException(ctx, e);
                throw new BeetlSQLException(1, e);
            }
            catch (Throwable throwable) {
                this.clean(false, conn, ps, rs);
                throw throwable;
            }
        }
    }

    public int sqlReadyExecuteUpdate(SQLReady p) {
        String sql = this.sql;
        List<SQLParameter> objs = this.toSQLParameters(p.getArgs());
        InterceptorContext ctx = this.callInterceptorAsBefore(this.id, sql, true, objs, this.getSQLReadyParas(Arrays.asList(p.getArgs())));
        sql = ctx.getSql();
        objs = ctx.getParas();
        int rs = 0;
        PreparedStatement ps = null;
        Connection conn = null;
        try {
            conn = this.sm.getDs().getConn(this.id, true, sql, objs);
            ps = conn.prepareStatement(sql);
            this.setPreparedStatementPara(ps, objs);
            rs = ps.executeUpdate();
            this.callInterceptorAsAfter(ctx, rs);
            this.clean(true, conn, ps);
        }
        catch (SQLException e) {
            try {
                this.callInterceptorAsException(ctx, e);
                throw new BeetlSQLException(1, e);
            }
            catch (Throwable throwable) {
                this.clean(true, conn, ps);
                throw throwable;
            }
        }
        return rs;
    }

    private void setPreparedStatementPara(PreparedStatement ps, List<SQLParameter> objs) throws SQLException {
        if (objs.isEmpty()) {
            return;
        }
        BeanProcessor beanProcessor = this.getBeanProcessor();
        beanProcessor.setPreparedStatementPara(this.sqlSource.getId(), ps, objs);
    }

    protected void clean(boolean isUpdate, Connection conn, PreparedStatement ps, ResultSet rs) {
        block8: {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (ps != null) {
                    ps.close();
                }
                if (this.sm.getDs().isTransaction()) break block8;
                try {
                    if (conn != null) {
                        if (isUpdate && !conn.getAutoCommit()) {
                            conn.commit();
                        }
                        conn.close();
                    }
                }
                catch (SQLException e) {
                    throw new BeetlSQLException(1, e);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected void clean(boolean isUpdate, Connection conn, PreparedStatement ps) {
        this.clean(isUpdate, conn, ps, null);
    }

    protected void clean(Connection conn) {
        this.clean(true, conn, null, null);
    }

    private InterceptorContext callInterceptorAsBefore(String sqlId, String sql, boolean isUpdate, List<SQLParameter> jdbcParas, Map<String, Object> inputParas) {
        InterceptorContext ctx = new InterceptorContext(sqlId, sql, jdbcParas, inputParas, isUpdate);
        for (Interceptor in : this.sm.inters) {
            in.before(ctx);
        }
        return ctx;
    }

    private void callInterceptorAsAfter(InterceptorContext ctx, Object result) {
        if (this.sm.inters == null) {
            return;
        }
        if (!ctx.isUpdate()) {
            ctx.setResult(result);
        } else {
            ctx.setResult(result);
        }
        for (Interceptor in : this.sm.inters) {
            in.after(ctx);
        }
    }

    private void callInterceptorAsException(InterceptorContext ctx, Exception ex) {
        if (ctx == null) {
            return;
        }
        if (this.sm.inters == null) {
            return;
        }
        for (Interceptor in : this.sm.inters) {
            in.exception(ctx, ex);
        }
    }

    private Map<String, Object> getSQLReadyParas(List<Object> paras) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("_root", paras);
        return map;
    }

    public String getId() {
        return this.id;
    }

    private void setIdsParas(ClassDesc desc, Object obj, Map<String, Object> paras) {
        List<String> idAttrs = desc.getIdAttrs();
        if (idAttrs.size() == 1) {
            paras.put(idAttrs.get(0), obj);
        } else {
            Map<String, Object> map = desc.getIdMethods();
            for (int i = 0; i < idAttrs.size(); ++i) {
                String idCol = idAttrs.get(i);
                String idAttr = idAttrs.get(i);
                Method m = (Method)map.get(idAttr);
                try {
                    Object os = m.invoke(obj, new Object[0]);
                    paras.put(idAttr, os);
                    continue;
                }
                catch (Exception ex) {
                    throw new BeetlSQLException(14, "\u65e0\u6cd5\u8bbe\u7f6e\u590d\u5408\u4e3b\u952e:" + idCol, ex);
                }
            }
        }
    }

    private void addParaIfAssignId(Object obj) {
        if (obj instanceof Map) {
            return;
        }
        if (obj == null) {
            return;
        }
        SQLTableSource tableSource = (SQLTableSource)this.sqlSource;
        Class<?> clz = obj.getClass();
        if (tableSource.getIdType() == 1 && tableSource.getAssignIds() != null) {
            Map<String, AssignID> ids = tableSource.getAssignIds();
            for (Map.Entry<String, AssignID> entry : ids.entrySet()) {
                String attrName = entry.getKey();
                Object value = BeanKit.getBeanProperty(obj, attrName);
                if (!StringKit.isNullOrEmpty(value)) continue;
                AssignID assignId = entry.getValue();
                String algorithm = assignId.value();
                String param = assignId.param();
                Object o = this.sm.getAssignIdByIdAutonGen(algorithm, param, tableSource.getTableDesc().getName());
                BeanKit.setBeanProperty(obj, o, attrName);
            }
        }
    }

    private List<SQLParameter> toSQLParameters(Object[] args) {
        ArrayList<SQLParameter> paras = new ArrayList<SQLParameter>(args.length);
        for (Object arg : args) {
            paras.add(new SQLParameter(arg));
        }
        return paras;
    }

    public String getSql() {
        return this.sql;
    }
}

