/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.ext.spring4;

import org.beetl.sql.ext.spring4.BeetlSqlClassPathScanner;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class BeetlSqlScannerConfigurer
implements BeanDefinitionRegistryPostProcessor,
InitializingBean,
ApplicationContextAware,
BeanNameAware {
    String basePackage;
    String daoSuffix = "Dao";
    ApplicationContext applicationContext;
    String beanName;
    BeanNameGenerator nameGenerator;
    String sqlManagerFactoryBeanName;

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        String basePackage2 = this.applicationContext.getEnvironment().resolvePlaceholders(this.basePackage);
        String[] packages = StringUtils.tokenizeToStringArray((String)basePackage2, (String)",; \t\n");
        BeetlSqlClassPathScanner scanner = new BeetlSqlClassPathScanner(registry);
        scanner.setSuffix(this.daoSuffix);
        scanner.setResourceLoader((ResourceLoader)this.applicationContext);
        scanner.setBeanNameGenerator(this.nameGenerator);
        scanner.setSqlManagerFactoryBeanName(this.sqlManagerFactoryBeanName);
        scanner.registerFilters();
        scanner.doScan(packages);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) throws BeansException {
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.basePackage, (String)" 'basePackage' \u5c5e\u6027\u5fc5\u987b\u914d\u7f6e");
    }

    public BeanNameGenerator getNameGenerator() {
        return this.nameGenerator;
    }

    public void setNameGenerator(BeanNameGenerator nameGenerator) {
        this.nameGenerator = nameGenerator;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setSqlManagerFactoryBeanName(String sqlManagerFactoryBeanName) {
        this.sqlManagerFactoryBeanName = sqlManagerFactoryBeanName;
    }

    public String getDaoSuffix() {
        return this.daoSuffix;
    }

    public void setDaoSuffix(String daoSuffix) {
        this.daoSuffix = daoSuffix;
    }
}

