/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.gen;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.beetl.sql.clazz.ColDesc;
import org.beetl.sql.clazz.TableDesc;
import org.beetl.sql.clazz.kit.CaseInsensitiveHashMap;
import org.beetl.sql.clazz.kit.JavaType;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.meta.MetadataManager;
import org.beetl.sql.gen.Attribute;
import org.beetl.sql.gen.BaseProject;
import org.beetl.sql.gen.Entity;
import org.beetl.sql.gen.PackageList;
import org.beetl.sql.gen.SourceBuilder;
import org.beetl.sql.gen.SourceFilter;
import org.beetl.sql.gen.simple.EntitySourceBuilder;
import org.beetl.sql.gen.simple.MDSourceBuilder;
import org.beetl.sql.gen.simple.MapperSourceBuilder;

public class SourceConfig {
    protected List<SourceBuilder> sourceBuilder = new ArrayList<SourceBuilder>();
    protected int spaceCount = 4;
    protected PreferDoubleType preferDoubleType = PreferDoubleType.BigDecimal;
    protected PreferDateType preferDateType = PreferDateType.Date;
    protected boolean ignoreDbCatalog = true;
    protected Properties properties = new Properties();
    private String encoding = "UTF-8";
    SQLManager sqlManager;
    SourceBuilder entityBuilder = new EntitySourceBuilder();
    SourceBuilder mapperBuilder = new MapperSourceBuilder();
    SourceBuilder mdBuilder = new MDSourceBuilder();

    public SourceConfig(SQLManager sqlManager, boolean addDefault) {
        this.sqlManager = sqlManager;
        if (addDefault) {
            this.addDefault();
        }
    }

    public SourceConfig(SQLManager sqlManager, List<SourceBuilder> sourceBuilder) {
        this(sqlManager, false);
        this.sourceBuilder = sourceBuilder;
    }

    public SourceConfig(SQLManager sqlManager, List<SourceBuilder> sourceBuilder, PreferDoubleType preferDoubleType, PreferDateType preferDateType) {
        this(sqlManager, sourceBuilder);
        this.preferDoubleType = preferDoubleType;
        this.preferDateType = preferDateType;
    }

    public void addDefault() {
        this.sourceBuilder.add(this.entityBuilder);
        this.sourceBuilder.add(this.mapperBuilder);
        this.sourceBuilder.add(this.mdBuilder);
    }

    public void removeEntityBuilder() {
        this.sourceBuilder.remove(this.entityBuilder);
    }

    public void removeMapperBuilder() {
        this.sourceBuilder.remove(this.mapperBuilder);
    }

    public void removeMdBuilder() {
        this.sourceBuilder.remove(this.mdBuilder);
    }

    public void addSourceBuilder(SourceBuilder builder) {
        this.sourceBuilder.add(builder);
    }

    public void gen(String tableName, BaseProject project) {
        TableDesc tableDesc = this.sqlManager.getMetaDataManager().getTable(tableName);
        PackageList packageList = new PackageList();
        Entity entity = this.toEntity(tableDesc, packageList);
        entity.setTableDesc(tableDesc);
        entity.setImportPackage(packageList.getPkgs());
        for (SourceBuilder sourceBuilder : this.sourceBuilder) {
            if (!sourceBuilder.isSupport(this, entity)) continue;
            sourceBuilder.generate(project, this, entity);
        }
    }

    public void genAll(BaseProject project, SourceFilter sourceFilter) {
        MetadataManager metadataManager = this.sqlManager.getMetaDataManager();
        TreeSet tables = new TreeSet();
        tables.addAll(metadataManager.allTable());
        tables.forEach(tableName -> {
            if (sourceFilter != null && !sourceFilter.accept(metadataManager, (String)tableName)) {
                return;
            }
            this.gen((String)tableName, project);
        });
    }

    public void genAll(BaseProject project) {
        this.genAll(project, null);
    }

    protected Entity toEntity(TableDesc tableDesc, PackageList packageList) {
        Entity entity = new Entity();
        entity.setComment(tableDesc.getRemark());
        entity.setCatalog(tableDesc.getCatalog());
        entity.setTableName(tableDesc.getName());
        entity.setName(this.sqlManager.getNc().getClassName(tableDesc.getName()));
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        CaseInsensitiveHashMap cols = tableDesc.getColsDetail();
        for (Map.Entry colInfo : cols.entrySet()) {
            ColDesc colDesc = (ColDesc)colInfo.getValue();
            Attribute attribute = this.toAttribute(tableDesc, colDesc, packageList);
            list.add(attribute);
        }
        entity.setList(list);
        return entity;
    }

    protected Attribute toAttribute(TableDesc tableDesc, ColDesc colDesc, PackageList packageList) {
        Attribute attribute = new Attribute();
        attribute.setAuto(colDesc.isAuto());
        attribute.setColName(colDesc.getColName());
        attribute.setComment(colDesc.getRemark());
        String javaType = (String)JavaType.mapping.get(colDesc.getSqlType());
        attribute.setJavaType(javaType);
        attribute.setName(this.sqlManager.getNc().getPropertyName(colDesc.getColName()));
        attribute.setJavaType(this.getJavaType(colDesc, packageList));
        if (tableDesc.getIdNames().contains(colDesc.getColName())) {
            attribute.setId(true);
        }
        return attribute;
    }

    protected String getJavaType(ColDesc desc, PackageList packageList) {
        int jdbcType = desc.getSqlType();
        if (JavaType.isDateType((Integer)jdbcType)) {
            if (this.preferDateType == PreferDateType.Date) {
                packageList.getPkgs().add("java.util.Date");
                return "Date";
            }
            if (this.preferDateType == PreferDateType.LocalDate) {
                boolean isTime = JavaType.isDateTimeType((Integer)jdbcType);
                if (isTime) {
                    packageList.getPkgs().add("java.times.LocalDateTime");
                    return "LocalDateTime";
                }
                packageList.getPkgs().add("java.times.LocalDate");
                return "LocalDate";
            }
            packageList.getPkgs().add("java.sql.Timestamp");
            return "Timestamp";
        }
        String type = JavaType.getType((Integer)desc.getSqlType(), (Integer)desc.getSize(), (Integer)desc.getDigit());
        if (this.preferDoubleType == PreferDoubleType.BigDecimal && type.equals("Double")) {
            packageList.getPkgs().add("java.math.BigDecimal");
            type = "BigDecimal";
        }
        return type;
    }

    public List<SourceBuilder> getSourceBuilder() {
        return this.sourceBuilder;
    }

    public int getSpaceCount() {
        return this.spaceCount;
    }

    public PreferDoubleType getPreferDoubleType() {
        return this.preferDoubleType;
    }

    public PreferDateType getPreferDateType() {
        return this.preferDateType;
    }

    public boolean isIgnoreDbCatalog() {
        return this.ignoreDbCatalog;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public SQLManager getSqlManager() {
        return this.sqlManager;
    }

    public SourceBuilder getEntityBuilder() {
        return this.entityBuilder;
    }

    public SourceBuilder getMapperBuilder() {
        return this.mapperBuilder;
    }

    public SourceBuilder getMdBuilder() {
        return this.mdBuilder;
    }

    public void setSourceBuilder(List<SourceBuilder> sourceBuilder) {
        this.sourceBuilder = sourceBuilder;
    }

    public void setSpaceCount(int spaceCount) {
        this.spaceCount = spaceCount;
    }

    public void setPreferDoubleType(PreferDoubleType preferDoubleType) {
        this.preferDoubleType = preferDoubleType;
    }

    public void setPreferDateType(PreferDateType preferDateType) {
        this.preferDateType = preferDateType;
    }

    public void setIgnoreDbCatalog(boolean ignoreDbCatalog) {
        this.ignoreDbCatalog = ignoreDbCatalog;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setSqlManager(SQLManager sqlManager) {
        this.sqlManager = sqlManager;
    }

    public void setEntityBuilder(SourceBuilder entityBuilder) {
        this.entityBuilder = entityBuilder;
    }

    public void setMapperBuilder(SourceBuilder mapperBuilder) {
        this.mapperBuilder = mapperBuilder;
    }

    public void setMdBuilder(SourceBuilder mdBuilder) {
        this.mdBuilder = mdBuilder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SourceConfig)) {
            return false;
        }
        SourceConfig other = (SourceConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<SourceBuilder> this$sourceBuilder = this.getSourceBuilder();
        List<SourceBuilder> other$sourceBuilder = other.getSourceBuilder();
        if (this$sourceBuilder == null ? other$sourceBuilder != null : !((Object)this$sourceBuilder).equals(other$sourceBuilder)) {
            return false;
        }
        if (this.getSpaceCount() != other.getSpaceCount()) {
            return false;
        }
        PreferDoubleType this$preferDoubleType = this.getPreferDoubleType();
        PreferDoubleType other$preferDoubleType = other.getPreferDoubleType();
        if (this$preferDoubleType == null ? other$preferDoubleType != null : !((Object)((Object)this$preferDoubleType)).equals((Object)other$preferDoubleType)) {
            return false;
        }
        PreferDateType this$preferDateType = this.getPreferDateType();
        PreferDateType other$preferDateType = other.getPreferDateType();
        if (this$preferDateType == null ? other$preferDateType != null : !((Object)((Object)this$preferDateType)).equals((Object)other$preferDateType)) {
            return false;
        }
        if (this.isIgnoreDbCatalog() != other.isIgnoreDbCatalog()) {
            return false;
        }
        Properties this$properties = this.getProperties();
        Properties other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        String this$encoding = this.getEncoding();
        String other$encoding = other.getEncoding();
        if (this$encoding == null ? other$encoding != null : !this$encoding.equals(other$encoding)) {
            return false;
        }
        SQLManager this$sqlManager = this.getSqlManager();
        SQLManager other$sqlManager = other.getSqlManager();
        if (this$sqlManager == null ? other$sqlManager != null : !this$sqlManager.equals(other$sqlManager)) {
            return false;
        }
        SourceBuilder this$entityBuilder = this.getEntityBuilder();
        SourceBuilder other$entityBuilder = other.getEntityBuilder();
        if (this$entityBuilder == null ? other$entityBuilder != null : !this$entityBuilder.equals(other$entityBuilder)) {
            return false;
        }
        SourceBuilder this$mapperBuilder = this.getMapperBuilder();
        SourceBuilder other$mapperBuilder = other.getMapperBuilder();
        if (this$mapperBuilder == null ? other$mapperBuilder != null : !this$mapperBuilder.equals(other$mapperBuilder)) {
            return false;
        }
        SourceBuilder this$mdBuilder = this.getMdBuilder();
        SourceBuilder other$mdBuilder = other.getMdBuilder();
        return !(this$mdBuilder == null ? other$mdBuilder != null : !this$mdBuilder.equals(other$mdBuilder));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SourceConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<SourceBuilder> $sourceBuilder = this.getSourceBuilder();
        result = result * 59 + ($sourceBuilder == null ? 43 : ((Object)$sourceBuilder).hashCode());
        result = result * 59 + this.getSpaceCount();
        PreferDoubleType $preferDoubleType = this.getPreferDoubleType();
        result = result * 59 + ($preferDoubleType == null ? 43 : ((Object)((Object)$preferDoubleType)).hashCode());
        PreferDateType $preferDateType = this.getPreferDateType();
        result = result * 59 + ($preferDateType == null ? 43 : ((Object)((Object)$preferDateType)).hashCode());
        result = result * 59 + (this.isIgnoreDbCatalog() ? 79 : 97);
        Properties $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        String $encoding = this.getEncoding();
        result = result * 59 + ($encoding == null ? 43 : $encoding.hashCode());
        SQLManager $sqlManager = this.getSqlManager();
        result = result * 59 + ($sqlManager == null ? 43 : $sqlManager.hashCode());
        SourceBuilder $entityBuilder = this.getEntityBuilder();
        result = result * 59 + ($entityBuilder == null ? 43 : $entityBuilder.hashCode());
        SourceBuilder $mapperBuilder = this.getMapperBuilder();
        result = result * 59 + ($mapperBuilder == null ? 43 : $mapperBuilder.hashCode());
        SourceBuilder $mdBuilder = this.getMdBuilder();
        result = result * 59 + ($mdBuilder == null ? 43 : $mdBuilder.hashCode());
        return result;
    }

    public String toString() {
        return "SourceConfig(sourceBuilder=" + this.getSourceBuilder() + ", spaceCount=" + this.getSpaceCount() + ", preferDoubleType=" + (Object)((Object)this.getPreferDoubleType()) + ", preferDateType=" + (Object)((Object)this.getPreferDateType()) + ", ignoreDbCatalog=" + this.isIgnoreDbCatalog() + ", properties=" + this.getProperties() + ", encoding=" + this.getEncoding() + ", sqlManager=" + this.getSqlManager() + ", entityBuilder=" + this.getEntityBuilder() + ", mapperBuilder=" + this.getMapperBuilder() + ", mdBuilder=" + this.getMdBuilder() + ")";
    }

    public static enum PreferDoubleType {
        Double,
        BigDecimal;

    }

    public static enum PreferDateType {
        Date,
        Timestamp,
        LocalDate;

    }
}

