/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.jwt.rsa;

import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Base64;
import java.util.Objects;

public class PEMUtils {
    public static final String PKCS_1_PRIVATE_KEY_PREFIX = "-----BEGIN RSA PRIVATE KEY-----";
    public static final String PKCS_1_PRIVATE_KEY_SUFFIX = "-----END RSA PRIVATE KEY-----";
    public static final String PKCS_1_PUBLIC_KEY_PREFIX = "-----BEGIN RSA PUBLIC KEY-----";
    public static final String PKCS_1_PUBLIC_KEY_SUFFIX = "-----END RSA PUBLIC KEY-----";
    public static final String PKCS_8_PRIVATE_KEY_PREFIX = "-----BEGIN PRIVATE KEY-----";
    public static final String PKCS_8_PRIVATE_KEY_SUFFIX = "-----END PRIVATE KEY-----";
    public static final String X509_CERTIFICATE_PREFIX = "-----BEGIN CERTIFICATE-----";
    public static final String X509_CERTIFICATE_SUFFIX = "-----END CERTIFICATE-----";
    public static final String X509_PUBLIC_KEY_PREFIX = "-----BEGIN PUBLIC KEY-----";
    public static final String X509_PUBLIC_KEY_SUFFIX = "-----END PUBLIC KEY-----";
    private static final Base64.Encoder PEM_ENCODER = Base64.getMimeEncoder(64, new byte[]{10});

    public static String decodeCertificate(String pemEncodedString) {
        int startIndex = pemEncodedString.indexOf(X509_CERTIFICATE_PREFIX);
        int endIndex = pemEncodedString.indexOf(X509_CERTIFICATE_SUFFIX);
        if (startIndex == -1 || endIndex == -1) {
            throw new InvalidParameterException("Unexpected Certificate Format");
        }
        return pemEncodedString.substring(startIndex + X509_CERTIFICATE_PREFIX.length(), endIndex).replaceAll("\\s", "");
    }

    public static String encodeCertificate(String encodedCertificate) {
        StringBuilder sb = new StringBuilder(X509_CERTIFICATE_PREFIX).append("\n");
        for (int index = 0; index < encodedCertificate.length(); index += 64) {
            sb.append(encodedCertificate.substring(index, Math.min(index + 64, encodedCertificate.length()))).append("\n");
        }
        return sb.append(X509_CERTIFICATE_SUFFIX).toString();
    }

    public static String encodePrivateKey(PrivateKey privateKey) {
        Objects.requireNonNull(privateKey);
        if (!privateKey.getAlgorithm().equals("RSA")) {
            throw new IllegalStateException("Only RSA keys are currently supported.");
        }
        if (privateKey.getFormat().equals("PKCS#8")) {
            return "-----BEGIN PRIVATE KEY-----\n" + PEM_ENCODER.encodeToString(privateKey.getEncoded()) + "\n" + PKCS_8_PRIVATE_KEY_SUFFIX;
        }
        throw new IllegalStateException("Only RSA PKCS#8 keys are currently supported. Provided key format [" + privateKey.getFormat() + "]");
    }

    public static String encodePublicKey(PublicKey publicKey) {
        Objects.requireNonNull(publicKey);
        if (!publicKey.getAlgorithm().equals("RSA")) {
            throw new IllegalStateException("Only RSA keys are currently supported.");
        }
        if (publicKey.getFormat().equals("X.509")) {
            return "-----BEGIN PUBLIC KEY-----\n" + PEM_ENCODER.encodeToString(publicKey.getEncoded()) + "\n" + X509_PUBLIC_KEY_SUFFIX;
        }
        throw new IllegalStateException("Only RSA PKCS#8 keys are currently supported. Provided key format [" + publicKey.getFormat() + "]");
    }
}

