/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.form.renderer;

import com.itextpdf.forms.form.element.AbstractSelectField;
import com.itextpdf.forms.form.element.IFormField;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.layout.element.IElement;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.layout.renderer.BlockRenderer;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.IRenderer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSelectFieldRenderer
extends BlockRenderer {
    protected AbstractSelectFieldRenderer(AbstractSelectField modelElement) {
        super((IElement)modelElement);
        this.addChild(this.createFlatRenderer());
        if (!this.isFlatten()) {
            Logger logger = LoggerFactory.getLogger(AbstractSelectFieldRenderer.class);
            logger.warn("AcroForm fields creation for select fields (ComboBoxField and ListBoxField) is not supported. They will be flattened instead.");
            this.setProperty(0x200001, Boolean.TRUE);
        }
    }

    public LayoutResult layout(LayoutContext layoutContext) {
        Float width = this.retrieveWidth(layoutContext.getArea().getBBox().getWidth());
        if (width != null) {
            this.updateWidth(UnitValue.createPointValue((float)width.floatValue()));
        }
        float childrenMaxWidth = this.getMinMaxWidth().getMaxWidth();
        LayoutArea area = layoutContext.getArea().clone();
        area.getBBox().moveDown(1000000.0f - area.getBBox().getHeight()).setHeight(1000000.0f).setWidth(childrenMaxWidth + 1.0E-4f);
        LayoutResult layoutResult = super.layout(new LayoutContext(area, layoutContext.getMarginsCollapseInfo(), layoutContext.getFloatRendererAreas(), layoutContext.isClippedHeight()));
        if (layoutResult.getStatus() != 1) {
            if (Boolean.TRUE.equals(this.getPropertyAsBoolean(26))) {
                layoutResult = this.makeLayoutResultFull(layoutContext.getArea(), layoutResult);
            } else {
                return new LayoutResult(3, null, null, (IRenderer)this, (IRenderer)this);
            }
        }
        float availableHeight = layoutContext.getArea().getBBox().getHeight();
        boolean isClippedHeight = layoutContext.isClippedHeight();
        Rectangle dummy = new Rectangle(0.0f, 0.0f);
        this.applyMargins(dummy, true);
        this.applyBorderBox(dummy, true);
        this.applyPaddings(dummy, true);
        float additionalHeight = dummy.getHeight();
        availableHeight -= additionalHeight;
        availableHeight = Math.max(availableHeight, 0.0f);
        float actualHeight = this.getOccupiedArea().getBBox().getHeight() - additionalHeight;
        float finalSelectFieldHeight = this.getFinalSelectFieldHeight(availableHeight, actualHeight, isClippedHeight);
        if (finalSelectFieldHeight < 0.0f) {
            return new LayoutResult(3, null, null, (IRenderer)this, (IRenderer)this);
        }
        float delta = finalSelectFieldHeight - actualHeight;
        if (Math.abs(delta) > 1.0E-4f) {
            this.getOccupiedArea().getBBox().increaseHeight(delta).moveDown(delta);
        }
        return layoutResult;
    }

    public void drawChildren(DrawContext drawContext) {
        if (this.isFlatten()) {
            super.drawChildren(drawContext);
        } else {
            this.applyAcroField(drawContext);
        }
    }

    protected String getLang() {
        return (String)this.getProperty(0x20000B);
    }

    protected abstract IRenderer createFlatRenderer();

    protected abstract void applyAcroField(DrawContext var1);

    protected boolean isFlatten() {
        return this.getPropertyAsBoolean(0x200001);
    }

    protected String getModelId() {
        return ((IFormField)this.getModelElement()).getId();
    }

    protected float getFinalSelectFieldHeight(float availableHeight, float actualHeight, boolean isClippedHeight) {
        boolean isForcedPlacement = Boolean.TRUE.equals(this.getPropertyAsBoolean(26));
        if (!isClippedHeight && actualHeight > availableHeight) {
            if (isForcedPlacement) {
                return availableHeight;
            }
            return -1.0f;
        }
        return actualHeight;
    }

    protected List<IRenderer> getOptionsMarkedSelected(IRenderer optionsSubTree) {
        ArrayList<IRenderer> selectedOptions = new ArrayList<IRenderer>();
        for (IRenderer option : optionsSubTree.getChildRenderers()) {
            if (AbstractSelectFieldRenderer.isOptionRenderer(option)) {
                if (!Boolean.TRUE.equals(option.getProperty(0x200009))) continue;
                selectedOptions.add(option);
                continue;
            }
            List<IRenderer> subSelectedOptions = this.getOptionsMarkedSelected(option);
            selectedOptions.addAll(subSelectedOptions);
        }
        return selectedOptions;
    }

    private LayoutResult makeLayoutResultFull(LayoutArea layoutArea, LayoutResult layoutResult) {
        AbstractSelectFieldRenderer splitRenderer;
        AbstractSelectFieldRenderer abstractSelectFieldRenderer = splitRenderer = layoutResult.getSplitRenderer() == null ? this : layoutResult.getSplitRenderer();
        if (this.occupiedArea == null) {
            this.occupiedArea = new LayoutArea(layoutArea.getPageNumber(), new Rectangle(layoutArea.getBBox().getLeft(), layoutArea.getBBox().getTop(), 0.0f, 0.0f));
        }
        layoutResult = new LayoutResult(1, this.occupiedArea, (IRenderer)splitRenderer, null);
        return layoutResult;
    }

    static boolean isOptGroupRenderer(IRenderer renderer) {
        return renderer.hasProperty(0x20000A) && !renderer.hasProperty(0x200009);
    }

    static boolean isOptionRenderer(IRenderer child) {
        return child.hasProperty(0x200009);
    }
}

