/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font.otf;

import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.font.otf.GposLookupType1;
import com.itextpdf.io.font.otf.GposLookupType2;
import com.itextpdf.io.font.otf.GposLookupType4;
import com.itextpdf.io.font.otf.GposLookupType5;
import com.itextpdf.io.font.otf.GposLookupType6;
import com.itextpdf.io.font.otf.GposLookupType7;
import com.itextpdf.io.font.otf.OpenTableLookup;
import com.itextpdf.io.font.otf.OpenTypeFontTableReader;
import com.itextpdf.io.font.otf.OpenTypeGdefTableReader;
import com.itextpdf.io.source.RandomAccessFileOrArray;
import java.io.IOException;
import java.util.Map;

public class GlyphPositioningTableReader
extends OpenTypeFontTableReader {
    private static final long serialVersionUID = 7437245788115628787L;

    public GlyphPositioningTableReader(RandomAccessFileOrArray rf, int gposTableLocation, OpenTypeGdefTableReader gdef, Map<Integer, Glyph> indexGlyphMap, int unitsPerEm) throws IOException {
        super(rf, gposTableLocation, gdef, indexGlyphMap, unitsPerEm);
        this.startReadingTable();
    }

    @Override
    protected OpenTableLookup readLookupTable(int lookupType, int lookupFlag, int[] subTableLocations) throws IOException {
        if (lookupType == 9) {
            for (int k = 0; k < subTableLocations.length; ++k) {
                int location = subTableLocations[k];
                this.rf.seek(location);
                this.rf.readUnsignedShort();
                lookupType = this.rf.readUnsignedShort();
                subTableLocations[k] = location += this.rf.readInt();
            }
        }
        switch (lookupType) {
            case 1: {
                return new GposLookupType1(this, lookupFlag, subTableLocations);
            }
            case 2: {
                return new GposLookupType2(this, lookupFlag, subTableLocations);
            }
            case 4: {
                return new GposLookupType4(this, lookupFlag, subTableLocations);
            }
            case 5: {
                return new GposLookupType5(this, lookupFlag, subTableLocations);
            }
            case 6: {
                return new GposLookupType6(this, lookupFlag, subTableLocations);
            }
            case 7: {
                return new GposLookupType7(this, lookupFlag, subTableLocations);
            }
        }
        return null;
    }
}

