/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.tagging;

import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.tagging.PdfMcr;
import com.itextpdf.kernel.pdf.tagging.PdfStructElem;

public class PdfMcrDictionary
extends PdfMcr {
    private static final long serialVersionUID = 3562443854685749324L;

    public PdfMcrDictionary(PdfDictionary pdfObject, PdfStructElem parent) {
        super(pdfObject, parent);
    }

    public PdfMcrDictionary(PdfPage page, PdfStructElem parent) {
        super(new PdfDictionary(), parent);
        PdfDictionary dict = (PdfDictionary)this.getPdfObject();
        dict.put(PdfName.Type, PdfName.MCR);
        dict.put(PdfName.Pg, ((PdfDictionary)page.getPdfObject()).getIndirectReference());
        dict.put(PdfName.MCID, new PdfNumber(page.getNextMcid()));
    }

    @Override
    public int getMcid() {
        PdfNumber mcidNumber = ((PdfDictionary)this.getPdfObject()).getAsNumber(PdfName.MCID);
        return mcidNumber != null ? mcidNumber.intValue() : -1;
    }

    @Override
    public PdfDictionary getPageObject() {
        PdfDictionary page = ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.Pg);
        if (page == null) {
            page = ((PdfDictionary)this.parent.getPdfObject()).getAsDictionary(PdfName.Pg);
        }
        return page;
    }
}

