/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.element.Div;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.margincollapse.MarginsCollapseHandler;
import com.itextpdf.layout.margincollapse.MarginsCollapseInfo;
import com.itextpdf.layout.minmaxwidth.MinMaxWidth;
import com.itextpdf.layout.minmaxwidth.MinMaxWidthUtils;
import com.itextpdf.layout.properties.AlignmentPropertyValue;
import com.itextpdf.layout.properties.BaseDirection;
import com.itextpdf.layout.properties.FlexDirectionPropertyValue;
import com.itextpdf.layout.properties.FlexWrapPropertyValue;
import com.itextpdf.layout.properties.OverflowPropertyValue;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.layout.renderer.AbstractRenderer;
import com.itextpdf.layout.renderer.AbstractWidthHandler;
import com.itextpdf.layout.renderer.BottomToTopFlexItemMainDirector;
import com.itextpdf.layout.renderer.DivRenderer;
import com.itextpdf.layout.renderer.FlexItemInfo;
import com.itextpdf.layout.renderer.FlexUtil;
import com.itextpdf.layout.renderer.IFlexItemMainDirector;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.LtrFlexItemMainDirector;
import com.itextpdf.layout.renderer.MaxMaxWidthHandler;
import com.itextpdf.layout.renderer.RotationUtils;
import com.itextpdf.layout.renderer.RtlFlexItemMainDirector;
import com.itextpdf.layout.renderer.TopToBottomFlexItemMainDirector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FlexContainerRenderer
extends DivRenderer {
    private final Map<Float, Float> hypotheticalCrossSizes = new HashMap<Float, Float>();
    private List<List<FlexItemInfo>> lines;
    private IFlexItemMainDirector flexItemMainDirector = null;

    public FlexContainerRenderer(Div modelElement) {
        super(modelElement);
    }

    @Override
    public IRenderer getNextRenderer() {
        this.logWarningIfGetNextRendererNotOverridden(FlexContainerRenderer.class, this.getClass());
        return new FlexContainerRenderer((Div)this.modelElement);
    }

    @Override
    public LayoutResult layout(LayoutContext layoutContext) {
        Rectangle layoutContextRectangle = layoutContext.getArea().getBBox();
        this.setThisAsParent(this.getChildRenderers());
        this.lines = FlexUtil.calculateChildrenRectangles(layoutContextRectangle, this);
        this.applyWrapReverse();
        List<IRenderer> renderers = this.getFlexItemMainDirector().applyDirection(this.lines);
        this.removeAllChildRenderers(this.getChildRenderers());
        this.addAllChildRenderers(renderers);
        List<IRenderer> renderersToOverflow = this.retrieveRenderersToOverflow(layoutContextRectangle);
        ArrayList previousWidths = new ArrayList();
        ArrayList previousHeights = new ArrayList();
        ArrayList previousMinHeights = new ArrayList();
        for (List<FlexItemInfo> line : this.lines) {
            for (FlexItemInfo flexItemInfo : line) {
                Rectangle rectangleWithoutBordersMarginsPaddings = AbstractRenderer.isBorderBoxSizing(flexItemInfo.getRenderer()) ? flexItemInfo.getRenderer().applyMargins(flexItemInfo.getRectangle().clone(), false) : flexItemInfo.getRenderer().applyMarginsBordersPaddings(flexItemInfo.getRectangle().clone(), false);
                previousWidths.add(flexItemInfo.getRenderer().getProperty(77));
                previousHeights.add(flexItemInfo.getRenderer().getProperty(27));
                previousMinHeights.add(flexItemInfo.getRenderer().getProperty(85));
                flexItemInfo.getRenderer().setProperty(77, UnitValue.createPointValue(rectangleWithoutBordersMarginsPaddings.getWidth()));
                flexItemInfo.getRenderer().setProperty(27, UnitValue.createPointValue(rectangleWithoutBordersMarginsPaddings.getHeight()));
                flexItemInfo.getRenderer().setProperty(85, UnitValue.createPointValue(rectangleWithoutBordersMarginsPaddings.getHeight()));
                flexItemInfo.getRenderer().setProperty(28, null);
            }
        }
        LayoutResult result = super.layout(layoutContext);
        if (!renderersToOverflow.isEmpty()) {
            this.adjustLayoutResultToHandleOverflowRenderers(result, renderersToOverflow);
        }
        int counter = 0;
        for (List list : this.lines) {
            for (FlexItemInfo itemInfo : list) {
                itemInfo.getRenderer().setProperty(77, previousWidths.get(counter));
                itemInfo.getRenderer().setProperty(27, previousHeights.get(counter));
                itemInfo.getRenderer().setProperty(85, previousMinHeights.get(counter));
                ++counter;
            }
        }
        return result;
    }

    @Override
    public MinMaxWidth getMinMaxWidth() {
        MinMaxWidth minMaxWidth = new MinMaxWidth(FlexContainerRenderer.calculateAdditionalWidth(this));
        MaxMaxWidthHandler minMaxWidthHandler = new MaxMaxWidthHandler(minMaxWidth);
        if (!this.setMinMaxWidthBasedOnFixedWidth(minMaxWidth)) {
            Float maxWidth;
            Float minWidth = this.hasAbsoluteUnitValue(80) ? this.retrieveMinWidth(0.0f) : null;
            Float f = maxWidth = this.hasAbsoluteUnitValue(79) ? this.retrieveMaxWidth(0.0f) : null;
            if (minWidth == null || maxWidth == null) {
                this.findMinMaxWidthIfCorrespondingPropertiesAreNotSet(minMaxWidth, minMaxWidthHandler);
            }
            if (minWidth != null) {
                minMaxWidth.setChildrenMinWidth(minWidth.floatValue());
            }
            if (maxWidth == null) {
                if (minMaxWidth.getChildrenMinWidth() > minMaxWidth.getChildrenMaxWidth()) {
                    minMaxWidth.setChildrenMaxWidth(minMaxWidth.getChildrenMinWidth());
                }
            } else {
                minMaxWidth.setChildrenMaxWidth(maxWidth.floatValue());
            }
        }
        if (this.getPropertyAsFloat(55) != null) {
            return RotationUtils.countRotationMinMaxWidth(minMaxWidth, this);
        }
        return minMaxWidth;
    }

    IFlexItemMainDirector getFlexItemMainDirector() {
        if (this.flexItemMainDirector == null) {
            this.flexItemMainDirector = this.createMainDirector();
        }
        return this.flexItemMainDirector;
    }

    boolean isWrapReverse() {
        return FlexWrapPropertyValue.WRAP_REVERSE == this.getProperty(128, null);
    }

    @Override
    AbstractRenderer[] createSplitAndOverflowRenderers(int childPos, int layoutStatus, LayoutResult childResult, Map<Integer, IRenderer> waitingFloatsSplitRenderers, List<IRenderer> waitingOverflowFloatRenderers) {
        AbstractRenderer splitRenderer = this.createSplitRenderer(layoutStatus);
        AbstractRenderer overflowRenderer = this.createOverflowRenderer(layoutStatus);
        IRenderer childRenderer = this.getChildRenderers().get(childPos);
        boolean forcedPlacement = Boolean.TRUE.equals(this.getProperty(26));
        boolean metChildRenderer = false;
        for (int i = 0; i < this.lines.size(); ++i) {
            List<FlexItemInfo> line = this.lines.get(i);
            boolean isSplitLine = line.stream().anyMatch(flexItem -> flexItem.getRenderer() == childRenderer);
            boolean bl = metChildRenderer = metChildRenderer || isSplitLine;
            if (isSplitLine && !forcedPlacement && layoutStatus == 2 && (!FlexUtil.isColumnDirection(this) || i == 0 && line.get(0).getRenderer() == childRenderer)) {
                this.fillSplitOverflowRenderersForPartialResult(splitRenderer, overflowRenderer, line, childRenderer, childResult);
                this.getFlexItemMainDirector().applyDirectionForLine(overflowRenderer.getChildRenderers());
                continue;
            }
            ArrayList<IRenderer> overflowRendererChildren = new ArrayList<IRenderer>();
            boolean isSingleColumn = this.lines.size() == 1 && FlexUtil.isColumnDirection(this);
            boolean metChildRendererInLine = false;
            for (FlexItemInfo itemInfo : line) {
                boolean bl2 = metChildRendererInLine = metChildRendererInLine || itemInfo.getRenderer() == childRenderer;
                if ((!isSingleColumn && metChildRenderer || metChildRendererInLine) && !forcedPlacement) {
                    overflowRendererChildren.add(itemInfo.getRenderer());
                    continue;
                }
                splitRenderer.addChildRenderer(itemInfo.getRenderer());
            }
            this.getFlexItemMainDirector().applyDirectionForLine(overflowRendererChildren);
            if (this.isWrapReverse()) {
                overflowRenderer.addAllChildRenderers(0, overflowRendererChildren);
                continue;
            }
            overflowRenderer.addAllChildRenderers(overflowRendererChildren);
        }
        overflowRenderer.deleteOwnProperty(26);
        return new AbstractRenderer[]{splitRenderer, overflowRenderer};
    }

    @Override
    LayoutResult processNotFullChildResult(LayoutContext layoutContext, Map<Integer, IRenderer> waitingFloatsSplitRenderers, List<IRenderer> waitingOverflowFloatRenderers, boolean wasHeightClipped, List<Rectangle> floatRendererAreas, boolean marginsCollapsingEnabled, float clearHeightCorrection, Border[] borders, UnitValue[] paddings, List<Rectangle> areas, int currentAreaPos, Rectangle layoutBox, Set<Rectangle> nonChildFloatingRendererAreas, IRenderer causeOfNothing, boolean anythingPlaced, int childPos, LayoutResult result) {
        boolean keepTogether = this.isKeepTogether(causeOfNothing);
        if (Boolean.TRUE.equals(this.getPropertyAsBoolean(26)) || wasHeightClipped) {
            AbstractRenderer splitRenderer;
            AbstractRenderer abstractRenderer = splitRenderer = keepTogether ? null : this.createSplitRenderer(result.getStatus());
            if (splitRenderer != null) {
                splitRenderer.setChildRenderers(this.getChildRenderers());
            }
            return new LayoutResult(1, this.getOccupiedAreaInCaseNothingWasWrappedWithFull(result, splitRenderer), splitRenderer, null, null);
        }
        AbstractRenderer[] splitAndOverflowRenderers = this.createSplitAndOverflowRenderers(childPos, result.getStatus(), result, waitingFloatsSplitRenderers, waitingOverflowFloatRenderers);
        AbstractRenderer splitRenderer = splitAndOverflowRenderers[0];
        AbstractRenderer overflowRenderer = splitAndOverflowRenderers[1];
        overflowRenderer.deleteOwnProperty(26);
        this.updateHeightsOnSplit(wasHeightClipped, splitRenderer, overflowRenderer);
        if (this.isRelativePosition() && !this.positionedRenderers.isEmpty()) {
            overflowRenderer.positionedRenderers = new ArrayList<IRenderer>(this.positionedRenderers);
        }
        if (keepTogether) {
            splitRenderer = null;
            overflowRenderer.setChildRenderers(this.getChildRenderers());
        }
        this.correctFixedLayout(layoutBox);
        this.applyAbsolutePositionIfNeeded(layoutContext);
        this.applyPaddings(this.occupiedArea.getBBox(), paddings, true);
        this.applyBorderBox(this.occupiedArea.getBBox(), borders, true);
        this.applyMargins(this.occupiedArea.getBBox(), true);
        if (splitRenderer == null || splitRenderer.getChildRenderers().isEmpty()) {
            return new LayoutResult(3, null, null, overflowRenderer, result.getCauseOfNothing()).setAreaBreak(result.getAreaBreak());
        }
        return new LayoutResult(2, layoutContext.getArea(), splitRenderer, overflowRenderer, null).setAreaBreak(result.getAreaBreak());
    }

    LayoutArea getOccupiedAreaInCaseNothingWasWrappedWithFull(LayoutResult result, IRenderer splitRenderer) {
        return null != result.getOccupiedArea() ? result.getOccupiedArea() : splitRenderer.getOccupiedArea();
    }

    @Override
    boolean stopLayoutingChildrenIfChildResultNotFull(LayoutResult returnResult) {
        return returnResult.getStatus() != 1;
    }

    @Override
    void recalculateOccupiedAreaAfterChildLayout(Rectangle resultBBox, Float blockMaxHeight) {
        Rectangle oldBBox = this.occupiedArea.getBBox().clone();
        Rectangle recalculatedRectangle = Rectangle.getCommonRectangle((Rectangle[])new Rectangle[]{this.occupiedArea.getBBox(), resultBBox});
        this.occupiedArea.getBBox().setY(recalculatedRectangle.getY());
        this.occupiedArea.getBBox().setHeight(recalculatedRectangle.getHeight());
        if (oldBBox.getTop() < this.occupiedArea.getBBox().getTop()) {
            this.occupiedArea.getBBox().decreaseHeight(this.occupiedArea.getBBox().getTop() - oldBBox.getTop());
        }
        if (null != blockMaxHeight && this.occupiedArea.getBBox().getHeight() > blockMaxHeight.floatValue()) {
            this.occupiedArea.getBBox().moveUp(this.occupiedArea.getBBox().getHeight() - blockMaxHeight.floatValue());
            this.occupiedArea.getBBox().setHeight(blockMaxHeight.floatValue());
        }
    }

    @Override
    MarginsCollapseInfo startChildMarginsHandling(IRenderer childRenderer, Rectangle layoutBox, MarginsCollapseHandler marginsCollapseHandler) {
        return marginsCollapseHandler.startChildMarginsHandling(null, layoutBox);
    }

    @Override
    void decreaseLayoutBoxAfterChildPlacement(Rectangle layoutBox, LayoutResult result, IRenderer childRenderer) {
        if (FlexUtil.isColumnDirection(this)) {
            this.decreaseLayoutBoxAfterChildPlacementColumnLayout(layoutBox, childRenderer);
        } else {
            this.decreaseLayoutBoxAfterChildPlacementRowLayout(layoutBox, result, childRenderer);
        }
    }

    void decreaseLayoutBoxAfterChildPlacementRowLayout(Rectangle layoutBox, LayoutResult result, IRenderer childRenderer) {
        layoutBox.decreaseWidth(result.getOccupiedArea().getBBox().getRight() - layoutBox.getLeft());
        layoutBox.setX(result.getOccupiedArea().getBBox().getRight());
        List<FlexItemInfo> line = this.findLine(childRenderer);
        boolean isLastInLine = childRenderer.equals(line.get(line.size() - 1).getRenderer());
        if (isLastInLine) {
            float minBottom = layoutBox.getTop();
            float minLeft = layoutBox.getLeft();
            float commonWidth = 0.0f;
            for (FlexItemInfo item : line) {
                minLeft = Math.min(minLeft, item.getRenderer().getOccupiedArea().getBBox().getLeft() - item.getRectangle().getLeft());
                minBottom = Math.min(minBottom, item.getRenderer().getOccupiedArea().getBBox().getBottom());
                commonWidth += item.getRectangle().getLeft() + item.getRenderer().getOccupiedArea().getBBox().getWidth();
            }
            layoutBox.setX(minLeft);
            layoutBox.increaseWidth(commonWidth);
            layoutBox.decreaseHeight(layoutBox.getTop() - minBottom);
        }
    }

    void decreaseLayoutBoxAfterChildPlacementColumnLayout(Rectangle layoutBox, IRenderer childRenderer) {
        FlexItemInfo childFlexItemInfo = this.findFlexItemInfo((AbstractRenderer)childRenderer);
        layoutBox.decreaseHeight(childFlexItemInfo.getRenderer().getOccupiedArea().getBBox().getHeight() + childFlexItemInfo.getRectangle().getY());
        List<FlexItemInfo> line = this.findLine(childRenderer);
        boolean isLastInLine = childRenderer.equals(line.get(line.size() - 1).getRenderer());
        if (isLastInLine) {
            float maxWidth = 0.0f;
            float commonHeight = 0.0f;
            for (FlexItemInfo item : line) {
                maxWidth = Math.max(maxWidth, item.getRenderer().getOccupiedArea().getBBox().getWidth() + item.getRectangle().getX());
                commonHeight += item.getRectangle().getY() + item.getRenderer().getOccupiedArea().getBBox().getHeight();
            }
            layoutBox.increaseHeight(commonHeight);
            layoutBox.decreaseWidth(maxWidth);
            layoutBox.moveRight(maxWidth);
        }
    }

    @Override
    Rectangle recalculateLayoutBoxBeforeChildLayout(Rectangle layoutBox, IRenderer childRenderer, Rectangle initialLayoutBox) {
        FlexItemInfo childFlexItemInfo;
        Rectangle layoutBoxCopy = layoutBox.clone();
        if (childRenderer instanceof AbstractRenderer && (childFlexItemInfo = this.findFlexItemInfo((AbstractRenderer)childRenderer)) != null) {
            layoutBoxCopy.decreaseWidth(childFlexItemInfo.getRectangle().getX());
            layoutBoxCopy.moveRight(childFlexItemInfo.getRectangle().getX());
            layoutBoxCopy.decreaseHeight(childFlexItemInfo.getRectangle().getY());
        }
        return layoutBoxCopy;
    }

    @Override
    void handleForcedPlacement(boolean anythingPlaced) {
    }

    void setHypotheticalCrossSize(Float mainSize, Float hypotheticalCrossSize) {
        this.hypotheticalCrossSizes.put(Float.valueOf(mainSize.floatValue()), hypotheticalCrossSize);
    }

    Float getHypotheticalCrossSize(Float mainSize) {
        return this.hypotheticalCrossSizes.get(Float.valueOf(mainSize.floatValue()));
    }

    private void applyWrapReverse() {
        if (!this.isWrapReverse()) {
            return;
        }
        Collections.reverse(this.lines);
        ArrayList<IRenderer> reorderedRendererList = new ArrayList<IRenderer>();
        for (List<FlexItemInfo> line : this.lines) {
            for (FlexItemInfo itemInfo : line) {
                reorderedRendererList.add(itemInfo.getRenderer());
            }
        }
        this.removeAllChildRenderers(this.getChildRenderers());
        this.addAllChildRenderers(reorderedRendererList);
    }

    private FlexItemInfo findFlexItemInfo(AbstractRenderer renderer) {
        for (List<FlexItemInfo> line : this.lines) {
            for (FlexItemInfo itemInfo : line) {
                if (!itemInfo.getRenderer().equals(renderer)) continue;
                return itemInfo;
            }
        }
        return null;
    }

    private List<FlexItemInfo> findLine(IRenderer renderer) {
        for (List<FlexItemInfo> line : this.lines) {
            for (FlexItemInfo itemInfo : line) {
                if (!itemInfo.getRenderer().equals(renderer)) continue;
                return line;
            }
        }
        return null;
    }

    @Override
    void fixOccupiedAreaIfOverflowedX(OverflowPropertyValue overflowX, Rectangle layoutBox) {
    }

    @Override
    public void addChild(IRenderer renderer) {
        renderer.setProperty(103, (Object)OverflowPropertyValue.VISIBLE);
        super.addChild(renderer);
    }

    private static void addSimulateDiv(AbstractRenderer overflowRenderer, float width) {
        DivRenderer fakeOverflowRenderer = new DivRenderer((Div)((Div)new Div().setMinWidth(width)).setMaxWidth(width));
        overflowRenderer.addChildRenderer(fakeOverflowRenderer);
    }

    private void fillSplitOverflowRenderersForPartialResult(AbstractRenderer splitRenderer, AbstractRenderer overflowRenderer, List<FlexItemInfo> line, IRenderer childRenderer, LayoutResult childResult) {
        float occupiedSpace = 0.0f;
        float maxHeightInLine = 0.0f;
        boolean metChildRendererInLine = false;
        for (FlexItemInfo itemInfo : line) {
            if (itemInfo.getRenderer() == childRenderer) {
                metChildRendererInLine = true;
                if (childResult.getSplitRenderer() != null) {
                    splitRenderer.addChildRenderer(childResult.getSplitRenderer());
                }
                if (childResult.getOverflowRenderer() != null) {
                    if (!FlexUtil.isColumnDirection(this)) {
                        childResult.getOverflowRenderer().setProperty(129, (Object)AlignmentPropertyValue.START);
                    }
                    overflowRenderer.addChildRenderer(childResult.getOverflowRenderer());
                }
                maxHeightInLine = Math.max(maxHeightInLine, itemInfo.getRectangle().getY() + itemInfo.getRenderer().getOccupiedAreaBBox().getHeight());
            } else if (metChildRendererInLine) {
                if (FlexUtil.isColumnDirection(this)) {
                    overflowRenderer.addChildRenderer(itemInfo.getRenderer());
                    continue;
                }
                Rectangle neighbourBbox = new Rectangle(this.getOccupiedAreaBBox().getX() + occupiedSpace, this.getOccupiedAreaBBox().getY(), itemInfo.getRectangle().getWidth(), maxHeightInLine - itemInfo.getRectangle().getY());
                LayoutResult neighbourLayoutResult = itemInfo.getRenderer().layout(new LayoutContext(new LayoutArea(childResult.getOccupiedArea().getPageNumber(), neighbourBbox)));
                if (neighbourLayoutResult.getStatus() == 2 && neighbourLayoutResult.getSplitRenderer() != null) {
                    splitRenderer.addChildRenderer(neighbourLayoutResult.getSplitRenderer());
                } else if (neighbourLayoutResult.getStatus() == 1) {
                    splitRenderer.addChildRenderer(itemInfo.getRenderer());
                }
                if (neighbourLayoutResult.getOverflowRenderer() != null) {
                    if (neighbourLayoutResult.getStatus() == 2) {
                        neighbourLayoutResult.getOverflowRenderer().setProperty(129, (Object)AlignmentPropertyValue.START);
                    }
                    overflowRenderer.addChildRenderer(neighbourLayoutResult.getOverflowRenderer());
                } else {
                    FlexContainerRenderer.addSimulateDiv(overflowRenderer, itemInfo.getRectangle().getWidth());
                }
            } else {
                splitRenderer.addChildRenderer(itemInfo.getRenderer());
                FlexContainerRenderer.addSimulateDiv(overflowRenderer, itemInfo.getRectangle().getWidth());
                maxHeightInLine = Math.max(maxHeightInLine, itemInfo.getRectangle().getY() + itemInfo.getRenderer().getOccupiedAreaBBox().getHeight());
            }
            occupiedSpace += itemInfo.getRectangle().getX() + itemInfo.getRectangle().getWidth();
        }
    }

    private void findMinMaxWidthIfCorrespondingPropertiesAreNotSet(MinMaxWidth minMaxWidth, AbstractWidthHandler minMaxWidthHandler) {
        float initialMinWidth = minMaxWidth.getChildrenMinWidth();
        float initialMaxWidth = minMaxWidth.getChildrenMaxWidth();
        if (this.lines == null || this.lines.size() == 1) {
            this.findMinMaxWidth(initialMinWidth, initialMaxWidth, minMaxWidthHandler, this.getChildRenderers());
        } else {
            for (List<FlexItemInfo> line : this.lines) {
                ArrayList<IRenderer> childRenderers = new ArrayList<IRenderer>();
                for (FlexItemInfo itemInfo : line) {
                    childRenderers.add(itemInfo.getRenderer());
                }
                this.findMinMaxWidth(initialMinWidth, initialMaxWidth, minMaxWidthHandler, childRenderers);
            }
        }
    }

    private void findMinMaxWidth(float initialMinWidth, float initialMaxWidth, AbstractWidthHandler minMaxWidthHandler, List<IRenderer> childRenderers) {
        float maxWidth = initialMaxWidth;
        float minWidth = initialMinWidth;
        for (IRenderer childRenderer : childRenderers) {
            childRenderer.setParent(this);
            MinMaxWidth childMinMaxWidth = childRenderer instanceof AbstractRenderer ? ((AbstractRenderer)childRenderer).getMinMaxWidth() : MinMaxWidthUtils.countDefaultMinMaxWidth(childRenderer);
            if (FlexUtil.isColumnDirection(this)) {
                maxWidth = Math.max(maxWidth, childMinMaxWidth.getMaxWidth());
                minWidth = Math.max(minWidth, childMinMaxWidth.getMinWidth());
                continue;
            }
            maxWidth += childMinMaxWidth.getMaxWidth();
            minWidth += childMinMaxWidth.getMinWidth();
        }
        minMaxWidthHandler.updateMaxChildWidth(maxWidth);
        minMaxWidthHandler.updateMinChildWidth(minWidth);
    }

    private boolean isRowReverse() {
        return FlexDirectionPropertyValue.ROW_REVERSE == this.getProperty(139, null);
    }

    private boolean isColumnReverse() {
        return FlexDirectionPropertyValue.COLUMN_REVERSE == this.getProperty(139, null);
    }

    private IFlexItemMainDirector createMainDirector() {
        if (FlexUtil.isColumnDirection(this)) {
            return this.isColumnReverse() ? new BottomToTopFlexItemMainDirector() : new TopToBottomFlexItemMainDirector();
        }
        boolean isRtlDirection = BaseDirection.RIGHT_TO_LEFT == this.getProperty(7, null);
        this.flexItemMainDirector = this.isRowReverse() ^ isRtlDirection ? new RtlFlexItemMainDirector() : new LtrFlexItemMainDirector();
        return this.flexItemMainDirector;
    }

    private List<IRenderer> retrieveRenderersToOverflow(Rectangle flexContainerBBox) {
        ArrayList<IRenderer> renderersToOverflow = new ArrayList<IRenderer>();
        Rectangle layoutContextRectangle = flexContainerBBox.clone();
        this.applyMarginsBordersPaddings(layoutContextRectangle, false);
        if (FlexUtil.isColumnDirection(this) && FlexUtil.getMainSize(this, layoutContextRectangle) >= layoutContextRectangle.getHeight()) {
            float commonLineCrossSize = 0.0f;
            List<Float> lineCrossSizes = FlexUtil.calculateColumnDirectionCrossSizes(this.lines);
            for (int i = 0; i < this.lines.size(); ++i) {
                commonLineCrossSize += lineCrossSizes.get(i).floatValue();
                if (i <= 0 || !(commonLineCrossSize > layoutContextRectangle.getWidth())) continue;
                ArrayList<AbstractRenderer> lineRenderersToOverflow = new ArrayList<AbstractRenderer>();
                for (FlexItemInfo itemInfo : this.lines.get(i)) {
                    lineRenderersToOverflow.add(itemInfo.getRenderer());
                }
                this.getFlexItemMainDirector().applyDirectionForLine(lineRenderersToOverflow);
                if (this.isWrapReverse()) {
                    renderersToOverflow.addAll(0, lineRenderersToOverflow);
                } else {
                    renderersToOverflow.addAll(lineRenderersToOverflow);
                }
                for (IRenderer renderer : renderersToOverflow) {
                    this.childRenderers.remove(renderer);
                }
            }
        }
        return renderersToOverflow;
    }

    private void adjustLayoutResultToHandleOverflowRenderers(LayoutResult result, List<IRenderer> renderersToOverflow) {
        if (1 == result.getStatus()) {
            AbstractRenderer splitRenderer = this.createSplitRenderer(2);
            AbstractRenderer overflowRenderer = this.createOverflowRenderer(2);
            for (IRenderer childRenderer : renderersToOverflow) {
                overflowRenderer.addChild(childRenderer);
            }
            for (IRenderer childRenderer : this.getChildRenderers()) {
                splitRenderer.addChild(childRenderer);
            }
            result.setStatus(2);
            result.setSplitRenderer(splitRenderer);
            result.setOverflowRenderer(overflowRenderer);
        }
        if (2 == result.getStatus()) {
            IRenderer overflowRenderer = result.getOverflowRenderer();
            for (IRenderer childRenderer : renderersToOverflow) {
                if (overflowRenderer.getChildRenderers().contains(childRenderer)) continue;
                overflowRenderer.addChild(childRenderer);
            }
        }
    }
}

