/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.layout.properties.InlineVerticalAlignment;
import com.itextpdf.layout.properties.InlineVerticalAlignmentType;
import com.itextpdf.layout.properties.LineHeight;
import com.itextpdf.layout.renderer.AbstractRenderer;
import com.itextpdf.layout.renderer.BlockRenderer;
import com.itextpdf.layout.renderer.FloatingHelper;
import com.itextpdf.layout.renderer.ILeafElementRenderer;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.LineHeightHelper;
import com.itextpdf.layout.renderer.LineRenderer;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

final class InlineVerticalAlignmentHelper {
    private static final float ADJUSTMENT_THRESHOLD = 0.001f;
    private static final float SUPER_OFFSET = 0.3f;
    private static final float SUB_OFFSET = -0.2f;

    private InlineVerticalAlignmentHelper() {
    }

    public static void adjustChildrenYLineHtmlMode(LineRenderer lineRenderer) {
        float actualYLine = lineRenderer.occupiedArea.getBBox().getY() + lineRenderer.occupiedArea.getBBox().getHeight() - lineRenderer.maxDescent;
        InlineVerticalAlignmentHelper.processRenderers(lineRenderer, lineRenderer.getChildRenderers(), actualYLine, alignment -> !InlineVerticalAlignmentHelper.isBoxOrientedVerticalAlignment(alignment), alignment -> !InlineVerticalAlignmentHelper.isBoxOrientedVerticalAlignment(alignment));
        List<IRenderer> sortedRenderers = lineRenderer.getChildRenderers().stream().sorted((r1, r2) -> Math.round((r2.getOccupiedArea().getBBox().getHeight() - r1.getOccupiedArea().getBBox().getHeight()) * 1000.0f)).collect(Collectors.toList());
        InlineVerticalAlignmentHelper.processRenderers(lineRenderer, sortedRenderers, actualYLine, alignment -> InlineVerticalAlignmentHelper.isBoxOrientedVerticalAlignment(alignment), alignment -> true);
    }

    private static boolean isBoxOrientedVerticalAlignment(InlineVerticalAlignment alignment) {
        return alignment.getType() == InlineVerticalAlignmentType.TOP || alignment.getType() == InlineVerticalAlignmentType.BOTTOM;
    }

    private static void processRenderers(LineRenderer lineRenderer, List<IRenderer> renderers, float actualYLine, Predicate<InlineVerticalAlignment> needProcess, Predicate<InlineVerticalAlignment> needRecalculateSizes) {
        float[] fontInfo = LineHeightHelper.getActualFontInfo(lineRenderer);
        float textTop = actualYLine + fontInfo[0] - fontInfo[3] / 2.0f;
        float textBottom = actualYLine + fontInfo[1] - fontInfo[3] / 2.0f;
        float leading = fontInfo[3];
        float xHeight = fontInfo[2];
        float maxTop = Float.MIN_VALUE;
        float minBottom = Float.MAX_VALUE;
        float maxHeight = Float.MIN_VALUE;
        boolean maxminValuesChanged = false;
        for (IRenderer renderer : renderers) {
            Rectangle pBbox;
            Rectangle cBbox;
            float offset;
            if (FloatingHelper.isRendererFloating(renderer)) continue;
            InlineVerticalAlignment alignment = (InlineVerticalAlignment)renderer.getProperty(136);
            if (alignment == null) {
                alignment = new InlineVerticalAlignment();
            }
            if (needProcess.test(alignment) && Math.abs(offset = InlineVerticalAlignmentHelper.calculateOffset(renderer, cBbox = InlineVerticalAlignmentHelper.getAdjustedArea(renderer), alignment, actualYLine, textTop, textBottom, leading, xHeight, pBbox = new Rectangle(lineRenderer.occupiedArea.getBBox().getX(), Math.min(minBottom, lineRenderer.occupiedArea.getBBox().getY()), lineRenderer.occupiedArea.getBBox().getWidth(), Math.max(maxHeight, lineRenderer.occupiedArea.getBBox().getHeight())))) > 0.001f) {
                renderer.move(0.0f, offset);
            }
            if (!needRecalculateSizes.test(alignment)) continue;
            cBbox = InlineVerticalAlignmentHelper.getAdjustedArea(renderer);
            maxTop = Math.max(maxTop, cBbox.getTop());
            minBottom = Math.min(minBottom, cBbox.getBottom());
            maxHeight = Math.max(maxHeight, cBbox.getHeight());
            maxminValuesChanged = true;
        }
        if (maxminValuesChanged) {
            InlineVerticalAlignmentHelper.adjustBBox(lineRenderer, maxHeight, maxTop, minBottom);
        }
    }

    private static Rectangle getAdjustedArea(IRenderer renderer) {
        Rectangle rect = renderer.getOccupiedArea().getBBox().clone();
        if (renderer instanceof AbstractRenderer && !(renderer instanceof BlockRenderer) && !renderer.hasProperty(136)) {
            AbstractRenderer ar = (AbstractRenderer)renderer;
            ar.applyBorderBox(rect, false);
            ar.applyPaddings(rect, false);
        }
        return rect;
    }

    private static void adjustBBox(LineRenderer lineRenderer, float maxHeight, float maxTop, float minBottom) {
        LineHeight lineHeight = (LineHeight)lineRenderer.getProperty(124);
        float actualHeight = maxHeight;
        if (lineHeight != null) {
            actualHeight = Math.max(actualHeight, LineHeightHelper.calculateLineHeight(lineRenderer));
        }
        maxTop += (actualHeight - maxHeight) / 2.0f;
        minBottom -= (actualHeight - maxHeight) / 2.0f;
        maxHeight = actualHeight;
        maxHeight = Math.max(maxHeight, maxTop - minBottom);
        float originalTop = lineRenderer.occupiedArea.getBBox().getTop();
        lineRenderer.occupiedArea.getBBox().setHeight(maxHeight);
        float delta = originalTop - lineRenderer.occupiedArea.getBBox().getTop();
        lineRenderer.occupiedArea.getBBox().moveUp(delta);
        float childDelta = originalTop - maxTop;
        for (IRenderer renderer : lineRenderer.getChildRenderers()) {
            renderer.move(0.0f, childDelta);
        }
    }

    private static float calculateOffset(IRenderer renderer, Rectangle cBBox, InlineVerticalAlignment alignment, float baseline, float textTop, float textBottom, float leading, float xHeight, Rectangle pBBox) {
        switch (alignment.getType()) {
            case BASELINE: {
                return baseline - InlineVerticalAlignmentHelper.getChildBaseline(renderer, leading);
            }
            case TEXT_TOP: {
                return textTop - cBBox.getTop();
            }
            case TEXT_BOTTOM: {
                return textBottom - cBBox.getBottom();
            }
            case FIXED: {
                float offsetFixed = 0.0f;
                offsetFixed = alignment.getValue();
                return baseline + offsetFixed - InlineVerticalAlignmentHelper.getChildBaseline(renderer, leading);
            }
            case SUPER: 
            case SUB: 
            case FRACTION: {
                float offsetFraction = 0.0f;
                offsetFraction = alignment.getType() == InlineVerticalAlignmentType.SUPER ? 0.3f : (alignment.getType() == InlineVerticalAlignmentType.SUB ? -0.2f : alignment.getValue());
                float target = baseline + (textTop - textBottom) * offsetFraction;
                return target - InlineVerticalAlignmentHelper.getChildBaseline(renderer, leading);
            }
            case MIDDLE: {
                return baseline + xHeight / 2.0f - (cBBox.getBottom() + cBBox.getHeight() / 2.0f);
            }
            case BOTTOM: {
                return pBBox.getBottom() - cBBox.getBottom();
            }
            case TOP: {
                return pBBox.getTop() - cBBox.getTop();
            }
        }
        return 0.0f;
    }

    private static float getChildBaseline(IRenderer renderer, float leading) {
        if (renderer instanceof ILeafElementRenderer) {
            float descent = ((ILeafElementRenderer)renderer).getDescent();
            return renderer.getOccupiedArea().getBBox().getBottom() - descent;
        }
        Float yLine = LineRenderer.isInlineBlockChild(renderer) && renderer instanceof AbstractRenderer ? ((AbstractRenderer)renderer).getLastYLineRecursively() : null;
        return yLine == null ? renderer.getOccupiedArea().getBBox().getBottom() : yLine.floatValue() - leading / 2.0f;
    }
}

