/*
 * Copyright 2018 JDCLOUD.COM
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http:#www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * 云鼎短信服务 openapi
 * 云鼎短信服务 openapi
 *
 * OpenAPI spec version: v1
 * Contact: 
 *
 * NOTE: This class is auto generated by the jdcloud code generator program.
 */

package com.jdcloud.sdk.service.ydsms.client;

import com.jdcloud.sdk.JdcloudSdkException;
import com.jdcloud.sdk.auth.CredentialsProvider;
import com.jdcloud.sdk.client.Environment;
import com.jdcloud.sdk.client.Jdcloud;
import com.jdcloud.sdk.client.JdcloudClient;
import com.jdcloud.sdk.client.JdcloudValidateException;
import com.jdcloud.sdk.http.HttpRequestConfig;
import com.jdcloud.sdk.service.ydsms.model.ListSmsPackagesUsingGETRequest;
import com.jdcloud.sdk.service.ydsms.model.ListSmsPackagesUsingGETResponse;
import com.jdcloud.sdk.service.ydsms.client.ListSmsPackagesUsingGETExecutor;
import com.jdcloud.sdk.service.ydsms.model.OpenServiceUsingPOSTRequest;
import com.jdcloud.sdk.service.ydsms.model.OpenServiceUsingPOSTResponse;
import com.jdcloud.sdk.service.ydsms.client.OpenServiceUsingPOSTExecutor;
import com.jdcloud.sdk.service.ydsms.model.ModifyStatusUsingGETRequest;
import com.jdcloud.sdk.service.ydsms.model.ModifyStatusUsingGETResponse;
import com.jdcloud.sdk.service.ydsms.client.ModifyStatusUsingGETExecutor;
import com.jdcloud.sdk.service.ydsms.model.SendMessagesByEncPinUsingPOSTRequest;
import com.jdcloud.sdk.service.ydsms.model.SendMessagesByEncPinUsingPOSTResponse;
import com.jdcloud.sdk.service.ydsms.client.SendMessagesByEncPinUsingPOSTExecutor;
import com.jdcloud.sdk.service.ydsms.model.QuerySecretKeyUsingGETRequest;
import com.jdcloud.sdk.service.ydsms.model.QuerySecretKeyUsingGETResponse;
import com.jdcloud.sdk.service.ydsms.client.QuerySecretKeyUsingGETExecutor;
import com.jdcloud.sdk.service.ydsms.model.SendMessagesByPinUsingPOSTRequest;
import com.jdcloud.sdk.service.ydsms.model.SendMessagesByPinUsingPOSTResponse;
import com.jdcloud.sdk.service.ydsms.client.SendMessagesByPinUsingPOSTExecutor;
import com.jdcloud.sdk.service.ydsms.model.QueryAmountUsingGETRequest;
import com.jdcloud.sdk.service.ydsms.model.QueryAmountUsingGETResponse;
import com.jdcloud.sdk.service.ydsms.client.QueryAmountUsingGETExecutor;
import com.jdcloud.sdk.service.ydsms.model.GetSmsTemplateByIdUsingGETRequest;
import com.jdcloud.sdk.service.ydsms.model.GetSmsTemplateByIdUsingGETResponse;
import com.jdcloud.sdk.service.ydsms.client.GetSmsTemplateByIdUsingGETExecutor;
import com.jdcloud.sdk.service.ydsms.model.CreateSmsAppUsingPOSTRequest;
import com.jdcloud.sdk.service.ydsms.model.CreateSmsAppUsingPOSTResponse;
import com.jdcloud.sdk.service.ydsms.client.CreateSmsAppUsingPOSTExecutor;
import com.jdcloud.sdk.service.ydsms.model.ModifySmsSignUsingPOSTRequest;
import com.jdcloud.sdk.service.ydsms.model.ModifySmsSignUsingPOSTResponse;
import com.jdcloud.sdk.service.ydsms.client.ModifySmsSignUsingPOSTExecutor;
import com.jdcloud.sdk.service.ydsms.model.ListSmsTasksUsingGETRequest;
import com.jdcloud.sdk.service.ydsms.model.ListSmsTasksUsingGETResponse;
import com.jdcloud.sdk.service.ydsms.client.ListSmsTasksUsingGETExecutor;
import com.jdcloud.sdk.service.ydsms.model.ListSmsSendOverviewUsingGETRequest;
import com.jdcloud.sdk.service.ydsms.model.ListSmsSendOverviewUsingGETResponse;
import com.jdcloud.sdk.service.ydsms.client.ListSmsSendOverviewUsingGETExecutor;
import com.jdcloud.sdk.service.ydsms.model.CreateSmsTemplateUsingPOSTRequest;
import com.jdcloud.sdk.service.ydsms.model.CreateSmsTemplateUsingPOSTResponse;
import com.jdcloud.sdk.service.ydsms.client.CreateSmsTemplateUsingPOSTExecutor;
import com.jdcloud.sdk.service.ydsms.model.ModifyAppGeneralSettingByIdRequest;
import com.jdcloud.sdk.service.ydsms.model.ModifyAppGeneralSettingByIdResponse;
import com.jdcloud.sdk.service.ydsms.client.ModifyAppGeneralSettingByIdExecutor;
import com.jdcloud.sdk.service.ydsms.model.QuerySendRecordUsingGETRequest;
import com.jdcloud.sdk.service.ydsms.model.QuerySendRecordUsingGETResponse;
import com.jdcloud.sdk.service.ydsms.client.QuerySendRecordUsingGETExecutor;
import com.jdcloud.sdk.service.ydsms.model.ModifySmsTemplateUsingPOSTRequest;
import com.jdcloud.sdk.service.ydsms.model.ModifySmsTemplateUsingPOSTResponse;
import com.jdcloud.sdk.service.ydsms.client.ModifySmsTemplateUsingPOSTExecutor;
import com.jdcloud.sdk.service.ydsms.model.GetSmsPackageByIdUsingGETRequest;
import com.jdcloud.sdk.service.ydsms.model.GetSmsPackageByIdUsingGETResponse;
import com.jdcloud.sdk.service.ydsms.client.GetSmsPackageByIdUsingGETExecutor;
import com.jdcloud.sdk.service.ydsms.model.CreateSmsSignUsingPOSTRequest;
import com.jdcloud.sdk.service.ydsms.model.CreateSmsSignUsingPOSTResponse;
import com.jdcloud.sdk.service.ydsms.client.CreateSmsSignUsingPOSTExecutor;
import com.jdcloud.sdk.service.ydsms.model.ModifySmsTaskUsingPOSTRequest;
import com.jdcloud.sdk.service.ydsms.model.ModifySmsTaskUsingPOSTResponse;
import com.jdcloud.sdk.service.ydsms.client.ModifySmsTaskUsingPOSTExecutor;
import com.jdcloud.sdk.service.ydsms.model.QueryReceiptRecordUsingGETRequest;
import com.jdcloud.sdk.service.ydsms.model.QueryReceiptRecordUsingGETResponse;
import com.jdcloud.sdk.service.ydsms.client.QueryReceiptRecordUsingGETExecutor;
import com.jdcloud.sdk.service.ydsms.model.ListSmsAppsUsingGETRequest;
import com.jdcloud.sdk.service.ydsms.model.ListSmsAppsUsingGETResponse;
import com.jdcloud.sdk.service.ydsms.client.ListSmsAppsUsingGETExecutor;
import com.jdcloud.sdk.service.ydsms.model.GetSmsAppByIdUsingGETRequest;
import com.jdcloud.sdk.service.ydsms.model.GetSmsAppByIdUsingGETResponse;
import com.jdcloud.sdk.service.ydsms.client.GetSmsAppByIdUsingGETExecutor;
import com.jdcloud.sdk.service.ydsms.model.QueryReplyRecordUsingGETRequest;
import com.jdcloud.sdk.service.ydsms.model.QueryReplyRecordUsingGETResponse;
import com.jdcloud.sdk.service.ydsms.client.QueryReplyRecordUsingGETExecutor;
import com.jdcloud.sdk.service.ydsms.model.ModifySmsAppUsingPOSTRequest;
import com.jdcloud.sdk.service.ydsms.model.ModifySmsAppUsingPOSTResponse;
import com.jdcloud.sdk.service.ydsms.client.ModifySmsAppUsingPOSTExecutor;
import com.jdcloud.sdk.service.ydsms.model.GetSmsPackageSpecificationsUsingGETRequest;
import com.jdcloud.sdk.service.ydsms.model.GetSmsPackageSpecificationsUsingGETResponse;
import com.jdcloud.sdk.service.ydsms.client.GetSmsPackageSpecificationsUsingGETExecutor;
import com.jdcloud.sdk.service.ydsms.model.ListSmsCertificateTypesUsingGETRequest;
import com.jdcloud.sdk.service.ydsms.model.ListSmsCertificateTypesUsingGETResponse;
import com.jdcloud.sdk.service.ydsms.client.ListSmsCertificateTypesUsingGETExecutor;
import com.jdcloud.sdk.service.ydsms.model.ListSmsAppGeneralSettingsUsingGETRequest;
import com.jdcloud.sdk.service.ydsms.model.ListSmsAppGeneralSettingsUsingGETResponse;
import com.jdcloud.sdk.service.ydsms.client.ListSmsAppGeneralSettingsUsingGETExecutor;
import com.jdcloud.sdk.service.ydsms.model.CreateSmsTaskUsingPOSTRequest;
import com.jdcloud.sdk.service.ydsms.model.CreateSmsTaskUsingPOSTResponse;
import com.jdcloud.sdk.service.ydsms.client.CreateSmsTaskUsingPOSTExecutor;
import com.jdcloud.sdk.service.ydsms.model.GetSmsTaskIdUsingGETRequest;
import com.jdcloud.sdk.service.ydsms.model.GetSmsTaskIdUsingGETResponse;
import com.jdcloud.sdk.service.ydsms.client.GetSmsTaskIdUsingGETExecutor;
import com.jdcloud.sdk.service.ydsms.model.GetSmsTaskContentUsingGETRequest;
import com.jdcloud.sdk.service.ydsms.model.GetSmsTaskContentUsingGETResponse;
import com.jdcloud.sdk.service.ydsms.client.GetSmsTaskContentUsingGETExecutor;
import com.jdcloud.sdk.service.ydsms.model.SendMessagesByOrderIdUsingPOSTRequest;
import com.jdcloud.sdk.service.ydsms.model.SendMessagesByOrderIdUsingPOSTResponse;
import com.jdcloud.sdk.service.ydsms.client.SendMessagesByOrderIdUsingPOSTExecutor;
import com.jdcloud.sdk.service.ydsms.model.TaskStartUsingGETRequest;
import com.jdcloud.sdk.service.ydsms.model.TaskStartUsingGETResponse;
import com.jdcloud.sdk.service.ydsms.client.TaskStartUsingGETExecutor;
import com.jdcloud.sdk.service.ydsms.model.GetSmsSignByIdUsingGETRequest;
import com.jdcloud.sdk.service.ydsms.model.GetSmsSignByIdUsingGETResponse;
import com.jdcloud.sdk.service.ydsms.client.GetSmsSignByIdUsingGETExecutor;
import com.jdcloud.sdk.service.ydsms.model.ListSmsSignsUsingGETRequest;
import com.jdcloud.sdk.service.ydsms.model.ListSmsSignsUsingGETResponse;
import com.jdcloud.sdk.service.ydsms.client.ListSmsSignsUsingGETExecutor;
import com.jdcloud.sdk.service.ydsms.model.ListSmsTemplatesUsingGETRequest;
import com.jdcloud.sdk.service.ydsms.model.ListSmsTemplatesUsingGETResponse;
import com.jdcloud.sdk.service.ydsms.client.ListSmsTemplatesUsingGETExecutor;
import com.jdcloud.sdk.service.ydsms.model.SendMessagesUsingPOSTRequest;
import com.jdcloud.sdk.service.ydsms.model.SendMessagesUsingPOSTResponse;
import com.jdcloud.sdk.service.ydsms.client.SendMessagesUsingPOSTExecutor;
import com.jdcloud.sdk.service.ydsms.model.ListSmsSignTypesUsingGETRequest;
import com.jdcloud.sdk.service.ydsms.model.ListSmsSignTypesUsingGETResponse;
import com.jdcloud.sdk.service.ydsms.client.ListSmsSignTypesUsingGETExecutor;
import com.jdcloud.sdk.service.ydsms.model.TaskDeleteUsingDeleteRequest;
import com.jdcloud.sdk.service.ydsms.model.TaskDeleteUsingDeleteResponse;
import com.jdcloud.sdk.service.ydsms.client.TaskDeleteUsingDeleteExecutor;
import com.jdcloud.sdk.service.ydsms.model.CreateSmsPackageUsingPOSTRequest;
import com.jdcloud.sdk.service.ydsms.model.CreateSmsPackageUsingPOSTResponse;
import com.jdcloud.sdk.service.ydsms.client.CreateSmsPackageUsingPOSTExecutor;
import com.jdcloud.sdk.service.ydsms.model.QueryRemainingUsingGETRequest;
import com.jdcloud.sdk.service.ydsms.model.QueryRemainingUsingGETResponse;
import com.jdcloud.sdk.service.ydsms.client.QueryRemainingUsingGETExecutor;

/**
 * ydsmsClient
 */
public class YdsmsClient extends JdcloudClient {

    public final static String ApiVersion = "v1";
    private final static String UserAgentPrefix = "JdcloudSdkJava";
    public final static String ClientVersion = "1.2.4";
    public final static String DefaultEndpoint = "ydsms.jdcloud-api.com";
    public final static String ServiceName = "ydsms";
    public final static String UserAgent = UserAgentPrefix + "/" + ClientVersion + " " + ServiceName + "/" + ApiVersion;

    CredentialsProvider credentialsProvider;
    HttpRequestConfig httpRequestConfig;
    Environment environment = new Environment.Builder().endpoint(DefaultEndpoint).build();

    public CredentialsProvider getCredentialsProvider() {
        return credentialsProvider;
    }

    public HttpRequestConfig getHttpRequestConfig() {
        return httpRequestConfig;
    }

    public Environment getEnvironment() {
        return environment;
    }

    public String getUserAgent() {
        return UserAgent;
    }

    public String getServiceName() {
        return ServiceName;
    }

    public String getVersion() {
        return ApiVersion;
    }

    private YdsmsClient() {

    }

    public static Builder builder() {
        return new DefaultBuilder();
    }


    /**
     * 查询套餐包列表
     *
     * @param request
     * @return
     * @throws JdcloudSdkException
     */
    public ListSmsPackagesUsingGETResponse listSmsPackagesUsingGET(ListSmsPackagesUsingGETRequest request) throws JdcloudSdkException {
        return new ListSmsPackagesUsingGETExecutor().client(this).execute(request);
    }

    /**
     * 开通云鼎短信服务
     *
     * @param request
     * @return
     * @throws JdcloudSdkException
     */
    public OpenServiceUsingPOSTResponse openServiceUsingPOST(OpenServiceUsingPOSTRequest request) throws JdcloudSdkException {
        return new OpenServiceUsingPOSTExecutor().client(this).execute(request);
    }

    /**
     * 修改应用启停状态
     *
     * @param request
     * @return
     * @throws JdcloudSdkException
     */
    public ModifyStatusUsingGETResponse modifyStatusUsingGET(ModifyStatusUsingGETRequest request) throws JdcloudSdkException {
        return new ModifyStatusUsingGETExecutor().client(this).execute(request);
    }

    /**
     * 根据加密pin发送短信
     *
     * @param request
     * @return
     * @throws JdcloudSdkException
     */
    public SendMessagesByEncPinUsingPOSTResponse sendMessagesByEncPinUsingPOST(SendMessagesByEncPinUsingPOSTRequest request) throws JdcloudSdkException {
        return new SendMessagesByEncPinUsingPOSTExecutor().client(this).execute(request);
    }

    /**
     * 查询应用secretKey
     *
     * @param request
     * @return
     * @throws JdcloudSdkException
     */
    public QuerySecretKeyUsingGETResponse querySecretKeyUsingGET(QuerySecretKeyUsingGETRequest request) throws JdcloudSdkException {
        return new QuerySecretKeyUsingGETExecutor().client(this).execute(request);
    }

    /**
     * 根据pin发送短信
     *
     * @param request
     * @return
     * @throws JdcloudSdkException
     */
    public SendMessagesByPinUsingPOSTResponse sendMessagesByPinUsingPOST(SendMessagesByPinUsingPOSTRequest request) throws JdcloudSdkException {
        return new SendMessagesByPinUsingPOSTExecutor().client(this).execute(request);
    }

    /**
     * 查询当前自然月内所有应用发送量总和
     *
     * @param request
     * @return
     * @throws JdcloudSdkException
     */
    public QueryAmountUsingGETResponse queryAmountUsingGET(QueryAmountUsingGETRequest request) throws JdcloudSdkException {
        return new QueryAmountUsingGETExecutor().client(this).execute(request);
    }

    /**
     * 查询短信模板详情
     *
     * @param request
     * @return
     * @throws JdcloudSdkException
     */
    public GetSmsTemplateByIdUsingGETResponse getSmsTemplateByIdUsingGET(GetSmsTemplateByIdUsingGETRequest request) throws JdcloudSdkException {
        return new GetSmsTemplateByIdUsingGETExecutor().client(this).execute(request);
    }

    /**
     * 创建短信应用
     *
     * @param request
     * @return
     * @throws JdcloudSdkException
     */
    public CreateSmsAppUsingPOSTResponse createSmsAppUsingPOST(CreateSmsAppUsingPOSTRequest request) throws JdcloudSdkException {
        return new CreateSmsAppUsingPOSTExecutor().client(this).execute(request);
    }

    /**
     * 编辑短信签名
     *
     * @param request
     * @return
     * @throws JdcloudSdkException
     */
    public ModifySmsSignUsingPOSTResponse modifySmsSignUsingPOST(ModifySmsSignUsingPOSTRequest request) throws JdcloudSdkException {
        return new ModifySmsSignUsingPOSTExecutor().client(this).execute(request);
    }

    /**
     * 查询短信发送任务列表
     *
     * @param request
     * @return
     * @throws JdcloudSdkException
     */
    public ListSmsTasksUsingGETResponse listSmsTasksUsingGET(ListSmsTasksUsingGETRequest request) throws JdcloudSdkException {
        return new ListSmsTasksUsingGETExecutor().client(this).execute(request);
    }

    /**
     * 查询应用发送短信总体情况
     *
     * @param request
     * @return
     * @throws JdcloudSdkException
     */
    public ListSmsSendOverviewUsingGETResponse listSmsSendOverviewUsingGET(ListSmsSendOverviewUsingGETRequest request) throws JdcloudSdkException {
        return new ListSmsSendOverviewUsingGETExecutor().client(this).execute(request);
    }

    /**
     * 创建短信模板
     *
     * @param request
     * @return
     * @throws JdcloudSdkException
     */
    public CreateSmsTemplateUsingPOSTResponse createSmsTemplateUsingPOST(CreateSmsTemplateUsingPOSTRequest request) throws JdcloudSdkException {
        return new CreateSmsTemplateUsingPOSTExecutor().client(this).execute(request);
    }

    /**
     * 修改应用通用设置
     *
     * @param request
     * @return
     * @throws JdcloudSdkException
     */
    public ModifyAppGeneralSettingByIdResponse modifyAppGeneralSettingById(ModifyAppGeneralSettingByIdRequest request) throws JdcloudSdkException {
        return new ModifyAppGeneralSettingByIdExecutor().client(this).execute(request);
    }

    /**
     * 查询短信发送记录
     *
     * @param request
     * @return
     * @throws JdcloudSdkException
     */
    public QuerySendRecordUsingGETResponse querySendRecordUsingGET(QuerySendRecordUsingGETRequest request) throws JdcloudSdkException {
        return new QuerySendRecordUsingGETExecutor().client(this).execute(request);
    }

    /**
     * 编辑短信模板
     *
     * @param request
     * @return
     * @throws JdcloudSdkException
     */
    public ModifySmsTemplateUsingPOSTResponse modifySmsTemplateUsingPOST(ModifySmsTemplateUsingPOSTRequest request) throws JdcloudSdkException {
        return new ModifySmsTemplateUsingPOSTExecutor().client(this).execute(request);
    }

    /**
     * 查询套餐包详情
     *
     * @param request
     * @return
     * @throws JdcloudSdkException
     */
    public GetSmsPackageByIdUsingGETResponse getSmsPackageByIdUsingGET(GetSmsPackageByIdUsingGETRequest request) throws JdcloudSdkException {
        return new GetSmsPackageByIdUsingGETExecutor().client(this).execute(request);
    }

    /**
     * 创建短信签名
     *
     * @param request
     * @return
     * @throws JdcloudSdkException
     */
    public CreateSmsSignUsingPOSTResponse createSmsSignUsingPOST(CreateSmsSignUsingPOSTRequest request) throws JdcloudSdkException {
        return new CreateSmsSignUsingPOSTExecutor().client(this).execute(request);
    }

    /**
     * 编辑短信发送任务
     *
     * @param request
     * @return
     * @throws JdcloudSdkException
     */
    public ModifySmsTaskUsingPOSTResponse modifySmsTaskUsingPOST(ModifySmsTaskUsingPOSTRequest request) throws JdcloudSdkException {
        return new ModifySmsTaskUsingPOSTExecutor().client(this).execute(request);
    }

    /**
     * 查询短信回执记录
     *
     * @param request
     * @return
     * @throws JdcloudSdkException
     */
    public QueryReceiptRecordUsingGETResponse queryReceiptRecordUsingGET(QueryReceiptRecordUsingGETRequest request) throws JdcloudSdkException {
        return new QueryReceiptRecordUsingGETExecutor().client(this).execute(request);
    }

    /**
     * 查询应用列表
     *
     * @param request
     * @return
     * @throws JdcloudSdkException
     */
    public ListSmsAppsUsingGETResponse listSmsAppsUsingGET(ListSmsAppsUsingGETRequest request) throws JdcloudSdkException {
        return new ListSmsAppsUsingGETExecutor().client(this).execute(request);
    }

    /**
     * 查询应用详情
     *
     * @param request
     * @return
     * @throws JdcloudSdkException
     */
    public GetSmsAppByIdUsingGETResponse getSmsAppByIdUsingGET(GetSmsAppByIdUsingGETRequest request) throws JdcloudSdkException {
        return new GetSmsAppByIdUsingGETExecutor().client(this).execute(request);
    }

    /**
     * 查询短信回复记录
     *
     * @param request
     * @return
     * @throws JdcloudSdkException
     */
    public QueryReplyRecordUsingGETResponse queryReplyRecordUsingGET(QueryReplyRecordUsingGETRequest request) throws JdcloudSdkException {
        return new QueryReplyRecordUsingGETExecutor().client(this).execute(request);
    }

    /**
     * 编辑短信应用
     *
     * @param request
     * @return
     * @throws JdcloudSdkException
     */
    public ModifySmsAppUsingPOSTResponse modifySmsAppUsingPOST(ModifySmsAppUsingPOSTRequest request) throws JdcloudSdkException {
        return new ModifySmsAppUsingPOSTExecutor().client(this).execute(request);
    }

    /**
     * 查询套餐包规格列表
     *
     * @param request
     * @return
     * @throws JdcloudSdkException
     */
    public GetSmsPackageSpecificationsUsingGETResponse getSmsPackageSpecificationsUsingGET(GetSmsPackageSpecificationsUsingGETRequest request) throws JdcloudSdkException {
        return new GetSmsPackageSpecificationsUsingGETExecutor().client(this).execute(request);
    }

    /**
     * 查询短信签名证明材料类型列表
     *
     * @param request
     * @return
     * @throws JdcloudSdkException
     */
    public ListSmsCertificateTypesUsingGETResponse listSmsCertificateTypesUsingGET(ListSmsCertificateTypesUsingGETRequest request) throws JdcloudSdkException {
        return new ListSmsCertificateTypesUsingGETExecutor().client(this).execute(request);
    }

    /**
     * 查询应用通用设置列表
     *
     * @param request
     * @return
     * @throws JdcloudSdkException
     */
    public ListSmsAppGeneralSettingsUsingGETResponse listSmsAppGeneralSettingsUsingGET(ListSmsAppGeneralSettingsUsingGETRequest request) throws JdcloudSdkException {
        return new ListSmsAppGeneralSettingsUsingGETExecutor().client(this).execute(request);
    }

    /**
     * 创建短信发送任务
     *
     * @param request
     * @return
     * @throws JdcloudSdkException
     */
    public CreateSmsTaskUsingPOSTResponse createSmsTaskUsingPOST(CreateSmsTaskUsingPOSTRequest request) throws JdcloudSdkException {
        return new CreateSmsTaskUsingPOSTExecutor().client(this).execute(request);
    }

    /**
     * 查询短信发送任务详情
     *
     * @param request
     * @return
     * @throws JdcloudSdkException
     */
    public GetSmsTaskIdUsingGETResponse getSmsTaskIdUsingGET(GetSmsTaskIdUsingGETRequest request) throws JdcloudSdkException {
        return new GetSmsTaskIdUsingGETExecutor().client(this).execute(request);
    }

    /**
     * 获取短信任务中的短信内容及计费条数
     *
     * @param request
     * @return
     * @throws JdcloudSdkException
     */
    public GetSmsTaskContentUsingGETResponse getSmsTaskContentUsingGET(GetSmsTaskContentUsingGETRequest request) throws JdcloudSdkException {
        return new GetSmsTaskContentUsingGETExecutor().client(this).execute(request);
    }

    /**
     * 根据订单号发送短信
     *
     * @param request
     * @return
     * @throws JdcloudSdkException
     */
    public SendMessagesByOrderIdUsingPOSTResponse sendMessagesByOrderIdUsingPOST(SendMessagesByOrderIdUsingPOSTRequest request) throws JdcloudSdkException {
        return new SendMessagesByOrderIdUsingPOSTExecutor().client(this).execute(request);
    }

    /**
     * 启动任务
     *
     * @param request
     * @return
     * @throws JdcloudSdkException
     */
    public TaskStartUsingGETResponse taskStartUsingGET(TaskStartUsingGETRequest request) throws JdcloudSdkException {
        return new TaskStartUsingGETExecutor().client(this).execute(request);
    }

    /**
     * 查询短信签名详情
     *
     * @param request
     * @return
     * @throws JdcloudSdkException
     */
    public GetSmsSignByIdUsingGETResponse getSmsSignByIdUsingGET(GetSmsSignByIdUsingGETRequest request) throws JdcloudSdkException {
        return new GetSmsSignByIdUsingGETExecutor().client(this).execute(request);
    }

    /**
     * 查询短信签名列表
     *
     * @param request
     * @return
     * @throws JdcloudSdkException
     */
    public ListSmsSignsUsingGETResponse listSmsSignsUsingGET(ListSmsSignsUsingGETRequest request) throws JdcloudSdkException {
        return new ListSmsSignsUsingGETExecutor().client(this).execute(request);
    }

    /**
     * 查询短信模板列表
     *
     * @param request
     * @return
     * @throws JdcloudSdkException
     */
    public ListSmsTemplatesUsingGETResponse listSmsTemplatesUsingGET(ListSmsTemplatesUsingGETRequest request) throws JdcloudSdkException {
        return new ListSmsTemplatesUsingGETExecutor().client(this).execute(request);
    }

    /**
     * 批量发送短信
     *
     * @param request
     * @return
     * @throws JdcloudSdkException
     */
    public SendMessagesUsingPOSTResponse sendMessagesUsingPOST(SendMessagesUsingPOSTRequest request) throws JdcloudSdkException {
        return new SendMessagesUsingPOSTExecutor().client(this).execute(request);
    }

    /**
     * 查询短信签名类型列表
     *
     * @param request
     * @return
     * @throws JdcloudSdkException
     */
    public ListSmsSignTypesUsingGETResponse listSmsSignTypesUsingGET(ListSmsSignTypesUsingGETRequest request) throws JdcloudSdkException {
        return new ListSmsSignTypesUsingGETExecutor().client(this).execute(request);
    }

    /**
     * 删除任务
     *
     * @param request
     * @return
     * @throws JdcloudSdkException
     */
    public TaskDeleteUsingDeleteResponse taskDeleteUsingDelete(TaskDeleteUsingDeleteRequest request) throws JdcloudSdkException {
        return new TaskDeleteUsingDeleteExecutor().client(this).execute(request);
    }

    /**
     * 创建套餐包
     *
     * @param request
     * @return
     * @throws JdcloudSdkException
     */
    public CreateSmsPackageUsingPOSTResponse createSmsPackageUsingPOST(CreateSmsPackageUsingPOSTRequest request) throws JdcloudSdkException {
        return new CreateSmsPackageUsingPOSTExecutor().client(this).execute(request);
    }

    /**
     * 查询用户短信余量
     *
     * @param request
     * @return
     * @throws JdcloudSdkException
     */
    public QueryRemainingUsingGETResponse queryRemainingUsingGET(QueryRemainingUsingGETRequest request) throws JdcloudSdkException {
        return new QueryRemainingUsingGETExecutor().client(this).execute(request);
    }


    public interface Builder {
        public Builder credentialsProvider(CredentialsProvider provider);
        public Builder environment(Environment environment);
        public Builder httpRequestConfig(HttpRequestConfig config);
        public YdsmsClient build() throws JdcloudSdkException;
    }

    private static class DefaultBuilder implements Builder {

        private YdsmsClient ydsmsClient;

        public DefaultBuilder() {
            ydsmsClient = new YdsmsClient();
        }

        public DefaultBuilder credentialsProvider(CredentialsProvider provider) {
            ydsmsClient.credentialsProvider = provider;
            return this;
        }

        public DefaultBuilder httpRequestConfig(HttpRequestConfig config) {
            ydsmsClient.httpRequestConfig = config;
            return this;
        }

        public YdsmsClient build() throws JdcloudSdkException {

            if (ydsmsClient.credentialsProvider == null) {
                //if credentialsProvider not set, try load jdcloud global default  credentials provider
                ydsmsClient.credentialsProvider = Jdcloud.defaultInstance().getCredentialsProvider();
                if (ydsmsClient.credentialsProvider == null) {
                    throw new JdcloudValidateException("YdsmsClient build error: jdcloud credentials provider not set");
                }
            }
            if (ydsmsClient.httpRequestConfig == null) {
                ydsmsClient.httpRequestConfig = Jdcloud.defaultInstance().getHttpRequestConfig();
                if (ydsmsClient.httpRequestConfig == null) {
                    throw new JdcloudValidateException("YdsmsClient build error: http request config not set");
                }
            }
            return ydsmsClient;
        }

        public Builder environment(Environment environment) {
            ydsmsClient.environment = environment;
            return this;
        }
    }
}
