/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.activerecord;

import com.jfinal.plugin.activerecord.DbPro;
import com.jfinal.plugin.activerecord.Page;
import com.jfinal.plugin.activerecord.PageSqlKit;
import com.jfinal.plugin.activerecord.Record;
import com.jfinal.plugin.activerecord.SqlPara;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;

public class DbTemplate {
    protected DbPro db;
    protected SqlPara sqlPara;

    public DbTemplate(DbPro db, String key, Map<?, ?> data) {
        this.db = db;
        this.sqlPara = db.getSqlPara(key, data);
    }

    public DbTemplate(DbPro db, String key, Object ... paras) {
        this.db = db;
        this.sqlPara = db.getSqlPara(key, paras);
    }

    public DbTemplate(boolean byString, DbPro db, String content, Map<?, ?> data) {
        this.db = db;
        this.sqlPara = db.getSqlParaByString(content, data);
    }

    public DbTemplate(boolean byString, DbPro db, String content, Object ... paras) {
        this.db = db;
        this.sqlPara = db.getSqlParaByString(content, paras);
    }

    public List<Record> find() {
        return this.db.find(this.sqlPara);
    }

    public Record findFirst() {
        return this.db.findFirst(this.sqlPara);
    }

    public int update() {
        return this.db.update(this.sqlPara);
    }

    public Page<Record> paginate(int pageNumber, int pageSize) {
        return this.db.paginate(pageNumber, pageSize, this.sqlPara);
    }

    public Page<Record> paginate(int pageNumber, int pageSize, boolean isGroupBySql) {
        return this.db.paginate(pageNumber, pageSize, isGroupBySql, this.sqlPara);
    }

    public int delete() {
        return this.db.delete(this.sqlPara.getSql(), this.sqlPara.getPara());
    }

    public String queryStr() {
        return this.db.queryStr(this.sqlPara.getSql(), this.sqlPara.getPara());
    }

    public Integer queryInt() {
        return this.db.queryInt(this.sqlPara.getSql(), this.sqlPara.getPara());
    }

    public Long queryLong() {
        return this.db.queryLong(this.sqlPara.getSql(), this.sqlPara.getPara());
    }

    public BigDecimal queryBigDecimal() {
        return this.db.queryBigDecimal(this.sqlPara.getSql(), this.sqlPara.getPara());
    }

    public BigInteger queryBigInteger() {
        return this.db.queryBigInteger(this.sqlPara.getSql(), this.sqlPara.getPara());
    }

    public <T> T queryColumn() {
        return this.db.queryColumn(this.sqlPara.getSql(), this.sqlPara.getPara());
    }

    public <T> List<T> query() {
        return this.db.query(this.sqlPara.getSql(), this.sqlPara.getPara());
    }

    public <T> T queryFirst() {
        return this.db.queryFirst(this.sqlPara.getSql(), this.sqlPara.getPara());
    }

    public List<Record> findByCache(String cacheName, Object key) {
        return this.db.findByCache(cacheName, key, this.sqlPara.getSql(), this.sqlPara.getPara());
    }

    public Record findFirstByCache(String cacheName, Object key) {
        return this.db.findFirstByCache(cacheName, key, this.sqlPara.getSql(), this.sqlPara.getPara());
    }

    public Page<Record> paginateByCache(String cacheName, Object key, int pageNumber, int pageSize) {
        String[] sqls = PageSqlKit.parsePageSql(this.sqlPara.getSql());
        return this.db.paginateByCache(cacheName, key, pageNumber, pageSize, sqls[0], sqls[1], this.sqlPara.getPara());
    }

    public Page<Record> paginateByCache(String cacheName, Object key, int pageNumber, int pageSize, boolean isGroupBySql) {
        String[] sqls = PageSqlKit.parsePageSql(this.sqlPara.getSql());
        return this.db.paginateByCache(cacheName, key, pageNumber, pageSize, isGroupBySql, sqls[0], sqls[1], this.sqlPara.getPara());
    }
}

