/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.activerecord.sql;

import com.jfinal.kit.StrKit;
import com.jfinal.plugin.activerecord.SqlPara;
import com.jfinal.plugin.activerecord.sql.NameSpaceDirective;
import com.jfinal.plugin.activerecord.sql.ParaDirective;
import com.jfinal.plugin.activerecord.sql.SqlDirective;
import com.jfinal.plugin.activerecord.sql.SqlSource;
import com.jfinal.template.Engine;
import com.jfinal.template.Template;
import com.jfinal.template.source.ISource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SqlKit {
    static final String SQL_TEMPLATE_MAP_KEY = "_SQL_TEMPLATE_MAP_";
    static final String SQL_PARA_KEY = "_SQL_PARA_";
    static final String PARA_ARRAY_KEY = "_PARA_ARRAY_";
    private String configName;
    private boolean devMode;
    private Engine engine;
    private List<SqlSource> sqlSourceList = new ArrayList<SqlSource>();
    private Map<String, Template> sqlTemplateMap;

    public SqlKit(String configName, boolean devMode) {
        this.configName = configName;
        this.devMode = devMode;
        this.engine = new Engine(configName);
        this.engine.setDevMode(devMode);
        this.engine.setToClassPathSourceFactory();
        this.engine.addDirective("namespace", NameSpaceDirective.class);
        this.engine.addDirective("sql", SqlDirective.class);
        this.engine.addDirective("para", ParaDirective.class, true);
        this.engine.addDirective("p", ParaDirective.class, true);
    }

    public SqlKit(String configName) {
        this(configName, false);
    }

    public Engine getEngine() {
        return this.engine;
    }

    public void setDevMode(boolean devMode) {
        this.devMode = devMode;
        this.engine.setDevMode(devMode);
    }

    public void setBaseSqlTemplatePath(String baseSqlTemplatePath) {
        this.engine.setBaseTemplatePath(baseSqlTemplatePath);
    }

    public void addSqlTemplate(String sqlTemplate) {
        if (StrKit.isBlank(sqlTemplate)) {
            throw new IllegalArgumentException("sqlTemplate can not be blank");
        }
        this.sqlSourceList.add(new SqlSource(sqlTemplate));
    }

    public void addSqlTemplate(ISource sqlTemplate) {
        if (sqlTemplate == null) {
            throw new IllegalArgumentException("sqlTemplate can not be null");
        }
        this.sqlSourceList.add(new SqlSource(sqlTemplate));
    }

    public synchronized void parseSqlTemplate() {
        HashMap<String, Template> sqlTemplateMap = new HashMap<String, Template>(512, 0.5f);
        for (SqlSource ss : this.sqlSourceList) {
            Template template = ss.isFile() ? this.engine.getTemplate(ss.file) : this.engine.getTemplate(ss.source);
            HashMap<String, HashMap<String, Template>> data = new HashMap<String, HashMap<String, Template>>();
            data.put(SQL_TEMPLATE_MAP_KEY, sqlTemplateMap);
            template.renderToString(data);
        }
        this.sqlTemplateMap = sqlTemplateMap;
    }

    private void reloadModifiedSqlTemplate() {
        this.engine.removeAllTemplateCache();
        this.parseSqlTemplate();
    }

    private boolean isSqlTemplateModified() {
        for (Template template : this.sqlTemplateMap.values()) {
            if (!template.isModified()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Template getSqlTemplate(String key) {
        Template template = this.sqlTemplateMap.get(key);
        if (template == null) {
            if (!this.devMode) {
                return null;
            }
            if (this.isSqlTemplateModified()) {
                SqlKit sqlKit = this;
                synchronized (sqlKit) {
                    if (this.isSqlTemplateModified()) {
                        this.reloadModifiedSqlTemplate();
                        template = this.sqlTemplateMap.get(key);
                    }
                }
            }
            return template;
        }
        if (this.devMode && template.isModified()) {
            SqlKit sqlKit = this;
            synchronized (sqlKit) {
                template = this.sqlTemplateMap.get(key);
                if (template.isModified()) {
                    this.reloadModifiedSqlTemplate();
                    template = this.sqlTemplateMap.get(key);
                }
            }
        }
        return template;
    }

    public String getSql(String key) {
        Template template = this.getSqlTemplate(key);
        return template != null ? template.renderToString(null) : null;
    }

    public SqlPara getSqlPara(String key, Map data) {
        Template template = this.getSqlTemplate(key);
        if (template == null) {
            return null;
        }
        SqlPara sqlPara = new SqlPara();
        data.put(SQL_PARA_KEY, sqlPara);
        sqlPara.setSql(template.renderToString(data));
        data.remove(SQL_PARA_KEY);
        return sqlPara;
    }

    public SqlPara getSqlPara(String key, Object ... paras) {
        Template template = this.getSqlTemplate(key);
        if (template == null) {
            return null;
        }
        SqlPara sqlPara = new SqlPara();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(SQL_PARA_KEY, sqlPara);
        data.put(PARA_ARRAY_KEY, paras);
        sqlPara.setSql(template.renderToString(data));
        return sqlPara;
    }

    public Set<Map.Entry<String, Template>> getSqlMapEntrySet() {
        return this.sqlTemplateMap.entrySet();
    }

    public String toString() {
        return "SqlKit for config : " + this.configName;
    }

    public SqlPara getSqlParaByString(String content, Map data) {
        Template template = this.engine.getTemplateByString(content);
        SqlPara sqlPara = new SqlPara();
        data.put(SQL_PARA_KEY, sqlPara);
        sqlPara.setSql(template.renderToString(data));
        data.remove(SQL_PARA_KEY);
        return sqlPara;
    }

    public SqlPara getSqlParaByString(String content, Object ... paras) {
        Template template = this.engine.getTemplateByString(content);
        SqlPara sqlPara = new SqlPara();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(SQL_PARA_KEY, sqlPara);
        data.put(PARA_ARRAY_KEY, paras);
        sqlPara.setSql(template.renderToString(data));
        return sqlPara;
    }
}

