/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.kit;

import com.jfinal.kit.Prop;
import com.jfinal.kit.StrKit;
import java.io.File;
import java.util.concurrent.ConcurrentHashMap;

public class PropKit {
    private static String envKey = "app.env";
    private static Prop prop = null;
    private static final ConcurrentHashMap<String, Prop> cache = new ConcurrentHashMap();

    private PropKit() {
    }

    public static void setEnvKey(String envKey) {
        PropKit.envKey = envKey;
    }

    public static String getEnvKey() {
        return envKey;
    }

    public static String getEnv() {
        return PropKit.getProp().get(envKey);
    }

    public static Prop use(String fileName) {
        return PropKit.use(fileName, "UTF-8");
    }

    public static Prop use(String fileName, String encoding) {
        return cache.computeIfAbsent(fileName, key -> {
            Prop ret = new Prop((String)key, encoding);
            PropKit.handleEnv(ret, key);
            if (prop == null) {
                prop = ret;
            }
            return ret;
        });
    }

    private static void handleEnv(Prop result, String fileName) {
        String env = result.get(envKey);
        if (StrKit.notBlank(env)) {
            int index = fileName.lastIndexOf(46);
            String envConfigName = fileName.substring(0, index) + "-" + env + fileName.substring(index);
            Prop envConfig = new Prop(envConfigName);
            result.append(envConfig);
        }
    }

    public static Prop use(File file) {
        return PropKit.use(file, "UTF-8");
    }

    public static Prop use(File file, String encoding) {
        return cache.computeIfAbsent(file.getName(), key -> {
            Prop ret = new Prop(file, encoding);
            PropKit.handleEnv(ret, key);
            if (prop == null) {
                prop = ret;
            }
            return ret;
        });
    }

    public static Prop useless(String fileName) {
        Prop previous = cache.remove(fileName);
        if (prop == previous) {
            prop = null;
        }
        return previous;
    }

    public static void clear() {
        prop = null;
        cache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Prop append(Prop prop) {
        Class<PropKit> clazz = PropKit.class;
        synchronized (PropKit.class) {
            if (PropKit.prop != null) {
                PropKit.prop.append(prop);
            } else {
                PropKit.prop = prop;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return PropKit.prop;
        }
    }

    public static Prop append(String fileName, String encoding) {
        return PropKit.append(new Prop(fileName, encoding));
    }

    public static Prop append(String fileName) {
        return PropKit.append(fileName, "UTF-8");
    }

    public static Prop appendIfExists(String fileName, String encoding) {
        try {
            return PropKit.append(new Prop(fileName, encoding));
        }
        catch (Exception e) {
            return prop;
        }
    }

    public static Prop appendIfExists(String fileName) {
        return PropKit.appendIfExists(fileName, "UTF-8");
    }

    public static Prop append(File file, String encoding) {
        return PropKit.append(new Prop(file, encoding));
    }

    public static Prop append(File file) {
        return PropKit.append(file, "UTF-8");
    }

    public static Prop appendIfExists(File file, String encoding) {
        if (file.exists()) {
            PropKit.append(new Prop(file, encoding));
        }
        return prop;
    }

    public static Prop appendIfExists(File file) {
        return PropKit.appendIfExists(file, "UTF-8");
    }

    public static Prop useFirstFound(String ... fileNames) {
        for (String fn : fileNames) {
            try {
                return PropKit.use(fn, "UTF-8");
            }
            catch (Exception exception) {
            }
        }
        throw new IllegalArgumentException("\u6ca1\u6709\u914d\u7f6e\u6587\u4ef6\u53ef\u88ab\u4f7f\u7528");
    }

    public static Prop getProp() {
        if (prop == null) {
            throw new IllegalStateException("Load propties file by invoking PropKit.use(String fileName) method first.");
        }
        return prop;
    }

    public static Prop getProp(String fileName) {
        return cache.get(fileName);
    }

    public static String get(String key) {
        return PropKit.getProp().get(key);
    }

    public static String get(String key, String defaultValue) {
        return PropKit.getProp().get(key, defaultValue);
    }

    public static Integer getInt(String key) {
        return PropKit.getProp().getInt(key);
    }

    public static Integer getInt(String key, Integer defaultValue) {
        return PropKit.getProp().getInt(key, defaultValue);
    }

    public static Long getLong(String key) {
        return PropKit.getProp().getLong(key);
    }

    public static Long getLong(String key, Long defaultValue) {
        return PropKit.getProp().getLong(key, defaultValue);
    }

    public static Double getDouble(String key) {
        return PropKit.getProp().getDouble(key);
    }

    public static Double getDouble(String key, Double defaultValue) {
        return PropKit.getProp().getDouble(key, defaultValue);
    }

    public static Boolean getBoolean(String key) {
        return PropKit.getProp().getBoolean(key);
    }

    public static Boolean getBoolean(String key, Boolean defaultValue) {
        return PropKit.getProp().getBoolean(key, defaultValue);
    }

    public static boolean containsKey(String key) {
        return PropKit.getProp().containsKey(key);
    }
}

