/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.weixin.sdk.api;

import com.jfinal.kit.StrKit;
import com.jfinal.log.Log;
import com.jfinal.weixin.sdk.api.ApiConfig;
import com.jfinal.weixin.sdk.cache.DefaultAccessTokenCache;
import com.jfinal.weixin.sdk.cache.IAccessTokenCache;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ApiConfigKit {
    private static final Log log = Log.getLog(ApiConfigKit.class);
    private static final ThreadLocal<String> TL = new ThreadLocal();
    private static final ThreadLocal<ApiConfig> TL_API_CONFIG = new ThreadLocal();
    private static final Map<String, ApiConfig> CFG_MAP = new ConcurrentHashMap<String, ApiConfig>();
    private static final String DEFAULT_CFG_KEY = "_default_cfg_key_";
    private static boolean devMode = false;
    static IAccessTokenCache accessTokenCache = new DefaultAccessTokenCache();

    public static void setDevMode(boolean devMode) {
        ApiConfigKit.devMode = devMode;
    }

    public static boolean isDevMode() {
        return devMode;
    }

    public static ApiConfig putApiConfig(ApiConfig apiConfig) {
        if (CFG_MAP.size() == 0) {
            CFG_MAP.put(DEFAULT_CFG_KEY, apiConfig);
        }
        return CFG_MAP.put(apiConfig.getAppId(), apiConfig);
    }

    public static ApiConfig removeApiConfig(ApiConfig apiConfig) {
        return ApiConfigKit.removeApiConfig(apiConfig.getAppId());
    }

    public static ApiConfig removeApiConfig(String appId) {
        ApiConfig defaultApiConfig;
        ApiConfig removedConfig = CFG_MAP.remove(appId);
        if (removedConfig != null && (defaultApiConfig = CFG_MAP.get(DEFAULT_CFG_KEY)).getAppId().equals(removedConfig.getAppId())) {
            Iterator<Map.Entry<String, ApiConfig>> iterator;
            CFG_MAP.remove(DEFAULT_CFG_KEY);
            ApiConfig firstApiConfig = null;
            if (CFG_MAP.size() > 0 && (iterator = CFG_MAP.entrySet().iterator()).hasNext()) {
                Map.Entry<String, ApiConfig> entry = iterator.next();
                firstApiConfig = entry.getValue();
            }
            if (firstApiConfig != null) {
                CFG_MAP.put(DEFAULT_CFG_KEY, firstApiConfig);
            }
        }
        return removedConfig;
    }

    public static void removeAll() {
        CFG_MAP.clear();
    }

    public static void setThreadLocalAppId(String appId) {
        if (StrKit.isBlank((String)appId)) {
            appId = CFG_MAP.get(DEFAULT_CFG_KEY).getAppId();
        }
        TL.set(appId);
    }

    public static void removeThreadLocalAppId() {
        TL.remove();
    }

    public static void setThreadLocalApiConfig(ApiConfig config) {
        TL_API_CONFIG.set(config);
    }

    public static void removeThreadLocalApiConfig() {
        TL_API_CONFIG.remove();
    }

    public static String getAppId() {
        String appId = TL.get();
        if (StrKit.isBlank((String)appId)) {
            appId = CFG_MAP.get(DEFAULT_CFG_KEY).getAppId();
        }
        return appId;
    }

    public static ApiConfig getApiConfig() {
        ApiConfig config = TL_API_CONFIG.get();
        if (config != null) {
            return config;
        }
        String appId = ApiConfigKit.getAppId();
        return ApiConfigKit.getApiConfig(appId);
    }

    public static ApiConfig getApiConfig(String appId) {
        log.debug("appId: " + appId);
        ApiConfig cfg = CFG_MAP.get(appId);
        if (cfg == null) {
            throw new IllegalStateException("\u9700\u4e8b\u5148\u8c03\u7528 ApiConfigKit.putApiConfig(apiConfig) \u5c06 appId\u5bf9\u5e94\u7684 ApiConfig \u5bf9\u8c61\u5b58\u5165\uff0c\u5982JFinalConfig.afterJFinalStart()\u4e2d\u8c03\u7528, \u624d\u53ef\u4ee5\u4f7f\u7528 ApiConfigKit.getApiConfig() \u7cfb\u5217\u65b9\u6cd5");
        }
        return cfg;
    }

    public static void setAccessTokenCache(IAccessTokenCache accessTokenCache) {
        ApiConfigKit.accessTokenCache = accessTokenCache;
    }

    public static IAccessTokenCache getAccessTokenCache() {
        return accessTokenCache;
    }
}

