/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.weixin.sdk.api;

import com.jfinal.weixin.sdk.api.AccessTokenApi;
import com.jfinal.weixin.sdk.api.ApiResult;
import com.jfinal.weixin.sdk.api.MediaArticles;
import com.jfinal.weixin.sdk.utils.HttpUtils;
import com.jfinal.weixin.sdk.utils.JsonUtils;
import java.util.HashMap;
import java.util.List;

public class DraftBoxApi {
    public static final String API_PREFIX = "https://api.weixin.qq.com/cgi-bin/draft/";

    public static ApiResult add(List<MediaArticles> articles) {
        String url = "https://api.weixin.qq.com/cgi-bin/draft/add?access_token=" + AccessTokenApi.getAccessTokenStr();
        String jsonResult = HttpUtils.post(url, JsonUtils.toJson(articles));
        return new ApiResult(jsonResult);
    }

    public static ApiResult update(String mediaId, int index, MediaArticles article) {
        String url = "https://api.weixin.qq.com/cgi-bin/draft/update?access_token=" + AccessTokenApi.getAccessTokenStr();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("media_id", mediaId);
        data.put("index", index);
        data.put("articles", article);
        String jsonResult = HttpUtils.post(url, JsonUtils.toJson(data));
        return new ApiResult(jsonResult);
    }

    public static ApiResult get(String mediaId) {
        String url = "https://api.weixin.qq.com/cgi-bin/draft/get?access_token=" + AccessTokenApi.getAccessTokenStr();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("media_id", mediaId);
        String jsonResult = HttpUtils.post(url, JsonUtils.toJson(data));
        return new ApiResult(jsonResult);
    }

    public static ApiResult getBatch(int offset, int count) {
        return DraftBoxApi.getBatch(offset, count, false);
    }

    public static ApiResult getBatch(int offset, int count, boolean noContent) {
        String url = "https://api.weixin.qq.com/cgi-bin/draft/batchget?access_token=" + AccessTokenApi.getAccessTokenStr();
        HashMap<String, Integer> data = new HashMap<String, Integer>();
        data.put("offset", offset);
        data.put("count", count);
        data.put("no_content", noContent ? 1 : 0);
        String jsonResult = HttpUtils.post(url, JsonUtils.toJson(data));
        return new ApiResult(jsonResult);
    }

    public static ApiResult delete(String mediaId) {
        String url = "https://api.weixin.qq.com/cgi-bin/draft/delete?access_token=" + AccessTokenApi.getAccessTokenStr();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("media_id", mediaId);
        String jsonResult = HttpUtils.post(url, JsonUtils.toJson(data));
        return new ApiResult(jsonResult);
    }

    public static ApiResult count() {
        String url = "https://api.weixin.qq.com/cgi-bin/draft/count?access_token=" + AccessTokenApi.getAccessTokenStr();
        String jsonResult = HttpUtils.get(url);
        return new ApiResult(jsonResult);
    }
}

