/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.weixin.sdk.utils;

import com.jfinal.kit.HttpKit;
import com.jfinal.kit.StrKit;
import com.jfinal.weixin.sdk.api.MediaFile;
import com.jfinal.weixin.sdk.utils.ClassUtils;
import com.jfinal.weixin.sdk.utils.HttpKitExt;
import com.jfinal.weixin.sdk.utils.IOUtils;
import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.MultipartBuilder;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.HttpUrl;
import okhttp3.MultipartBody;
import okhttp3.Request;

public final class HttpUtils {
    private static HttpDelegate delegate;
    static final TrustAnyTrustManager trustAnyTrustManager;

    private HttpUtils() {
    }

    public static String get(String url) {
        return delegate.get(url);
    }

    public static String get(String url, Map<String, String> queryParas) {
        return delegate.get(url, queryParas);
    }

    public static String post(String url, String data) {
        return delegate.post(url, data);
    }

    public static String postSSL(String url, String data, String certPath, String certPass) {
        return delegate.postSSL(url, data, certPath, certPass);
    }

    public static MediaFile download(String url) {
        return delegate.download(url);
    }

    public static InputStream download(String url, String params) {
        return delegate.download(url, params);
    }

    public static String upload(String url, File file, String params) {
        return delegate.upload(url, file, params);
    }

    public static void setHttpDelegate(HttpDelegate httpDelegate) {
        delegate = httpDelegate;
    }

    private static X509TrustManager getTrustManager() {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            Object[] trustManagers = trustManagerFactory.getTrustManagers();
            if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
                System.err.println("Unexpected default trust managers:" + Arrays.toString(trustManagers));
                return trustAnyTrustManager;
            }
            return (X509TrustManager)trustManagers[0];
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return trustAnyTrustManager;
        }
    }

    static /* synthetic */ X509TrustManager access$000() {
        return HttpUtils.getTrustManager();
    }

    static {
        HttpDelegate delegateToUse = null;
        if (ClassUtils.isPresent("okhttp3.OkHttpClient", HttpUtils.class.getClassLoader())) {
            delegateToUse = new OkHttp3Delegate();
        } else if (ClassUtils.isPresent("com.squareup.okhttp.OkHttpClient", HttpUtils.class.getClassLoader())) {
            delegateToUse = new OkHttpDelegate();
        } else if (ClassUtils.isPresent("com.jfinal.kit.HttpKit", HttpUtils.class.getClassLoader())) {
            delegateToUse = new HttpKitDelegate();
        }
        delegate = delegateToUse;
        trustAnyTrustManager = new TrustAnyTrustManager();
    }

    public static class HttpKitDelegate
    implements HttpDelegate {
        @Override
        public String get(String url) {
            return HttpKit.get((String)url);
        }

        @Override
        public String get(String url, Map<String, String> queryParas) {
            return HttpKit.get((String)url, queryParas);
        }

        @Override
        public String post(String url, String data) {
            return HttpKit.post((String)url, (String)data);
        }

        @Override
        public String postSSL(String url, String data, String certPath, String certPass) {
            return HttpKitExt.postSSL(url, data, certPath, certPass);
        }

        @Override
        public MediaFile download(String url) {
            try {
                return HttpKitExt.download(url);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public InputStream download(String url, String params) {
            try {
                return HttpKitExt.downloadMaterial(url, params);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public String upload(String url, File file, String params) {
            try {
                return HttpKitExt.uploadMedia(url, file, params);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class TrustAnyTrustManager
    implements X509TrustManager {
        private TrustAnyTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }

    public static class OkHttp3Delegate
    implements HttpDelegate {
        private final okhttp3.OkHttpClient httpClient = new okhttp3.OkHttpClient().newBuilder().connectTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).build();
        private static final okhttp3.MediaType CONTENT_TYPE_FORM = okhttp3.MediaType.parse((String)"application/x-www-form-urlencoded");

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private String exec(Request request) {
            try (okhttp3.Response response = this.httpClient.newCall(request).execute();){
                if (!response.isSuccessful()) {
                    throw new RuntimeException("Unexpected code " + response);
                }
                String string = response.body().string();
                return string;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public String get(String url) {
            Request request = new Request.Builder().url(url).get().build();
            return this.exec(request);
        }

        @Override
        public String get(String url, Map<String, String> queryParas) {
            HttpUrl.Builder urlBuilder = HttpUrl.parse((String)url).newBuilder();
            for (Map.Entry<String, String> entry : queryParas.entrySet()) {
                urlBuilder.addQueryParameter(entry.getKey(), entry.getValue());
            }
            HttpUrl httpUrl = urlBuilder.build();
            Request request = new Request.Builder().url(httpUrl).get().build();
            return this.exec(request);
        }

        @Override
        public String post(String url, String params) {
            okhttp3.RequestBody body = okhttp3.RequestBody.create((okhttp3.MediaType)CONTENT_TYPE_FORM, (String)params);
            Request request = new Request.Builder().url(url).post(body).build();
            return this.exec(request);
        }

        /*
         * Exception decompiling
         */
        @Override
        public String postSSL(String url, String data, String certPath, String certPass) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public MediaFile download(String url) {
            Request request = new Request.Builder().url(url).get().build();
            try {
                okhttp3.Response response = this.httpClient.newCall(request).execute();
                if (!response.isSuccessful()) {
                    throw new RuntimeException("Unexpected code " + response);
                }
                okhttp3.ResponseBody body = response.body();
                okhttp3.MediaType mediaType = body.contentType();
                MediaFile mediaFile = new MediaFile();
                if ("text".equals(mediaType.type())) {
                    mediaFile.setError(body.string());
                } else {
                    BufferedInputStream bis = new BufferedInputStream(body.byteStream());
                    String ds = response.header("Content-disposition");
                    String fullName = ds.substring(ds.indexOf("filename=\"") + 10, ds.length() - 1);
                    String relName = fullName.substring(0, fullName.lastIndexOf("."));
                    String suffix = fullName.substring(relName.length() + 1);
                    mediaFile.setFullName(fullName);
                    mediaFile.setFileName(relName);
                    mediaFile.setSuffix(suffix);
                    mediaFile.setContentLength(body.contentLength() + "");
                    mediaFile.setContentType(body.contentType().toString());
                    mediaFile.setFileStream(bis);
                }
                return mediaFile;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public InputStream download(String url, String params) {
            Request request;
            if (StrKit.notBlank((String)params)) {
                okhttp3.RequestBody body = okhttp3.RequestBody.create((okhttp3.MediaType)CONTENT_TYPE_FORM, (String)params);
                request = new Request.Builder().url(url).post(body).build();
            } else {
                request = new Request.Builder().url(url).get().build();
            }
            try {
                okhttp3.Response response = this.httpClient.newCall(request).execute();
                if (!response.isSuccessful()) {
                    throw new RuntimeException("Unexpected code " + response);
                }
                return response.body().byteStream();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public String upload(String url, File file, String params) {
            okhttp3.RequestBody fileBody = okhttp3.RequestBody.create((okhttp3.MediaType)okhttp3.MediaType.parse((String)"application/octet-stream"), (File)file);
            MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("media", file.getName(), fileBody);
            if (StrKit.notBlank((String)params)) {
                builder.addFormDataPart("description", params);
            }
            MultipartBody requestBody = builder.build();
            Request request = new Request.Builder().url(url).post((okhttp3.RequestBody)requestBody).build();
            return this.exec(request);
        }
    }

    public static class OkHttpDelegate
    implements HttpDelegate {
        private final OkHttpClient httpClient;
        private final OkHttpClient httpsClient;
        private final Lock lock = new ReentrantLock();
        private static final MediaType CONTENT_TYPE_FORM = MediaType.parse((String)"application/x-www-form-urlencoded");

        public OkHttpDelegate() {
            this.httpClient = new OkHttpClient();
            this.httpClient.setConnectTimeout(10L, TimeUnit.SECONDS);
            this.httpClient.setWriteTimeout(10L, TimeUnit.SECONDS);
            this.httpClient.setReadTimeout(30L, TimeUnit.SECONDS);
            this.httpsClient = this.httpClient.clone();
        }

        private String exec(com.squareup.okhttp.Request request) {
            try {
                Response response = this.httpClient.newCall(request).execute();
                if (!response.isSuccessful()) {
                    throw new RuntimeException("Unexpected code " + response);
                }
                return response.body().string();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public String get(String url) {
            com.squareup.okhttp.Request request = new Request.Builder().url(url).get().build();
            return this.exec(request);
        }

        @Override
        public String get(String url, Map<String, String> queryParas) {
            HttpUrl.Builder urlBuilder = com.squareup.okhttp.HttpUrl.parse((String)url).newBuilder();
            for (Map.Entry<String, String> entry : queryParas.entrySet()) {
                urlBuilder.addQueryParameter(entry.getKey(), entry.getValue());
            }
            com.squareup.okhttp.HttpUrl httpUrl = urlBuilder.build();
            com.squareup.okhttp.Request request = new Request.Builder().url(httpUrl).get().build();
            return this.exec(request);
        }

        @Override
        public String post(String url, String params) {
            RequestBody body = RequestBody.create((MediaType)CONTENT_TYPE_FORM, (String)params);
            com.squareup.okhttp.Request request = new Request.Builder().url(url).post(body).build();
            return this.exec(request);
        }

        @Override
        public String postSSL(String url, String data, String certPath, String certPass) {
            String string;
            RequestBody body = RequestBody.create((MediaType)CONTENT_TYPE_FORM, (String)data);
            com.squareup.okhttp.Request request = new Request.Builder().url(url).post(body).build();
            FileInputStream inputStream = null;
            try {
                this.lock.lock();
                KeyStore clientStore = KeyStore.getInstance("PKCS12");
                inputStream = new FileInputStream(certPath);
                clientStore.load(inputStream, certPass.toCharArray());
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmf.init(clientStore, certPass.toCharArray());
                KeyManager[] kms = kmf.getKeyManagers();
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(kms, null, new SecureRandom());
                this.httpsClient.setSslSocketFactory(sslContext.getSocketFactory());
                Response response = this.httpsClient.newCall(request).execute();
                if (!response.isSuccessful()) {
                    throw new RuntimeException("Unexpected code " + response);
                }
                string = response.body().string();
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inputStream);
                    this.lock.unlock();
                    throw throwable;
                }
            }
            IOUtils.closeQuietly(inputStream);
            this.lock.unlock();
            return string;
        }

        @Override
        public MediaFile download(String url) {
            com.squareup.okhttp.Request request = new Request.Builder().url(url).get().build();
            try {
                Response response = this.httpClient.newCall(request).execute();
                if (!response.isSuccessful()) {
                    throw new RuntimeException("Unexpected code " + response);
                }
                ResponseBody body = response.body();
                MediaType mediaType = body.contentType();
                MediaFile mediaFile = new MediaFile();
                if ("text".equals(mediaType.type())) {
                    mediaFile.setError(body.string());
                } else {
                    BufferedInputStream bis = new BufferedInputStream(body.byteStream());
                    String ds = response.header("Content-disposition");
                    String fullName = ds.substring(ds.indexOf("filename=\"") + 10, ds.length() - 1);
                    String relName = fullName.substring(0, fullName.lastIndexOf("."));
                    String suffix = fullName.substring(relName.length() + 1);
                    mediaFile.setFullName(fullName);
                    mediaFile.setFileName(relName);
                    mediaFile.setSuffix(suffix);
                    mediaFile.setContentLength(body.contentLength() + "");
                    mediaFile.setContentType(body.contentType().toString());
                    mediaFile.setFileStream(bis);
                }
                return mediaFile;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public InputStream download(String url, String params) {
            com.squareup.okhttp.Request request;
            if (StrKit.notBlank((String)params)) {
                RequestBody body = RequestBody.create((MediaType)CONTENT_TYPE_FORM, (String)params);
                request = new Request.Builder().url(url).post(body).build();
            } else {
                request = new Request.Builder().url(url).get().build();
            }
            try {
                Response response = this.httpClient.newCall(request).execute();
                if (!response.isSuccessful()) {
                    throw new RuntimeException("Unexpected code " + response);
                }
                return response.body().byteStream();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public String upload(String url, File file, String params) {
            RequestBody fileBody = RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (File)file);
            MultipartBuilder builder = new MultipartBuilder().type(MultipartBuilder.FORM).addFormDataPart("media", file.getName(), fileBody);
            if (StrKit.notBlank((String)params)) {
                builder.addFormDataPart("description", params);
            }
            RequestBody requestBody = builder.build();
            com.squareup.okhttp.Request request = new Request.Builder().url(url).post(requestBody).build();
            return this.exec(request);
        }
    }

    public static interface HttpDelegate {
        public String get(String var1);

        public String get(String var1, Map<String, String> var2);

        public String post(String var1, String var2);

        public String postSSL(String var1, String var2, String var3, String var4);

        public MediaFile download(String var1);

        public InputStream download(String var1, String var2);

        public String upload(String var1, File var2, String var3);
    }
}

