/*
 * Decompiled with CFR 0.152.
 */
package com.junziqian.sdk.util;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.junziqian.sdk.bean.ResultInfo;
import com.junziqian.sdk.bean.req.Req2MapInterface;
import com.junziqian.sdk.util.Assert;
import com.junziqian.sdk.util.exception.ResultInfoException;
import com.junziqian.sdk.util.http.HttpClientUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestUtils {
    private static final Logger log = LoggerFactory.getLogger(RequestUtils.class);
    private String serviceUrl;
    private String appkey;
    private String appSecret;
    private String encryMethod;
    private byte tsType = 1;
    private HttpClientUtils httpClientUtils;

    private RequestUtils() {
    }

    private RequestUtils(String encryMethod, byte tsType) {
        this.encryMethod = encryMethod;
        this.tsType = tsType;
    }

    public static RequestUtils init(String serviceUrl, String appkey, String appSecret) {
        return RequestUtils.init(serviceUrl, appkey, appSecret, null, (byte)1);
    }

    public static RequestUtils init(String serviceUrl, String appkey, String appSecret, String encryMethod, byte tsType) {
        return RequestUtils.init(serviceUrl, appkey, appSecret, encryMethod, tsType, null, null);
    }

    public static RequestUtils init(String serviceUrl, String appkey, String appSecret, String encryMethod, byte tsType, String proxyHost, Integer proxyPort) {
        Assert.isNotBlank(appkey, "appkey is null");
        Assert.isNotBlank(appSecret, "appSecret is null");
        Assert.isNotBlank(serviceUrl, "serviceUrl is null");
        RequestUtils requestUtils = new RequestUtils(encryMethod, tsType);
        requestUtils.serviceUrl = serviceUrl;
        requestUtils.appkey = appkey;
        requestUtils.appSecret = appSecret;
        requestUtils.httpClientUtils = HttpClientUtils.getInstance(proxyHost, proxyPort);
        return requestUtils;
    }

    public <B> ResultInfo<B> doPost(String path) {
        Map<String, Object> req = null;
        return this.doPost(path, req);
    }

    public <B> ResultInfo<B> doPost(String path, Map<String, Object> req) {
        String url = this.serviceUrl + path;
        if (req == null) {
            req = new HashMap<String, Object>();
        }
        this.fillSign(req);
        String str = this.httpClientUtils.getPost(url, null, req, true);
        try {
            return (ResultInfo)JSONObject.parseObject((String)str, (TypeReference)new TypeReference<ResultInfo<B>>(){}, (Feature[])new Feature[0]);
        }
        catch (RuntimeException e) {
            if (str != null) {
                log.error("remote.response:" + str);
            }
            throw e;
        }
    }

    public <B> ResultInfo<B> doPost(String path, Req2MapInterface req) {
        Assert.notNull(req, "req is null");
        return this.doPost(path, req.toMap());
    }

    private void fillSign(Map<String, Object> req) {
        String sign;
        long ts = System.currentTimeMillis();
        if (this.tsType == 2) {
            ts = System.currentTimeMillis() / 1000L;
        }
        String nonce = DigestUtils.md5Hex((String)(System.currentTimeMillis() + ""));
        String signSrc = "nonce" + nonce + "ts" + ts + "app_key" + this.appkey + "app_secret" + this.appSecret;
        if (this.encryMethod == null || this.encryMethod.equalsIgnoreCase("sha256")) {
            sign = DigestUtils.sha256Hex((String)signSrc);
        } else if (this.encryMethod.equalsIgnoreCase("sha1")) {
            sign = DigestUtils.sha1Hex((String)signSrc);
        } else if (this.encryMethod.equalsIgnoreCase("md5")) {
            sign = DigestUtils.md5Hex((String)signSrc);
        } else if (this.encryMethod.equalsIgnoreCase("sha3-256")) {
            sign = DigestUtils.sha3_256Hex((String)signSrc);
        } else {
            throw new ResultInfoException("HTTP_PARAM_ERROR", this.encryMethod + ",\u5fc5\u987b\u4e3amd5,sha1,sha256,sha3-256\u4e4b\u4e00");
        }
        req.put("ts", ts);
        req.put("app_key", this.appkey);
        req.put("sign", sign);
        req.put("nonce", nonce);
        if (this.encryMethod != null) {
            req.put("encry_method", this.encryMethod);
        }
    }

    public HttpClientUtils getHttpClientUtils() {
        return this.httpClientUtils;
    }
}

