/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest;

import java.util.Objects;
import kong.unirest.JsonPatchOperation;
import kong.unirest.json.JSONObject;

public class JsonPatchItem {
    private final JsonPatchOperation op;
    private final String path;
    private final Object value;

    public JsonPatchItem(JsonPatchOperation op, String path, Object value) {
        this.op = op;
        this.path = path;
        this.value = value;
    }

    public JsonPatchItem(JsonPatchOperation op, String path) {
        this(op, path, null);
    }

    public JsonPatchItem(JSONObject row) {
        this.op = JsonPatchOperation.valueOf(row.getString("op"));
        this.path = row.getString("path");
        this.value = row.has(this.op.getOperationtype()) ? row.get(this.op.getOperationtype()) : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonPatchItem that = (JsonPatchItem)o;
        return this.op == that.op && Objects.equals(this.path, that.path) && Objects.equals(this.toString(), that.toString());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.op, this.path, this.value});
    }

    public String toString() {
        JSONObject json = new JSONObject().put("op", this.op).put("path", this.path);
        if (Objects.nonNull(this.value)) {
            json.put(this.op.getOperationtype(), this.value);
        }
        return json.toString();
    }

    public JsonPatchOperation getOp() {
        return this.op;
    }

    public String getPath() {
        return this.path;
    }

    public Object getValue() {
        return this.value;
    }
}

