/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.abc.location;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import androidx.core.app.ActivityCompat;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationResult;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.location.LocationSettingsRequest;
import com.google.android.gms.tasks.CancellationTokenSource;
import com.linecorp.abc.location.ABCLocation;
import com.linecorp.abc.location.ABCLocationRequest;
import com.linecorp.abc.location.Coordinates;
import com.linecorp.abc.location.LocationData;
import com.linecorp.abc.location.extension.ABCLocationExtKt;
import com.linecorp.abc.location.observers.ActivityLifecycleObserver;
import com.linecorp.abc.location.utils.LocationUtil;
import java.lang.constant.Constable;
import java.lang.ref.WeakReference;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u0019J\b\u0010\u001a\u001a\u00020\u0016H\u0007J\u0006\u0010\u001b\u001a\u00020\u001cJ/\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u00142\u000e\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010!0 2\u0006\u0010\"\u001a\u00020#H\u0000\u00a2\u0006\u0004\b$\u0010%J\u0006\u0010&\u001a\u00020\u0016J\u000e\u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020\u0001J\u0006\u0010)\u001a\u00020\u0016J\u000e\u0010*\u001a\u00020\u00162\u0006\u0010+\u001a\u00020,J\r\u0010-\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b.J\b\u0010/\u001a\u00020\u0016H\u0007J\u0006\u00100\u001a\u00020\u0016R\"\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\u0004\u0018\u00010\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00020\u000e8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/linecorp/abc/location/LocationManager;", "", "()V", "activity", "Ljava/lang/ref/WeakReference;", "Landroid/app/Activity;", "getActivity$kmm_location_release", "()Ljava/lang/ref/WeakReference;", "setActivity$kmm_location_release", "(Ljava/lang/ref/WeakReference;)V", "focusedActivity", "getFocusedActivity", "()Landroid/app/Activity;", "fusedLocationClient", "Lcom/google/android/gms/location/FusedLocationProviderClient;", "locationCallback", "Lcom/google/android/gms/location/LocationCallback;", "locationRequest", "Lcom/google/android/gms/location/LocationRequest;", "requestPermissionsRequestCode", "", "configure", "", "context", "Landroid/content/Context;", "configure$kmm_location_release", "getCurrentLocation", "isPermissionAllowed", "", "processRequestPermissionsResult", "requestCode", "permissions", "", "", "grantResults", "", "processRequestPermissionsResult$kmm_location_release", "(I[Ljava/lang/String;[I)V", "removeAllListeners", "removeListeners", "target", "requestPermission", "setLocationRequest", "abcLocationRequest", "Lcom/linecorp/abc/location/ABCLocationRequest;", "showNotificationSetting", "showNotificationSetting$kmm_location_release", "startLocationUpdating", "stopLocationUpdating", "kmm-location_release"})
public final class LocationManager {
    @Nullable
    private WeakReference<Activity> activity;
    private final int requestPermissionsRequestCode;
    @SuppressLint(value={"StaticFieldLeak"})
    private FusedLocationProviderClient fusedLocationClient;
    private LocationCallback locationCallback;
    @NotNull
    private LocationRequest locationRequest;

    /*
     * WARNING - void declaration
     */
    public LocationManager() {
        void $this$locationRequest_u24lambda_u2d14;
        this.requestPermissionsRequestCode = 4885;
        LocationRequest locationRequest = LocationRequest.create();
        boolean bl = false;
        boolean bl2 = false;
        LocationRequest locationRequest2 = locationRequest;
        LocationManager locationManager2 = this;
        boolean bl3 = false;
        $this$locationRequest_u24lambda_u2d14.setPriority(100);
        $this$locationRequest_u24lambda_u2d14.setFastestInterval(1000L);
        $this$locationRequest_u24lambda_u2d14.setInterval(10000L);
        Unit unit = Unit.INSTANCE;
        LocationRequest locationRequest3 = locationRequest;
        Intrinsics.checkNotNullExpressionValue((Object)locationRequest3, (String)"create().apply {\n        priority = LocationRequest.PRIORITY_HIGH_ACCURACY\n        fastestInterval = 1 * 1000L\n        interval = 10 * 1000L\n    }");
        locationManager2.locationRequest = locationRequest3;
    }

    public final boolean isPermissionAllowed() {
        boolean bl;
        Activity activity = this.getFocusedActivity();
        if (activity == null) {
            bl = false;
        } else {
            boolean bl2;
            Activity activity2 = activity;
            boolean bl3 = false;
            boolean bl4 = false;
            Activity it = activity2;
            boolean bl5 = false;
            bl = bl2 = ActivityCompat.checkSelfPermission((Context)((Context)it), (String)"android.permission.ACCESS_FINE_LOCATION") == 0 || ActivityCompat.checkSelfPermission((Context)((Context)it), (String)"android.permission.ACCESS_COARSE_LOCATION") == 0;
        }
        return bl;
    }

    public final void removeAllListeners() {
    }

    public final void removeListeners(@NotNull Object target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
    }

    public final void requestPermission() {
        String[] stringArray = this.getFocusedActivity();
        if (stringArray == null) {
            LocationManager locationManager2 = this;
            boolean bl = false;
            boolean bl2 = false;
            LocationManager $this$requestPermission_u24lambda_u2d1 = locationManager2;
            boolean bl3 = false;
            ABCLocation.Companion.notifyOnLocationUnavailable$kmm_location_release();
            return;
        }
        String[] activity = stringArray;
        stringArray = new String[]{"android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_COARSE_LOCATION"};
        ActivityCompat.requestPermissions((Activity)activity, (String[])stringArray, (int)this.requestPermissionsRequestCode);
    }

    @SuppressLint(value={"MissingPermission"})
    public final void startLocationUpdating() {
        Activity activity = this.getFocusedActivity();
        if (activity == null) {
            LocationManager locationManager2 = this;
            boolean bl = false;
            boolean bl2 = false;
            LocationManager $this$startLocationUpdating_u24lambda_u2d2 = locationManager2;
            boolean bl3 = false;
            ABCLocation.Companion.notifyOnLocationUnavailable$kmm_location_release();
            return;
        }
        Activity activity2 = activity;
        if (!this.isPermissionAllowed()) {
            this.requestPermission();
            ABCLocation.Companion.notifyOnLocationUnavailable$kmm_location_release();
        } else if (!LocationUtil.INSTANCE.checkLocationEnable((Context)activity2)) {
            ABCLocation.Companion.notifyOnLocationUnavailable$kmm_location_release();
        } else {
            activity = this.fusedLocationClient;
            if (activity == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"fusedLocationClient");
                throw null;
            }
            Activity activity3 = activity;
            activity = this.locationCallback;
            if (activity == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"locationCallback");
                throw null;
            }
            activity3.requestLocationUpdates(this.locationRequest, (LocationCallback)activity, Looper.getMainLooper());
        }
    }

    public final void stopLocationUpdating() {
        FusedLocationProviderClient fusedLocationProviderClient = this.fusedLocationClient;
        if (fusedLocationProviderClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fusedLocationClient");
            throw null;
        }
        FusedLocationProviderClient fusedLocationProviderClient2 = fusedLocationProviderClient;
        fusedLocationProviderClient = this.locationCallback;
        if (fusedLocationProviderClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"locationCallback");
            throw null;
        }
        fusedLocationProviderClient2.removeLocationUpdates((LocationCallback)fusedLocationProviderClient);
    }

    @SuppressLint(value={"MissingPermission"})
    public final void getCurrentLocation() {
        Activity activity = this.getFocusedActivity();
        if (activity == null) {
            LocationManager locationManager2 = this;
            boolean bl = false;
            boolean bl2 = false;
            LocationManager $this$getCurrentLocation_u24lambda_u2d3 = locationManager2;
            boolean bl3 = false;
            ABCLocation.Companion.notifyOnLocationUnavailable$kmm_location_release();
            return;
        }
        Activity activity2 = activity;
        Ref.BooleanRef isLocationNotified = new Ref.BooleanRef();
        if (!this.isPermissionAllowed()) {
            this.requestPermission();
            ABCLocation.Companion.notifyOnLocationUnavailable$kmm_location_release();
        } else if (!LocationUtil.INSTANCE.checkLocationEnable((Context)activity2)) {
            ABCLocation.Companion.notifyOnLocationUnavailable$kmm_location_release();
        } else {
            CancellationTokenSource cts = new CancellationTokenSource();
            FusedLocationProviderClient fusedLocationProviderClient = this.fusedLocationClient;
            if (fusedLocationProviderClient == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"fusedLocationClient");
                throw null;
            }
            fusedLocationProviderClient.getCurrentLocation(100, cts.getToken()).addOnSuccessListener(arg_0 -> LocationManager.getCurrentLocation$lambda-4(isLocationNotified, this, arg_0)).addOnFailureListener(LocationManager::getCurrentLocation$lambda-5);
            new Handler(Looper.getMainLooper()).postDelayed(() -> LocationManager.getCurrentLocation$lambda-8(isLocationNotified, this), 5000L);
            new Handler(Looper.getMainLooper()).postDelayed(() -> LocationManager.getCurrentLocation$lambda-9(isLocationNotified), 10000L);
        }
    }

    @Nullable
    public final WeakReference<Activity> getActivity$kmm_location_release() {
        return this.activity;
    }

    public final void setActivity$kmm_location_release(@Nullable WeakReference<Activity> weakReference) {
        this.activity = weakReference;
    }

    public final void configure$kmm_location_release(@NotNull Context context) {
        Unit unit;
        Application application;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Context context2 = context.getApplicationContext();
        Object object = application = context2 instanceof Application ? (Application)context2 : null;
        if (object == null) {
            unit = null;
        } else {
            object.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)ActivityLifecycleObserver.INSTANCE);
            unit = context2 = Unit.INSTANCE;
        }
        if (context2 == null) {
            object = this;
            boolean bl = false;
            boolean bl2 = false;
            LocationManager $this$configure_u24lambda_u2d10 = (LocationManager)object;
            boolean bl3 = false;
            Context context3 = context.getApplicationContext();
            Activity activity = context3 instanceof Activity ? (Activity)context3 : null;
            $this$configure_u24lambda_u2d10.setActivity$kmm_location_release(new WeakReference<Activity>(activity));
        }
        context2 = LocationServices.getFusedLocationProviderClient((Context)context);
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getFusedLocationProviderClient(context)");
        this.fusedLocationClient = context2;
        this.locationCallback = new LocationCallback(){

            public void onLocationResult(@Nullable LocationResult locationResult) {
                List list;
                Location location;
                LocationResult locationResult2 = locationResult;
                Location location2 = locationResult2 == null ? null : (location = (list = locationResult2.getLocations()) == null ? null : (Location)CollectionsKt.last((List)list));
                if (location == null) {
                    return;
                }
                Location location3 = location;
                Coordinates coordinates = new Coordinates(location3.getLatitude(), location3.getLongitude());
                LocationData data = new LocationData(location3.getAccuracy(), location3.getAltitude(), 0.0, location3.getBearing(), location3.getSpeed(), coordinates);
                ABCLocation.Companion.notifyOnLocationUpdated$kmm_location_release(data);
            }
        };
        LocationSettingsRequest settings = new LocationSettingsRequest.Builder().addLocationRequest(this.locationRequest).build();
        LocationServices.getSettingsClient((Context)context).checkLocationSettings(settings);
    }

    public final void processRequestPermissionsResult$kmm_location_release(int requestCode, @NotNull String[] permissions, @NotNull int[] grantResults) {
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        Intrinsics.checkNotNullParameter((Object)grantResults, (String)"grantResults");
        int n = requestCode;
        if (n == this.requestPermissionsRequestCode) {
            int[] nArray = grantResults;
            boolean bl = false;
            if (nArray.length == 0) {
                return;
            }
            int n2 = grantResults[0];
            switch (n2) {
                case 0: {
                    this.startLocationUpdating();
                    ABCLocation.Companion.notifyOnPermissionUpdated$kmm_location_release(true);
                    break;
                }
                case -1: {
                    ABCLocation.Companion.notifyOnPermissionUpdated$kmm_location_release(false);
                    break;
                }
            }
        }
    }

    public final void showNotificationSetting$kmm_location_release() {
        Activity activity = this.getFocusedActivity();
        if (activity == null) {
            LocationManager locationManager2 = this;
            boolean bl = false;
            boolean bl2 = false;
            LocationManager $this$showNotificationSetting_u24lambda_u2d11 = locationManager2;
            boolean bl3 = false;
            ABCLocation.Companion.notifyOnLocationUnavailable$kmm_location_release();
            return;
        }
        Activity activity2 = activity;
        activity = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        boolean bl = false;
        boolean bl4 = false;
        Activity $this$showNotificationSetting_u24lambda_u2d12 = activity;
        boolean bl5 = false;
        $this$showNotificationSetting_u24lambda_u2d12.setFlags(0x10008000);
        $this$showNotificationSetting_u24lambda_u2d12.setData(Uri.fromParts((String)"package", (String)activity2.getApplicationInfo().packageName, null));
        activity2.startActivity((Intent)$this$showNotificationSetting_u24lambda_u2d12);
    }

    private final Activity getFocusedActivity() {
        Activity activity;
        WeakReference<Activity> weakReference = this.activity;
        if (weakReference == null) {
            activity = null;
        } else {
            Activity activity2 = (Activity)weakReference.get();
            if (activity2 == null) {
                activity = null;
            } else {
                Activity activity3 = activity2;
                boolean bl = false;
                boolean bl2 = false;
                Activity it = activity3;
                boolean bl3 = false;
                activity = it.isFinishing() || it.isDestroyed() ? null : it;
            }
        }
        return activity;
    }

    /*
     * WARNING - void declaration
     */
    public final void setLocationRequest(@NotNull ABCLocationRequest abcLocationRequest) {
        long it;
        boolean bl;
        boolean bl2;
        Long l;
        void $this$setLocationRequest_u24lambda_u2d22;
        Intrinsics.checkNotNullParameter((Object)abcLocationRequest, (String)"abcLocationRequest");
        LocationRequest locationRequest = LocationRequest.create();
        boolean bl3 = false;
        boolean bl4 = false;
        LocationRequest locationRequest2 = locationRequest;
        LocationManager locationManager2 = this;
        boolean bl5 = false;
        $this$setLocationRequest_u24lambda_u2d22.setPriority(abcLocationRequest.getPriority().getValue());
        Constable constable = abcLocationRequest.getFastestInterval();
        if (constable != null) {
            l = constable;
            bl2 = false;
            bl = false;
            it = ((Number)l).longValue();
            boolean bl6 = false;
            $this$setLocationRequest_u24lambda_u2d22.setFastestInterval(it);
        }
        constable = abcLocationRequest.getInterval();
        if (constable != null) {
            l = constable;
            bl2 = false;
            bl = false;
            it = ((Number)l).longValue();
            boolean bl7 = false;
            $this$setLocationRequest_u24lambda_u2d22.setInterval(it);
        }
        constable = abcLocationRequest.getMaxWaitTime();
        if (constable != null) {
            l = constable;
            bl2 = false;
            bl = false;
            it = ((Number)l).longValue();
            boolean bl8 = false;
            $this$setLocationRequest_u24lambda_u2d22.setMaxWaitTime(it);
        }
        constable = abcLocationRequest.getSmallestDisplacement();
        if (constable != null) {
            l = constable;
            bl2 = false;
            bl = false;
            float it2 = ((Number)l).floatValue();
            boolean bl9 = false;
            $this$setLocationRequest_u24lambda_u2d22.setSmallestDisplacement(it2);
        }
        constable = abcLocationRequest.isWaitForAccurateLocation();
        if (constable != null) {
            l = constable;
            bl2 = false;
            bl = false;
            boolean it3 = (Boolean)((Object)l);
            boolean bl10 = false;
            $this$setLocationRequest_u24lambda_u2d22.setWaitForAccurateLocation(it3);
        }
        constable = abcLocationRequest.getNumUpdates();
        if (constable != null) {
            l = constable;
            bl2 = false;
            bl = false;
            int it4 = ((Number)l).intValue();
            boolean bl11 = false;
            $this$setLocationRequest_u24lambda_u2d22.setNumUpdates(it4);
        }
        constable = abcLocationRequest.getExpirationTime();
        if (constable != null) {
            l = constable;
            bl2 = false;
            bl = false;
            it = ((Number)l).longValue();
            boolean bl12 = false;
            $this$setLocationRequest_u24lambda_u2d22.setExpirationTime(it);
        }
        Unit unit = Unit.INSTANCE;
        LocationRequest locationRequest3 = locationRequest;
        Intrinsics.checkNotNullExpressionValue((Object)locationRequest3, (String)"create().apply {\n            priority = abcLocationRequest.priority.value\n            abcLocationRequest.fastestInterval?.let { fastestInterval = it }\n            abcLocationRequest.interval?.let { interval = it }\n            abcLocationRequest.maxWaitTime?.let { maxWaitTime = it }\n            abcLocationRequest.smallestDisplacement?.let { smallestDisplacement = it }\n            abcLocationRequest.isWaitForAccurateLocation?.let { isWaitForAccurateLocation = it }\n            abcLocationRequest.numUpdates?.let { numUpdates = it }\n            abcLocationRequest.expirationTime?.let { expirationTime = it }\n        }");
        locationManager2.locationRequest = locationRequest3;
    }

    private static final void getCurrentLocation$lambda-4(Ref.BooleanRef $isLocationNotified, LocationManager this$0, Location locationResult) {
        Intrinsics.checkNotNullParameter((Object)$isLocationNotified, (String)"$isLocationNotified");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        $isLocationNotified.element = true;
        Intrinsics.checkNotNullExpressionValue((Object)locationResult, (String)"locationResult");
        ABCLocation.Companion.notifyOnLocationUpdated$kmm_location_release(ABCLocationExtKt.toLocationData(locationResult));
        FusedLocationProviderClient fusedLocationProviderClient = this$0.fusedLocationClient;
        if (fusedLocationProviderClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fusedLocationClient");
            throw null;
        }
        FusedLocationProviderClient fusedLocationProviderClient2 = fusedLocationProviderClient;
        fusedLocationProviderClient = this$0.locationCallback;
        if (fusedLocationProviderClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"locationCallback");
            throw null;
        }
        fusedLocationProviderClient2.requestLocationUpdates(this$0.locationRequest, (LocationCallback)fusedLocationProviderClient, Looper.getMainLooper());
    }

    private static final void getCurrentLocation$lambda-5(Exception it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }

    private static final void getCurrentLocation$lambda-8$lambda-6(Ref.BooleanRef $isLocationNotified, LocationManager this$0, Location locationResult) {
        Intrinsics.checkNotNullParameter((Object)$isLocationNotified, (String)"$isLocationNotified");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        $isLocationNotified.element = true;
        Intrinsics.checkNotNullExpressionValue((Object)locationResult, (String)"locationResult");
        ABCLocation.Companion.notifyOnLocationUpdated$kmm_location_release(ABCLocationExtKt.toLocationData(locationResult));
        FusedLocationProviderClient fusedLocationProviderClient = this$0.fusedLocationClient;
        if (fusedLocationProviderClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fusedLocationClient");
            throw null;
        }
        FusedLocationProviderClient fusedLocationProviderClient2 = fusedLocationProviderClient;
        fusedLocationProviderClient = this$0.locationCallback;
        if (fusedLocationProviderClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"locationCallback");
            throw null;
        }
        fusedLocationProviderClient2.requestLocationUpdates(this$0.locationRequest, (LocationCallback)fusedLocationProviderClient, Looper.getMainLooper());
    }

    private static final void getCurrentLocation$lambda-8$lambda-7(Exception it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }

    private static final void getCurrentLocation$lambda-8(Ref.BooleanRef $isLocationNotified, LocationManager this$0) {
        Intrinsics.checkNotNullParameter((Object)$isLocationNotified, (String)"$isLocationNotified");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (!$isLocationNotified.element) {
            FusedLocationProviderClient fusedLocationProviderClient = this$0.fusedLocationClient;
            if (fusedLocationProviderClient == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"fusedLocationClient");
                throw null;
            }
            fusedLocationProviderClient.getLastLocation().addOnSuccessListener(arg_0 -> LocationManager.getCurrentLocation$lambda-8$lambda-6($isLocationNotified, this$0, arg_0)).addOnFailureListener(LocationManager::getCurrentLocation$lambda-8$lambda-7);
        }
    }

    private static final void getCurrentLocation$lambda-9(Ref.BooleanRef $isLocationNotified) {
        Intrinsics.checkNotNullParameter((Object)$isLocationNotified, (String)"$isLocationNotified");
        if (!$isLocationNotified.element) {
            ABCLocation.Companion.notifyOnLocationUnavailable$kmm_location_release();
        }
    }
}

