/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.lich.static_analysis.detectors;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UNamedExpression;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u00012\u00020\u0002:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0014\u0010\u0011\u001a\u00020\f*\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/linecorp/lich/static_analysis/detectors/OptionalArgumentRequiredDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "getApplicableMethodNames", "", "", "isOptionalArgument", "", "node", "Lorg/jetbrains/uast/UCallExpression;", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "method", "Lcom/intellij/psi/PsiMethod;", "report", "Companion", "static-analysis"})
public final class OptionalArgumentRequiredDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final Issue ISSUE = Issue.Companion.create("ArgumentInitializationInconsistency", "Argument inconsistency: the argument is annotated as optional but it is initialized as required.", "An argument annotated as optional can not be initialized as `required`. Remove the annotation or provide another initialization mechanism like `initial`.", Category.CORRECTNESS, 6, Severity.ERROR, new Implementation(OptionalArgumentRequiredDetector.class, Scope.JAVA_FILE_SCOPE));
    @NotNull
    private static final String argumentAnnotationQualifiedName = "com.linecorp.lich.savedstate.Argument";
    @NotNull
    private static final String savedStatesQualifiedName = "com.linecorp.lich.savedstate.SavedStatesKt";

    private final void report(JavaContext $this$report, UCallExpression node) {
        JavaContext.report$default((JavaContext)$this$report, (Issue)ISSUE, (UElement)((UElement)node), (Location)$this$report.getNameLocation((UElement)node), (String)"Optional argument initialized as required.", null, (int)16, null);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isOptionalArgument(UCallExpression node) {
        void $this$evaluateOrDefault$iv;
        Object v2;
        Object object;
        block9: {
            UElement uElement;
            int n;
            UElement $this$findClosestParentByType_u24default$iv;
            block8: {
                $this$findClosestParentByType_u24default$iv = (UElement)node;
                boolean ancestorLevel$iv = true;
                boolean $i$f$findClosestParentByType = false;
                int currentAncestorLevel$iv = 0;
                for (UElement node$iv = (var8_7 = $this$findClosestParentByType_u24default$iv) == null ? null : var8_7.getUastParent(); node$iv != null; node$iv = node$iv.getUastParent()) {
                    if (node$iv instanceof UField) {
                        n = currentAncestorLevel$iv;
                        currentAncestorLevel$iv = n + 1;
                    }
                    if (currentAncestorLevel$iv != ancestorLevel$iv) continue;
                    UElement uElement2 = node$iv;
                    if (!(uElement2 instanceof UField)) {
                        uElement2 = null;
                    }
                    uElement = (UElement)((UField)uElement2);
                    break block8;
                }
                uElement = null;
            }
            UField uField = (UField)uElement;
            if (uField == null) {
                return false;
            }
            UField field = uField;
            $this$findClosestParentByType_u24default$iv = field.findAnnotation(argumentAnnotationQualifiedName);
            if ($this$findClosestParentByType_u24default$iv == null) {
                return false;
            }
            UElement argumentAnnotation = $this$findClosestParentByType_u24default$iv;
            Iterable $i$f$findClosestParentByType = argumentAnnotation.getAttributeValues();
            boolean node$iv = false;
            object = $i$f$findClosestParentByType;
            n = 0;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Object t = iterator.next();
                UNamedExpression it = (UNamedExpression)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"isOptional")) continue;
                v2 = t;
                break block9;
            }
            v2 = null;
        }
        UNamedExpression ancestorLevel$iv = v2;
        if (ancestorLevel$iv == null) {
            return false;
        }
        UNamedExpression isOptionalAttribute = ancestorLevel$iv;
        ancestorLevel$iv = isOptionalAttribute.getExpression();
        Boolean defaultValue$iv = false;
        boolean $i$f$evaluateOrDefault = false;
        Object object2 = $this$evaluateOrDefault$iv.evaluate();
        if (!(object2 instanceof Boolean)) {
            object2 = null;
        }
        return (Boolean)((object = (Boolean)object2) == null ? defaultValue$iv : object);
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (Lint.isKotlin((PsiElement)((PsiElement)method)) && context.getEvaluator().isMemberInClass((PsiMember)method, savedStatesQualifiedName) && this.isOptionalArgument(node)) {
            this.report(context, node);
        }
    }

    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)"required");
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/linecorp/lich/static_analysis/detectors/OptionalArgumentRequiredDetector$Companion;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "argumentAnnotationQualifiedName", "", "savedStatesQualifiedName", "static-analysis"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

